/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.decider;

import java.lang.reflect.Method;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.migration.Migration;

public class MigrationTestExecutionDecider
implements TestExecutionDecider {
    private final Logger log = Logger.getLogger(MigrationTestExecutionDecider.class);
    private static final String MIGRATED_AUTH_SERVER_VERSION_PROPERTY = "migrated.auth.server.version";

    public ExecutionDecision decide(Method method) {
        String migratedAuthServerVersion = System.getProperty(MIGRATED_AUTH_SERVER_VERSION_PROPERTY);
        boolean migrationTest = migratedAuthServerVersion != null;
        Migration migrationAnnotation = method.getAnnotation(Migration.class);
        if (migrationTest && migrationAnnotation != null) {
            this.log.info((Object)("migration from version: " + migratedAuthServerVersion));
            String versionFrom = migrationAnnotation.versionFrom();
            if (migratedAuthServerVersion.startsWith(versionFrom)) {
                return ExecutionDecision.execute();
            }
            return ExecutionDecision.dontExecute((String)(method.getName() + "doesn't fit with migration version."));
        }
        if (migrationTest && migrationAnnotation == null || !migrationTest && migrationAnnotation != null) {
            return ExecutionDecision.dontExecute((String)"Migration test and no migration annotation or no migration test and migration annotation");
        }
        return ExecutionDecision.execute();
    }

    public int precedence() {
        return 2;
    }
}

