/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.decider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;

public class AdapterTestExecutionDecider
implements TestExecutionDecider {
    @Inject
    private Instance<TestContext> testContextInstance;

    public ExecutionDecision decide(Method method) {
        TestContext testContext = (TestContext)this.testContextInstance.get();
        if (!testContext.isAdapterTest()) {
            return ExecutionDecision.execute();
        }
        if (testContext.isAdapterContainerEnabled() || testContext.isAdapterContainerEnabledCluster()) {
            if (method.isAnnotationPresent(AppServerContainers.class) || method.isAnnotationPresent(AppServerContainer.class)) {
                if (this.getCorrespondingAnnotation(method) == null) {
                    if (this.getCorrespondingAnnotation(testContext.getTestClass()).skip()) {
                        return ExecutionDecision.dontExecute((String)"Skipped by @AppServerContainer class level annotation.");
                    }
                } else if (this.getCorrespondingAnnotation(method).skip()) {
                    return ExecutionDecision.dontExecute((String)"Skipped by @AppServerContainer method level annotation.");
                }
            } else if (this.getCorrespondingAnnotation(testContext.getTestClass()) == null || this.getCorrespondingAnnotation(testContext.getTestClass()).skip()) {
                return ExecutionDecision.dontExecute((String)"Skipped by @AppServerContainer class level annotation.");
            }
            return ExecutionDecision.execute();
        }
        return ExecutionDecision.dontExecute((String)"Not enabled by @AppServerContainer annotations.");
    }

    public int precedence() {
        return 1;
    }

    private AppServerContainer getCorrespondingAnnotation(Method method) {
        AppServerContainers multipleAnnotations = method.getAnnotation(AppServerContainers.class);
        List<AppServerContainer> appServerContainers = multipleAnnotations != null ? Arrays.asList(multipleAnnotations.value()) : Arrays.asList(method.getAnnotation(AppServerContainer.class));
        return appServerContainers.stream().filter(annotation -> annotation.value().equals(((TestContext)this.testContextInstance.get()).getAppServerContainerName())).findFirst().orElse(null);
    }

    private AppServerContainer getCorrespondingAnnotation(Class testClass) {
        Class annotatedClass = AppServerTestEnricher.getNearestSuperclassWithAppServerAnnotation(testClass);
        AppServerContainers multipleAnnotations = annotatedClass.getAnnotation(AppServerContainers.class);
        List<AppServerContainer> appServerContainers = multipleAnnotations != null ? Arrays.asList(multipleAnnotations.value()) : Arrays.asList(annotatedClass.getAnnotation(AppServerContainer.class));
        return appServerContainers.stream().filter(annotation -> annotation.value().equals(((TestContext)this.testContextInstance.get()).getAppServerContainerName())).findFirst().orElse(null);
    }
}

