/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.config.descriptor.impl.GroupDefImpl;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptor;
import org.keycloak.testsuite.arquillian.container.AppServerContainerService;
import org.keycloak.testsuite.arquillian.containers.Registry;
import org.keycloak.testsuite.arquillian.containers.SecurityActions;
import org.mvel2.MVEL;

public class RegistryCreator {
    protected final Logger log = Logger.getLogger(this.getClass());
    public static final String ADAPTER_IMPL_CONFIG_STRING = "adapterImplClass";
    private static final String ENABLED = "enabled";
    @Inject
    @ApplicationScoped
    private InstanceProducer<ContainerRegistry> registry;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<ServiceLoader> loader;

    public void createRegistry(@Observes ArquillianDescriptor event) {
        Registry reg = new Registry((Injector)this.injector.get());
        ServiceLoader serviceLoader = (ServiceLoader)this.loader.get();
        this.log.info((Object)("arquillian.xml: " + System.getProperty("arquillian.xml")));
        Collection containers = serviceLoader.all(DeployableContainer.class);
        if (containers.isEmpty()) {
            throw new IllegalStateException("There are not any container adapters on the classpath");
        }
        List containersDefs = event.getContainers();
        List groupDefs = event.getGroups();
        this.addAppServerContainers(containersDefs, groupDefs);
        this.createRegistry(containersDefs, reg, serviceLoader);
        for (GroupDef group : groupDefs) {
            this.createRegistry(group.getGroupContainers(), reg, serviceLoader);
        }
        this.registry.set((Object)reg);
    }

    private void createRegistry(List<ContainerDef> containerDefs, ContainerRegistry reg, ServiceLoader serviceLoader) {
        for (ContainerDef container : containerDefs) {
            if (!this.isAdapterImplClassAvailable(container)) continue;
            if (RegistryCreator.isEnabled(container)) {
                this.log.info((Object)("Registering container: " + container.getContainerName()));
                reg.create(container, serviceLoader);
                continue;
            }
            this.log.info((Object)("Container is disabled: " + container.getContainerName()));
        }
    }

    private void addAppServerContainers(List<ContainerDef> containerDefs, List<GroupDef> groupDefs) {
        Node parent = ((NodeDescriptor)containerDefs.get(0)).getRootNode();
        String appServerName = System.getProperty("app.server", "undertow");
        List containers = AppServerContainerService.getInstance().getContainers(appServerName);
        if (containers == null) {
            this.log.warn((Object)"None dynamically loaded containers");
            return;
        }
        for (Node container : containers) {
            if (container.getName().equals("container")) {
                containerDefs.add((ContainerDef)new ContainerDefImpl("arquillian.xml", parent, container));
                continue;
            }
            if (!container.getName().equals("group")) continue;
            groupDefs.add((GroupDef)new GroupDefImpl("arquillian.xml", parent, container));
        }
    }

    private static boolean isEnabled(ContainerDef containerDef) {
        Map props = containerDef.getContainerProperties();
        try {
            return !props.containsKey(ENABLED) || props.containsKey(ENABLED) && !((String)props.get(ENABLED)).isEmpty() && MVEL.evalToBoolean((String)((String)props.get(ENABLED)), null) != false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isAdapterImplClassAvailable(ContainerDef containerDef) {
        if (RegistryCreator.hasAdapterImplClassProperty(containerDef)) {
            if (SecurityActions.isClassPresent(RegistryCreator.getAdapterImplClassValue(containerDef))) {
                return DeployableContainer.class.isAssignableFrom(SecurityActions.loadClass(RegistryCreator.getAdapterImplClassValue(containerDef)));
            }
            this.log.warn((Object)("Cannot load adapterImpl class for " + containerDef.getContainerName()));
        }
        return false;
    }

    public static boolean hasAdapterImplClassProperty(ContainerDef containerDef) {
        for (Map.Entry entry : containerDef.getContainerProperties().entrySet()) {
            if (!((String)entry.getKey()).equals(ADAPTER_IMPL_CONFIG_STRING)) continue;
            return true;
        }
        return false;
    }

    public static String getAdapterImplClassValue(ContainerDef containerDef) {
        return ((String)containerDef.getContainerProperties().get(ADAPTER_IMPL_CONFIG_STRING)).trim();
    }

    public static DeployableContainer<?> getContainerAdapter(String adapterImplClass, Collection<DeployableContainer> containers) {
        Validate.notNullOrEmpty((String)adapterImplClass, (String)"The value of adapterImplClass can not be a null object nor an empty string!");
        if (!SecurityActions.isClassPresent(adapterImplClass)) {
            return null;
        }
        Class<?> foundAdapter = SecurityActions.loadClass(adapterImplClass);
        for (DeployableContainer container : containers) {
            if (!foundAdapter.isInstance(container)) continue;
            return container;
        }
        return null;
    }
}

