/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.logging.Logger;
import org.keycloak.util.JsonSerialization;

public class KeycloakQuarkusConfiguration
implements ContainerConfiguration {
    protected static final Logger log = Logger.getLogger(KeycloakQuarkusConfiguration.class);
    private int bindHttpPortOffset = 100;
    private int bindHttpPort = 8080;
    private int bindHttpsPortOffset = 0;
    private int bindHttpsPort = Integer.valueOf(System.getProperty("auth.server.https.port", "8543"));
    private int debugPort = -1;
    private Path providersPath = Paths.get(System.getProperty("auth.server.home"), new String[0]);
    private int startupTimeoutInSeconds = 300;
    private String route;
    private String keycloakConfigPropertyOverrides;
    private HashMap<String, Object> keycloakConfigPropertyOverridesMap;
    private String profile;
    private String javaOpts;
    private boolean reaugmentBeforeStart;

    public void validate() throws ConfigurationException {
        int basePort = this.getBindHttpPort();
        int newPort = basePort + this.bindHttpPortOffset;
        this.setBindHttpPort(newPort);
        int baseHttpsPort = this.getBindHttpsPort();
        int newHttpsPort = baseHttpsPort + this.bindHttpsPortOffset;
        this.setBindHttpsPort(newHttpsPort);
        log.info((Object)("Keycloak will listen for http on port: " + newPort + " and for https on port: " + newHttpsPort));
        if (this.keycloakConfigPropertyOverrides != null) {
            try {
                TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
                this.keycloakConfigPropertyOverridesMap = (HashMap)JsonSerialization.sysPropertiesAwareMapper.readValue(this.keycloakConfigPropertyOverrides, (TypeReference)typeRef);
            }
            catch (IOException ex) {
                throw new ConfigurationException((Throwable)ex);
            }
        }
    }

    public int getBindHttpPortOffset() {
        return this.bindHttpPortOffset;
    }

    public void setBindHttpPortOffset(int bindHttpPortOffset) {
        this.bindHttpPortOffset = bindHttpPortOffset;
    }

    public int getBindHttpsPortOffset() {
        return this.bindHttpsPortOffset;
    }

    public void setBindHttpsPortOffset(int bindHttpsPortOffset) {
        this.bindHttpsPortOffset = bindHttpsPortOffset;
    }

    public int getBindHttpsPort() {
        return this.bindHttpsPort;
    }

    public void setBindHttpsPort(int bindHttpsPort) {
        this.bindHttpsPort = bindHttpsPort;
    }

    public int getBindHttpPort() {
        return this.bindHttpPort;
    }

    public void setBindHttpPort(int bindHttpPort) {
        this.bindHttpPort = bindHttpPort;
    }

    public Path getProvidersPath() {
        return this.providersPath;
    }

    public void setProvidersPath(Path providersPath) {
        this.providersPath = providersPath;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getKeycloakConfigPropertyOverrides() {
        return this.keycloakConfigPropertyOverrides;
    }

    public void setKeycloakConfigPropertyOverrides(String keycloakConfigPropertyOverrides) {
        this.keycloakConfigPropertyOverrides = keycloakConfigPropertyOverrides;
    }

    public Map<String, Object> getKeycloakConfigPropertyOverridesMap() {
        return this.keycloakConfigPropertyOverridesMap;
    }

    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public boolean isReaugmentBeforeStart() {
        return this.reaugmentBeforeStart;
    }

    public void setReaugmentBeforeStart(boolean reaugmentBeforeStart) {
        this.reaugmentBeforeStart = reaugmentBeforeStart;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }
}

