/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.event.ContainerMultiControlEvent;
import org.jboss.arquillian.container.spi.event.StartClassContainers;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopClassContainers;
import org.jboss.arquillian.container.spi.event.StopManualContainers;
import org.jboss.arquillian.container.spi.event.StopSuiteContainers;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.test.impl.client.ContainerEventController;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.keycloak.helpers.DropAllServlet;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.annotation.RestartContainer;
import org.keycloak.testsuite.util.ContainerAssume;
import org.wildfly.extras.creaper.commands.deployments.Deploy;
import org.wildfly.extras.creaper.commands.deployments.Undeploy;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;

public class KeycloakContainerEventsController
extends ContainerEventController {
    protected static final Logger log = Logger.getLogger(KeycloakContainerEventsController.class);
    @Inject
    private Event<ContainerMultiControlEvent> container;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;

    public void execute(@Observes AfterSuite event) {
        this.container.fire((Object)new StopManualContainers());
        this.container.fire((Object)new StopSuiteContainers());
    }

    public void execute(@Observes(precedence=0) AfterClass event) {
        try {
            this.container.fire((Object)new UnDeployManagedDeployments());
        }
        finally {
            this.container.fire((Object)new StopClassContainers());
        }
        if (event.getTestClass().isAnnotationPresent(RestartContainer.class)) {
            this.afterOriginalContainerStop((RestartContainer)event.getTestClass().getAnnotation(RestartContainer.class));
        }
    }

    public void execute(BeforeClass event) {
        if (event.getTestClass().isAnnotationPresent(RestartContainer.class)) {
            ContainerAssume.assumeNotAuthServerRemote();
            RestartContainer restartContainer = (RestartContainer)event.getTestClass().getAnnotation(RestartContainer.class);
            this.beforeOriginalContainerStop(restartContainer);
            this.container.fire((Object)new StopManualContainers());
            this.container.fire((Object)new StopSuiteContainers());
            this.beforeNewContainerStart(restartContainer);
            this.container.fire((Object)new StartClassContainers());
            this.container.fire((Object)new StartSuiteContainers());
        }
        super.execute(event);
    }

    protected void beforeOriginalContainerStop(RestartContainer restartContainer) {
        if (restartContainer.initializeDatabase()) {
            this.deployAndDropAllTables(restartContainer);
        }
    }

    protected void afterOriginalContainerStop(RestartContainer restartContainer) {
        if (restartContainer.withoutKeycloakAddUserFile()) {
            this.copyKeycloakAddUserFile();
        }
    }

    protected void beforeNewContainerStart(RestartContainer restartContainer) {
        if (restartContainer.withoutKeycloakAddUserFile()) {
            this.removeKeycloakAddUserFile();
        }
        if (restartContainer.initializeDatabase()) {
            this.clearMapStorageFiles();
        }
    }

    private void deployAndDropAllTables(RestartContainer restartContainer) {
        for (Container c : ((ContainerRegistry)this.containerRegistry.get()).getContainers()) {
            String containerName = c.getName();
            log.infof("Deploy and dropAll at '%s'", (Object)containerName);
            if (containerName == null || !containerName.startsWith("auth-server")) {
                log.infof("Skipping deployAndDropAllTables for '%s'", (Object)containerName);
                continue;
            }
            ContainerDef conf = c.getContainerConfiguration();
            String mgmtPort = conf.getContainerProperty("managementPort");
            if (mgmtPort == null || mgmtPort.isEmpty()) {
                log.warnf("Skipping deployAndDropAllTables for '%s' due to not defined 'managementPort' property.", (Object)containerName);
                continue;
            }
            OnlineManagementClient client = null;
            try {
                client = ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort("localhost", Integer.valueOf(mgmtPort).intValue()).build());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"dropall.war")).addClass(DropAllServlet.class)).addAsWebInfResource((Asset)new StringAsset("<jboss-deployment-structure><deployment><dependencies><module name=\"org.liquibase\" /></dependencies></deployment></jboss-deployment-structure>"), "jboss-deployment-structure.xml");
                client.apply(new OnlineCommand[]{new Deploy.Builder(((ZipExporter)war.as(ZipExporter.class)).exportAsInputStream(), "dropall.war", true).build()});
                if (restartContainer.intializeDatabaseWait() > 0L) {
                    try {
                        Thread.sleep(restartContainer.intializeDatabaseWait());
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)e);
                    }
                }
                client.apply(new OnlineCommand[]{new Undeploy.Builder("dropall.war").build()});
            }
            catch (CommandFailedException e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void clearMapStorageFiles() {
        String filePath = System.getProperty("project.build.directory", "target/map");
        File f = new File(filePath);
        if (!f.exists()) {
            return;
        }
        Arrays.stream(f.listFiles()).filter(file -> file.getName().startsWith("map-") && file.getName().endsWith(".json")).forEach(File::delete);
    }

    private void copyKeycloakAddUserFile() {
        for (Container c : ((ContainerRegistry)this.containerRegistry.get()).getContainers()) {
            log.tracef("Copy keycloak-add-user.json for container [%s]", (Object)c.getName());
            ContainerDef conf = c.getContainerConfiguration();
            String jbossHome = conf.getContainerProperty("jbossHome");
            if (jbossHome == null || jbossHome.isEmpty()) continue;
            File originalUserAddJsonFile = new File("target/test-classes/keycloak-add-user.json");
            File userAddJsonFile = new File(conf.getContainerProperty("jbossHome") + "/standalone/configuration/keycloak-add-user.json");
            try {
                FileUtils.copyFile((File)originalUserAddJsonFile, (File)userAddJsonFile);
                log.infof("original user file (%s) has been copied to (%s)", (Object)originalUserAddJsonFile.getAbsolutePath(), (Object)userAddJsonFile.getAbsolutePath());
            }
            catch (IOException e) {
                log.warnf((Throwable)e, "Problem: keycloak-add-user.json file not copied to %s.", (Object)userAddJsonFile.getAbsolutePath());
            }
        }
    }

    private void removeKeycloakAddUserFile() {
        for (Container c : ((ContainerRegistry)this.containerRegistry.get()).getContainers()) {
            ContainerDef conf = c.getContainerConfiguration();
            String jbossHome = conf.getContainerProperty("jbossHome");
            if (jbossHome == null || jbossHome.isEmpty()) continue;
            File adminUserJsonFile = new File(jbossHome + "/standalone/configuration/keycloak-add-user.json");
            if (log.isTraceEnabled()) {
                log.tracef("File %s exists=%s", (Object)adminUserJsonFile.getAbsolutePath(), (Object)adminUserJsonFile.exists());
            }
            adminUserJsonFile.delete();
        }
    }

    public static void deploy(Archive archive, ContainerInfo containerInfo) throws CommandFailedException, IOException {
        ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort("localhost", containerInfo.getContextRoot().getPort() + 1547).build()).apply(new OnlineCommand[]{new Deploy.Builder(((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream(), archive.getName(), true).build()});
    }

    public static void undeploy(Archive archive, ContainerInfo containerInfo) throws CommandFailedException, IOException {
        ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort("localhost", containerInfo.getContextRoot().getPort() + 1547).build()).apply(new OnlineCommand[]{new Undeploy.Builder(archive.getName()).build()});
    }
}

