/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.util.List;
import org.jboss.arquillian.container.impl.client.container.ContainerDeployController;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.DeploymentEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;

public class KeycloakContainerDeployController
extends ContainerDeployController {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;
    @Inject
    private Instance<Injector> injector;

    public void deployManaged(DeployManagedDeployments event) throws Exception {
        this.forEachManagedDeployment(new ContainerDeployController.Operation<Container, Deployment>(){
            @Inject
            private Event<DeploymentEvent> event;

            public void perform(Container container, Deployment deployment) throws Exception {
                if (KeycloakContainerDeployController.this.runOnServerDeploymentOnRemote(deployment)) {
                    return;
                }
                if (container.getState().equals((Object)Container.State.STARTED)) {
                    this.event.fire((Object)new DeployDeployment(container, deployment));
                }
            }
        });
    }

    private void forEachManagedDeployment(ContainerDeployController.Operation<Container, Deployment> operation) throws Exception {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            return;
        }
        this.forEachDeployment(scenario.managedDeploymentsInDeployOrder(), operation);
    }

    private void forEachDeployment(List<Deployment> deployments, ContainerDeployController.Operation<Container, Deployment> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry containerRegistry = (ContainerRegistry)this.containerRegistry.get();
        if (containerRegistry == null) {
            return;
        }
        for (Deployment deployment : deployments) {
            Container container = containerRegistry.getContainer(deployment.getDescription().getTarget());
            operation.perform((Object)container, (Object)deployment);
        }
    }

    private boolean runOnServerDeploymentOnRemote(Deployment deployment) {
        return AuthServerTestEnricher.isAuthServerRemote() && deployment.getDescription().getArchive().getName().equals("run-on-server-classes.war");
    }
}

