/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.io.File;
import org.apache.commons.validator.routines.IntegerValidator;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class InfinispanServerConfiguration
implements ContainerConfiguration {
    private String infinispanHome;
    private String serverConfig;
    private Integer portOffset;
    private Integer managementPort;
    private String javaVmArguments;
    private String javaHome;

    public void validate() throws ConfigurationException {
        if (this.infinispanHome == null) {
            throw new ConfigurationException("`infinispanHome` cannot be null");
        }
        if (!new File(this.infinispanHome).isDirectory()) {
            throw new ConfigurationException(String.format("`infinispanHome` is not a valid directory: '%s'", this.infinispanHome));
        }
        if (this.portOffset == null) {
            this.portOffset = 0;
        }
        if (!IntegerValidator.getInstance().isInRange(this.portOffset, 1000, 64535)) {
            throw new ConfigurationException(String.format("Invalid portOffset: %s", this.portOffset));
        }
        if (this.managementPort == null) {
            this.managementPort = 9990 + this.portOffset;
        }
        if (!IntegerValidator.getInstance().isInRange(this.managementPort, 1000, 65535)) {
            throw new ConfigurationException(String.format("Invalid managementPort: %s", this.managementPort));
        }
    }

    public String getInfinispanHome() {
        return this.infinispanHome;
    }

    public void setInfinispanHome(String infinispanHome) {
        this.infinispanHome = infinispanHome;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public Integer getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(Integer portOffset) {
        this.portOffset = portOffset;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public Integer getManagementPort() {
        return this.managementPort;
    }

    public void setManagementPort(Integer managementPort) {
        this.managementPort = managementPort;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }
}

