/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.lang.reflect.Method;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;

public class VaultTestExecutionDecider
implements TestExecutionDecider {
    @Inject
    private Instance<TestContext> testContextInstance;

    public ExecutionDecision decide(Method method) {
        EnableVault.PROVIDER_ID providerId;
        TestContext testContext = (TestContext)this.testContextInstance.get();
        if (testContext.getTestClass().isAnnotationPresent(EnableVault.class) && (providerId = testContext.getTestClass().getAnnotation(EnableVault.class).providerId()) == EnableVault.PROVIDER_ID.ELYTRON_CS_KEYSTORE) {
            SuiteContext suiteContext = testContext.getSuiteContext();
            if (suiteContext != null && suiteContext.getAuthServerInfo() != null && suiteContext.getAuthServerInfo().isUndertow()) {
                return ExecutionDecision.dontExecute((String)"@EnableVault with Elytron credential store provider not supported on Undertow, skipping");
            }
            if (suiteContext != null && suiteContext.getAuthServerInfo() != null && suiteContext.getAuthServerInfo().isQuarkus()) {
                return ExecutionDecision.dontExecute((String)"@EnableVault with Elytron credential store provider not supported on Quarkus, skipping");
            }
        }
        return ExecutionDecision.execute();
    }

    public int precedence() {
        return 3;
    }
}

