/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.net.URL;
import org.jboss.logging.Logger;

public class TestClassProvider {
    private static final Logger LOGGER = Logger.getLogger(TestClassProvider.class);
    public static final String[] PERMITTED_PACKAGES = new String[]{"/org/keycloak/testsuite", "/org/junit", "/org/hamcrest", "/org/keycloak/admin/client", "/org/jboss/resteasy/client", "/org/jboss/arquillian", "/org/jboss/shrinkwrap", "/org/jboss/jandex", "/org/openqa/selenium", "/com/webauthn4j", "/com/fasterxml/jackson/dataformat/cbor"};
    private Undertow server;

    public void start() {
        this.server = Undertow.builder().addHttpListener(8500, "localhost").setHandler((HttpHandler)Handlers.resource((ResourceManager)new ClassPathResourceManager())).build();
        this.server.start();
        LOGGER.infov("Started test class provider on http://localhost:8500", new Object[0]);
    }

    public void stop() {
        this.server.stop();
    }

    public static class ClassPathResourceManager
    implements ResourceManager {
        public Resource getResource(String className) {
            LOGGER.infov("Request: {0}", (Object)className);
            URL resource = this.isPermittedPackage(className) ? TestClassProvider.class.getResource(className) : null;
            return resource != null ? new URLResource(resource, className) : null;
        }

        private boolean isPermittedPackage(String className) {
            for (String p : PERMITTED_PACKAGES) {
                if (!className.startsWith(p)) continue;
                return true;
            }
            return false;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void close() {
        }
    }
}

