/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.wildfly.extras.creaper.commands.undertow.AddUndertowListener;
import org.wildfly.extras.creaper.commands.undertow.RemoveUndertowListener;
import org.wildfly.extras.creaper.commands.undertow.SslVerifyClient;
import org.wildfly.extras.creaper.commands.undertow.UndertowListenerType;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class ServerTestEnricherUtil {
    private static final Logger LOG = Logger.getLogger(ServerTestEnricherUtil.class);

    public static boolean removeHttpsListener(OnlineManagementClient client, Administration administration) throws InterruptedException, TimeoutException, IOException {
        try {
            LOG.debug((Object)"Remove Undertow HTTPS listener 'https' for default server and reload/restart server");
            client.apply(new OnlineCommand[]{new RemoveUndertowListener.Builder(UndertowListenerType.HTTPS_LISTENER, "https").forDefaultServer()});
            ServerTestEnricherUtil.reloadOrRestartTimeoutClient(administration);
            return true;
        }
        catch (CommandFailedException e) {
            LOG.warn((Object)"Undertow HTTPS listener doesn't already exist");
            return false;
        }
    }

    public static boolean addHttpsListener(OnlineManagementClient client) {
        try {
            LOG.debug((Object)"Add Undertow HTTPS listener 'https'");
            client.execute("/subsystem=undertow/server=default-server/https-listener=https:add(ssl-context=httpsSSC, socket-binding=https)");
            return true;
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot add HTTPS listener 'https'");
            return false;
        }
    }

    public static boolean addHttpsListenerAppServer(OnlineManagementClient client) {
        try {
            LOG.debug((Object)"Add Undertow HTTPS listener 'https'");
            client.apply(new OnlineCommand[]{new AddUndertowListener.HttpsBuilder("https", "default-server", "https").securityRealm("UndertowRealm").verifyClient(SslVerifyClient.REQUESTED).build()});
            return true;
        }
        catch (CommandFailedException e) {
            LOG.warn((Object)"Cannot add HTTPS listener 'https'");
            return false;
        }
    }

    public static void reloadOrRestartTimeoutClient(Administration administration) throws IOException, InterruptedException, TimeoutException {
        try {
            if (administration == null) {
                return;
            }
            administration.reloadIfRequired();
        }
        catch (TimeoutException e) {
            LOG.warn((Object)"Cannot reload server; trying to restart it");
            administration.restart();
        }
    }
}

