/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.arquillian.container.test.impl.execution.LocalTestExecuter;
import org.jboss.arquillian.container.test.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestResult;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.client.KeycloakTestingClient;

public class ModelTestExecutor
extends LocalTestExecuter {
    @Inject
    private Instance<TestContext> testContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalExecutionEvent event) throws Exception {
        Method testMethod = event.getExecutor().getMethod();
        ModelTest annotation = testMethod.getAnnotation(ModelTest.class);
        if (annotation == null) {
            super.execute(event);
        } else {
            TestResult result = new TestResult();
            try {
                TestContext ctx = (TestContext)this.testContext.get();
                KeycloakTestingClient testingClient = ctx.getTestingClient();
                testingClient.server().runModelTest(testMethod.getDeclaringClass().getName(), testMethod.getName());
                result.setStatus(TestResult.Status.PASSED);
            }
            catch (Throwable e) {
                result.setStatus(TestResult.Status.FAILED);
                result.setThrowable(e);
            }
            finally {
                result.setEnd(System.currentTimeMillis());
            }
            Field testResultField = Reflections.findDeclaredField(LocalTestExecuter.class, (String)"testResult");
            testResultField.setAccessible(true);
            InstanceProducer thisTestResult = (InstanceProducer)testResultField.get((Object)this);
            thisTestResult.set((Object)result);
        }
    }
}

