/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;

public class HotRodStoreTestEnricher {
    private static SuiteContext suiteContext;
    private static final Logger log;
    @Inject
    private Event<StartContainer> startContainerEvent;
    @Inject
    private Event<StopContainer> stopContainerEvent;

    static void initializeSuiteContext(SuiteContext suiteContext) {
        Validate.notNull((Object)suiteContext, (String)"Suite context cannot be null.");
        HotRodStoreTestEnricher.suiteContext = suiteContext;
    }

    public void beforeContainerStarted(@Observes(precedence=1) StartSuiteContainers event) {
        if (!AuthServerTestEnricher.HOT_ROD_STORE_ENABLED) {
            return;
        }
        ContainerInfo hotRodContainer = suiteContext.getHotRodStoreInfo();
        if (hotRodContainer != null && !hotRodContainer.isStarted()) {
            log.infof("HotRod store starting: %s", (Object)hotRodContainer.getQualifier());
            this.startContainerEvent.fire((Object)new StartContainer(hotRodContainer.getArquillianContainer()));
        }
    }

    public void afterSuite(@Observes(precedence=4) AfterSuite event) {
        if (!AuthServerTestEnricher.HOT_ROD_STORE_ENABLED) {
            return;
        }
        ContainerInfo hotRodContainer = suiteContext.getHotRodStoreInfo();
        if (hotRodContainer != null && hotRodContainer.isStarted()) {
            log.infof("HotRod store stopping: %s", (Object)hotRodContainer.getQualifier());
            this.stopContainerEvent.fire((Object)new StopContainer(hotRodContainer.getArquillianContainer()));
        }
    }

    static {
        log = Logger.getLogger(HotRodStoreTestEnricher.class);
    }
}

