/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.jboss.arquillian.container.spi.Container;
import org.keycloak.common.util.KeycloakUriBuilder;

public class ContainerInfo
implements Comparable<ContainerInfo> {
    private URL contextRoot;
    private URL browserContextRoot;
    private Container arquillianContainer;

    public ContainerInfo(Container arquillianContainer) {
        if (arquillianContainer == null) {
            throw new IllegalArgumentException();
        }
        this.arquillianContainer = arquillianContainer;
    }

    public Container getArquillianContainer() {
        return this.arquillianContainer;
    }

    public Map<String, String> getProperties() {
        return this.getArquillianContainer().getContainerConfiguration().getContainerProperties();
    }

    public String getQualifier() {
        return this.getArquillianContainer().getName();
    }

    public URL getContextRoot() {
        return this.contextRoot;
    }

    public KeycloakUriBuilder getUriBuilder() {
        try {
            return KeycloakUriBuilder.fromUri((URI)this.getContextRoot().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContextRoot(URL contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void setBrowserContextRoot(URL browserContextRoot) {
        this.browserContextRoot = browserContextRoot;
    }

    public URL getBrowserContextRoot() {
        return this.browserContextRoot;
    }

    public boolean isUndertow() {
        return this.getQualifier().toLowerCase().contains("undertow");
    }

    public boolean isQuarkus() {
        return this.getQualifier().toLowerCase().contains("quarkus");
    }

    public boolean isAS7() {
        return this.getQualifier().toLowerCase().contains("as7");
    }

    public boolean isWildfly() {
        return this.getQualifier().toLowerCase().contains("wildfly");
    }

    public boolean isEAP() {
        return this.getQualifier().toLowerCase().contains("eap");
    }

    public boolean isJBossBased() {
        return this.isAS7() || this.isWildfly() || this.isEAP() || this.getQualifier().toLowerCase().contains("jboss");
    }

    public String toString() {
        return this.getQualifier();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.arquillianContainer);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerInfo other = (ContainerInfo)obj;
        return Objects.equals(this.arquillianContainer.getContainerConfiguration().getContainerName(), other.arquillianContainer.getContainerConfiguration().getContainerName());
    }

    public boolean isStarted() {
        return this.arquillianContainer.getState() == Container.State.STARTED;
    }

    public boolean isManual() {
        return Objects.equals(this.arquillianContainer.getContainerConfiguration().getMode(), "manual");
    }

    @Override
    public int compareTo(ContainerInfo o) {
        return this.getQualifier().compareTo(o.getQualifier());
    }
}

