/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.NotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.error.KeycloakErrorHandler;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.CrossDCTestEnricher;
import org.keycloak.testsuite.arquillian.HotRodStoreTestEnricher;
import org.keycloak.testsuite.arquillian.ServerTestEnricherUtil;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestClassProvider;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;
import org.keycloak.testsuite.arquillian.annotation.SetDefaultProvider;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.util.LogChecker;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.SpiProvidersSwitchingUtils;
import org.keycloak.testsuite.util.SqlUtils;
import org.keycloak.testsuite.util.SystemInfoHelper;
import org.keycloak.testsuite.util.TextFileChecker;
import org.keycloak.testsuite.util.VaultUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;
import org.xml.sax.SAXException;

public class AuthServerTestEnricher {
    protected static final Logger log = Logger.getLogger(AuthServerTestEnricher.class);
    @Inject
    private Instance<ContainerController> containerConroller;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Event<StartContainer> startContainerEvent;
    @Inject
    private Event<StopContainer> stopContainerEvent;
    private JavaArchive testsuiteProvidersArchive;
    private String currentContainerName;
    public static final String AUTH_SERVER_CONTAINER_DEFAULT = "auth-server-undertow";
    public static final String AUTH_SERVER_CONTAINER_PROPERTY = "auth.server.container";
    public static final String AUTH_SERVER_CONTAINER = System.getProperty("auth.server.container", "auth-server-undertow");
    public static final String AUTH_SERVER_BACKEND_DEFAULT = AUTH_SERVER_CONTAINER + "-backend";
    public static final String AUTH_SERVER_BACKEND_PROPERTY = "auth.server.backend";
    public static final String AUTH_SERVER_BACKEND = System.getProperty("auth.server.backend", AUTH_SERVER_BACKEND_DEFAULT);
    public static final String AUTH_SERVER_LEGACY = "auth-server-legacy";
    public static final String AUTH_SERVER_BALANCER_DEFAULT = "auth-server-balancer";
    public static final String AUTH_SERVER_BALANCER_PROPERTY = "auth.server.balancer";
    public static final String AUTH_SERVER_BALANCER = System.getProperty("auth.server.balancer", "auth-server-balancer");
    public static final String AUTH_SERVER_CLUSTER_PROPERTY = "auth.server.cluster";
    public static final boolean AUTH_SERVER_CLUSTER = Boolean.parseBoolean(System.getProperty("auth.server.cluster", "false"));
    public static final String AUTH_SERVER_CROSS_DC_PROPERTY = "auth.server.crossdc";
    public static final boolean AUTH_SERVER_CROSS_DC = Boolean.parseBoolean(System.getProperty("auth.server.crossdc", "false"));
    public static final String HOT_ROD_STORE_ENABLED_PROPERTY = "hotrod.store.enabled";
    public static final boolean HOT_ROD_STORE_ENABLED = Boolean.parseBoolean(System.getProperty("hotrod.store.enabled", "false"));
    public static final String AUTH_SERVER_HOME_PROPERTY = "auth.server.home";
    public static final String CACHE_SERVER_LIFECYCLE_SKIP_PROPERTY = "cache.server.lifecycle.skip";
    public static final boolean CACHE_SERVER_LIFECYCLE_SKIP = Boolean.parseBoolean(System.getProperty("cache.server.lifecycle.skip", "false"));
    private static final String MIGRATION_MODE_PROPERTY = "migration.mode";
    private static final String MIGRATION_MODE_AUTO = "auto";
    private static final String MIGRATION_MODE_MANUAL = "manual";
    public static final Boolean START_MIGRATION_CONTAINER = "auto".equals(System.getProperty("migration.mode")) || "manual".equals(System.getProperty("migration.mode"));
    @Inject
    @SuiteScoped
    private InstanceProducer<SuiteContext> suiteContextProducer;
    private SuiteContext suiteContext;
    @Inject
    @ApplicationScoped
    private InstanceProducer<TestContext> testContextProducer;
    @Inject
    @ClassScoped
    private InstanceProducer<OAuthClient> oAuthClientProducer;
    private static final Pattern RECOGNIZED_ERRORS = Pattern.compile("ERROR \\[|SEVERE \\[|Exception ");
    private static final Pattern IGNORED = Pattern.compile("Jetty ALPN support not found|org.keycloak.events");
    private static final Pattern UNEXPECTED_UNCAUGHT_ERROR = Pattern.compile(KeycloakErrorHandler.class.getSimpleName() + ".*" + Pattern.quote("Uncaught server error") + "[\\s:]*(.*)$");

    public static boolean isAuthServerRemote() {
        return AUTH_SERVER_CONTAINER.equals("auth-server-remote");
    }

    public static boolean isAuthServerQuarkus() {
        return AUTH_SERVER_CONTAINER.equals("auth-server-quarkus");
    }

    public static String getHttpAuthServerContextRoot() {
        String host = System.getProperty("auth.server.host", "localhost");
        int httpPort = Integer.parseInt(System.getProperty("auth.server.http.port"));
        return ServerURLs.removeDefaultPorts((String)String.format("%s://%s:%s", "http", host, httpPort));
    }

    public static String getHttpsAuthServerContextRoot() {
        String host = System.getProperty("auth.server.host", "localhost");
        int httpPort = Integer.parseInt(System.getProperty("auth.server.https.port"));
        return ServerURLs.removeDefaultPorts((String)String.format("%s://%s:%s", "https", host, httpPort));
    }

    public static String getAuthServerBrowserContextRoot() throws MalformedURLException {
        return AuthServerTestEnricher.getAuthServerBrowserContextRoot(new URL(ServerURLs.getAuthServerContextRoot()));
    }

    public static String getAuthServerBrowserContextRoot(URL contextRoot) {
        String browserHost = System.getProperty("auth.server.browserHost");
        if (StringUtils.isEmpty((String)browserHost)) {
            browserHost = contextRoot.getHost();
        }
        return String.format("%s://%s%s", contextRoot.getProtocol(), browserHost, contextRoot.getPort() == -1 || contextRoot.getPort() == contextRoot.getDefaultPort() ? "" : ":" + contextRoot.getPort());
    }

    public static OnlineManagementClient getManagementClient() {
        try {
            return ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort(System.getProperty("auth.server.management.host", "localhost"), Integer.parseInt(System.getProperty("auth.server.management.port", "10090"))).auth("admin", "admin").build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void distinguishContainersInConsoleOutput(@Observes(precedence=5) StartContainer event) {
        log.info((Object)("************************" + event.getContainer().getName() + "*****************************************************************************"));
        this.currentContainerName = event.getContainer().getName();
    }

    public void initializeSuiteContext(@Observes(precedence=2) BeforeSuite event) {
        Iterator<ContainerInfo> container;
        Set<ContainerInfo> containers = ((ContainerRegistry)this.containerRegistry.get()).getContainers().stream().map(ContainerInfo::new).collect(Collectors.toSet());
        this.suiteContext = new SuiteContext(containers);
        if (AUTH_SERVER_CROSS_DC) {
            containers.stream().filter(c -> c.getQualifier().startsWith(AUTH_SERVER_BALANCER + "-cross-dc")).forEach(c -> {
                String portOffsetString = c.getArquillianContainer().getContainerConfiguration().getContainerProperties().getOrDefault("bindHttpPortOffset", "0");
                String dcString = c.getArquillianContainer().getContainerConfiguration().getContainerProperties().getOrDefault("dataCenter", "0");
                this.updateWithAuthServerInfo((ContainerInfo)c, Integer.valueOf(portOffsetString));
                this.suiteContext.addAuthServerInfo(Integer.valueOf(dcString), (ContainerInfo)c);
            });
            if (this.suiteContext.getDcAuthServerInfo().isEmpty()) {
                throw new IllegalStateException("Not found frontend container (load balancer): " + AUTH_SERVER_BALANCER);
            }
            if (this.suiteContext.getDcAuthServerInfo().stream().anyMatch(Objects::isNull)) {
                throw new IllegalStateException("Frontend container (load balancer) misconfiguration");
            }
            containers.stream().filter(c -> c.getQualifier().startsWith("auth-server-" + System.getProperty("node.name") + "-")).sorted((a, b) -> a.getQualifier().compareTo(b.getQualifier())).forEach(c -> {
                String portOffsetString = c.getArquillianContainer().getContainerConfiguration().getContainerProperties().getOrDefault("bindHttpPortOffset", "0");
                this.updateWithAuthServerInfo((ContainerInfo)c, Integer.valueOf(portOffsetString));
                String dcString = c.getArquillianContainer().getContainerConfiguration().getContainerProperties().getOrDefault("dataCenter", "0");
                this.suiteContext.addAuthServerBackendsInfo(Integer.valueOf(dcString), (ContainerInfo)c);
            });
            containers.stream().filter(c -> c.getQualifier().startsWith("cache-server-")).sorted((a, b) -> a.getQualifier().compareTo(b.getQualifier())).forEach(containerInfo -> {
                log.info((Object)String.format("cache container: %s", containerInfo.getQualifier()));
                int prefixSize = containerInfo.getQualifier().lastIndexOf("-") + 1;
                int dcIndex = Integer.parseInt(containerInfo.getQualifier().substring(prefixSize)) - 1;
                this.suiteContext.addCacheServerInfo(dcIndex, (ContainerInfo)containerInfo);
            });
            if (this.suiteContext.getDcAuthServerInfo().isEmpty()) {
                throw new RuntimeException(String.format("No auth server container matching '%s' found in arquillian.xml.", AUTH_SERVER_BACKEND));
            }
            if (this.suiteContext.getDcAuthServerBackendsInfo().stream().anyMatch(Objects::isNull)) {
                throw new IllegalStateException("Frontend container (load balancer) misconfiguration");
            }
            if (this.suiteContext.getDcAuthServerBackendsInfo().stream().anyMatch(List::isEmpty)) {
                throw new RuntimeException(String.format("Some data center has no auth server container matching '%s' defined in arquillian.xml.", AUTH_SERVER_BACKEND));
            }
            if (this.suiteContext.getCacheServersInfo().isEmpty() && !CACHE_SERVER_LIFECYCLE_SKIP) {
                throw new IllegalStateException("Cache containers misconfiguration");
            }
            log.info((Object)("Using frontend containers: " + this.suiteContext.getDcAuthServerInfo().stream().map(ContainerInfo::getQualifier).collect(Collectors.joining(", "))));
        } else if (AUTH_SERVER_CLUSTER) {
            container = containers.stream().filter(c -> c.getQualifier().startsWith(AUTH_SERVER_BALANCER)).findAny().orElseThrow(() -> new IllegalStateException("Not found frontend container: " + AUTH_SERVER_BALANCER));
            this.updateWithAuthServerInfo((ContainerInfo)((Object)container));
            this.suiteContext.setAuthServerInfo((ContainerInfo)((Object)container));
            containers.stream().filter(c -> c.getQualifier().startsWith(AUTH_SERVER_BACKEND)).sorted((a, b) -> a.getQualifier().compareTo(b.getQualifier())).forEach(c -> {
                int portOffset = Integer.parseInt(c.getQualifier().substring(AUTH_SERVER_BACKEND.length()));
                this.updateWithAuthServerInfo((ContainerInfo)c, portOffset);
                this.suiteContext.addAuthServerBackendsInfo(0, (ContainerInfo)c);
            });
            if (Boolean.parseBoolean(System.getProperty("auth.server.jboss.legacy"))) {
                ContainerInfo legacy = containers.stream().filter(c -> c.getQualifier().startsWith(AUTH_SERVER_LEGACY)).findAny().orElseThrow(() -> new IllegalStateException("Not found legacy container: auth-server-legacy"));
                this.updateWithAuthServerInfo(legacy, 500);
                this.suiteContext.setLegacyAuthServerInfo(legacy);
            }
            if (this.suiteContext.getAuthServerBackendsInfo().isEmpty()) {
                throw new RuntimeException(String.format("No auth server container matching '%s' found in arquillian.xml.", AUTH_SERVER_BACKEND));
            }
            log.info((Object)("Using frontend container: " + ((ContainerInfo)((Object)container)).getQualifier()));
        } else {
            container = containers.stream().filter(c -> c.getQualifier().startsWith(AUTH_SERVER_CONTAINER)).findAny().orElseThrow(() -> new IllegalStateException("Not found frontend container: " + AUTH_SERVER_CONTAINER));
            this.updateWithAuthServerInfo((ContainerInfo)((Object)container));
            this.suiteContext.setAuthServerInfo((ContainerInfo)((Object)container));
        }
        if (START_MIGRATION_CONTAINER.booleanValue()) {
            for (ContainerInfo container2 : this.suiteContext.getContainers()) {
                if (!container2.getQualifier().equals("auth-server-jboss-migration")) continue;
                this.updateWithAuthServerInfo(container2);
                this.suiteContext.setMigratedAuthServerInfo(container2);
            }
            if (this.suiteContext.getMigratedAuthServerInfo() == null) {
                throw new RuntimeException(String.format("Migration test was enabled but no auth server from which to migrate was activated. A container matching auth-server-jboss-migration needs to be enabled in arquillian.xml.", new Object[0]));
            }
        }
        if (HOT_ROD_STORE_ENABLED) {
            HotRodStoreTestEnricher.initializeSuiteContext(this.suiteContext);
            for (ContainerInfo container2 : this.suiteContext.getContainers()) {
                if (!container2.getQualifier().equals("hot-rod-store")) continue;
                this.suiteContext.setHotRodStoreInfo(container2);
            }
        }
        this.suiteContextProducer.set((Object)this.suiteContext);
        CrossDCTestEnricher.initializeSuiteContext(this.suiteContext);
        log.info((Object)("\n\n" + this.suiteContext));
        log.info((Object)("\n\n" + SystemInfoHelper.getSystemInfo()));
        File dir = new File(System.getProperty("project.build.directory", "target"));
        WildcardFileFilter fileFilter = new WildcardFileFilter("map-*.json");
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
    }

    public static void executeCli(String ... commands) throws Exception {
        OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();
        Administration administration = new Administration(client);
        for (String c : commands) {
            client.execute(c).assertSuccess();
        }
        administration.reload();
        client.close();
    }

    private ContainerInfo updateWithAuthServerInfo(ContainerInfo authServerInfo) {
        return this.updateWithAuthServerInfo(authServerInfo, 0);
    }

    private ContainerInfo updateWithAuthServerInfo(ContainerInfo authServerInfo, int clusterPortOffset) {
        try {
            URL contextRoot = new URL(ServerURLs.getAuthServerContextRoot((int)clusterPortOffset));
            authServerInfo.setContextRoot(contextRoot);
            authServerInfo.setBrowserContextRoot(new URL(AuthServerTestEnricher.getAuthServerBrowserContextRoot(contextRoot)));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        return authServerInfo;
    }

    public void startMigratedContainer(@Observes(precedence=3) StartSuiteContainers event) {
        if (this.suiteContext.isAuthServerMigrationEnabled()) {
            log.info((Object)("\n\n### Starting keycloak " + System.getProperty("migrated.auth.server.version", "- previous") + " ###\n\n"));
            this.startContainerEvent.fire((Object)new StartContainer(this.suiteContext.getMigratedAuthServerInfo().getArquillianContainer()));
            AuthServerTestEnricher.initializeTLS(this.suiteContext.getMigratedAuthServerInfo());
        }
    }

    public void deployProviders(@Observes(precedence=-1) AfterStart event) throws DeploymentException {
        if (AuthServerTestEnricher.isAuthServerRemote() && this.currentContainerName.contains("auth-server")) {
            this.testsuiteProvidersArchive = (JavaArchive)((JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)"testsuiteProviders.jar")).importFrom(((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("org.keycloak.testsuite:integration-arquillian-testsuite-providers")).withoutTransitivity()).asSingleFile())).as(JavaArchive.class)).addAsManifestResource("jboss-deployment-structure.xml");
            event.getDeployableContainer().deploy((Archive)this.testsuiteProvidersArchive);
        }
    }

    public void unDeployProviders(@Observes(precedence=20) BeforeStop event) throws DeploymentException {
        if (this.testsuiteProvidersArchive != null) {
            event.getDeployableContainer().undeploy((Archive)this.testsuiteProvidersArchive);
        }
    }

    public void runPreMigrationTask(@Observes(precedence=2) StartSuiteContainers event) throws Exception {
        if (this.suiteContext.isAuthServerMigrationEnabled()) {
            log.info((Object)("\n\n### Run preMigration task on keycloak " + System.getProperty("migrated.auth.server.version", "- previous") + " ###\n\n"));
            this.suiteContext.getMigrationContext().runPreMigrationTask();
        }
    }

    public void stopMigratedContainer(@Observes(precedence=1) StartSuiteContainers event) {
        if (this.suiteContext.isAuthServerMigrationEnabled()) {
            log.info((Object)("## STOP old container: " + this.suiteContext.getMigratedAuthServerInfo().getQualifier()));
            this.stopContainerEvent.fire((Object)new StopContainer(this.suiteContext.getMigratedAuthServerInfo().getArquillianContainer()));
        }
    }

    public void startAuthContainer(@Observes(precedence=0) StartSuiteContainers event) {
        log.debug((Object)"Starting auth server before suite");
        try {
            this.startContainerEvent.fire((Object)new StartContainer(this.suiteContext.getAuthServerInfo().getArquillianContainer()));
        }
        catch (Exception e) {
            if (e instanceof LifecycleException && this.handleManualMigration()) {
                log.info((Object)"Set log file checker to end of file.");
                try {
                    if (this.suiteContext.getServerLogChecker() == null) {
                        this.setServerLogChecker();
                    }
                    this.suiteContext.getServerLogChecker().updateLastCheckedPositionsOfAllFilesToEndOfFile();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Server log checker failed to update position:", (Throwable)ioe);
                }
                log.info((Object)"Starting server again after manual DB migration was finished");
                this.startContainerEvent.fire((Object)new StartContainer(this.suiteContext.getAuthServerInfo().getArquillianContainer()));
                return;
            }
            throw e;
        }
    }

    private boolean handleManualMigration() {
        if (!MIGRATION_MODE_MANUAL.equals(System.getProperty(MIGRATION_MODE_PROPERTY))) {
            return false;
        }
        String authServerHome = System.getProperty(AUTH_SERVER_HOME_PROPERTY);
        if (authServerHome == null) {
            log.warnf("Property '%s' was missing during manual mode migration test", (Object)AUTH_SERVER_HOME_PROPERTY);
            return false;
        }
        String sqlScriptPath = authServerHome + File.separator + "keycloak-database-update.sql";
        if (!new File(sqlScriptPath).exists()) {
            log.warnf("File '%s' didn't exists during manual mode migration test", (Object)sqlScriptPath);
            return false;
        }
        log.infof("Running SQL script created by liquibase during manual migration flow", (Object)sqlScriptPath);
        String prefix = "keycloak.connectionsJpa.";
        String jdbcDriver = System.getProperty(prefix + "driver");
        String dbUrl = StringPropertyReplacer.replaceProperties((String)System.getProperty(prefix + "url"));
        String dbUser = System.getProperty(prefix + "user");
        String dbPassword = System.getProperty(prefix + "password");
        SqlUtils.runSqlScript(sqlScriptPath, jdbcDriver, dbUrl, dbUser, dbPassword);
        return true;
    }

    private static final boolean isRecognizedErrorLog(String logText) {
        return RECOGNIZED_ERRORS.matcher(logText).find() && !IGNORED.matcher(logText).find();
    }

    private static final void failOnRecognizedErrorInLog(Stream<String> logStream) {
        Optional<String> anyRecognizedError = logStream.filter(AuthServerTestEnricher::isRecognizedErrorLog).findAny();
        if (anyRecognizedError.isPresent()) {
            throw new RuntimeException(String.format("Server log file contains ERROR: '%s'", anyRecognizedError.get()));
        }
    }

    private void setServerLogChecker() throws IOException {
        String jbossHomePath = this.suiteContext.getAuthServerInfo().getProperties().get("jbossHome");
        this.suiteContext.setServerLogChecker(LogChecker.getJBossServerLogsChecker(jbossHomePath));
    }

    public void checkServerLogs(@Observes(precedence=-1) BeforeSuite event) throws IOException, InterruptedException {
        boolean checkLog;
        if (!this.suiteContext.getAuthServerInfo().isJBossBased()) {
            this.suiteContext.setServerLogChecker(new TextFileChecker(new Path[0]));
            return;
        }
        if (this.suiteContext.getServerLogChecker() == null) {
            this.setServerLogChecker();
        }
        if (checkLog = Boolean.parseBoolean(System.getProperty("auth.server.log.check", "true"))) {
            this.suiteContext.getServerLogChecker().checkFiles(true, AuthServerTestEnricher::failOnRecognizedErrorInLog);
        }
    }

    public void restartAuthServer() throws Exception {
        if (AuthServerTestEnricher.isAuthServerRemote()) {
            try (OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();){
                int timeoutInSec = Integer.getInteger(System.getProperty("auth.server.jboss.startup.timeout"), 300);
                Administration administration = new Administration(client, timeoutInSec);
                administration.reload();
            }
        } else {
            this.stopContainerEvent.fire((Object)new StopContainer(this.suiteContext.getAuthServerInfo().getArquillianContainer()));
            this.startContainerEvent.fire((Object)new StartContainer(this.suiteContext.getAuthServerInfo().getArquillianContainer()));
        }
    }

    public void initializeTestContext(@Observes(precedence=2) BeforeClass event) throws Exception {
        TestContext testContext = new TestContext(this.suiteContext, event.getTestClass().getJavaClass());
        this.testContextProducer.set((Object)testContext);
        if (!AuthServerTestEnricher.isAuthServerRemote()) {
            SetDefaultProvider defaultProvider;
            boolean wasUpdated = false;
            if (event.getTestClass().isAnnotationPresent(SetDefaultProvider.class) && (defaultProvider = (SetDefaultProvider)event.getTestClass().getAnnotation(SetDefaultProvider.class)).beforeEnableFeature()) {
                SpiProvidersSwitchingUtils.addProviderDefaultValue(this.suiteContext, defaultProvider);
                wasUpdated = true;
            }
            if (event.getTestClass().isAnnotationPresent(EnableVault.class)) {
                VaultUtils.enableVault(this.suiteContext, ((EnableVault)event.getTestClass().getAnnotation(EnableVault.class)).providerId());
                wasUpdated = true;
            }
            if (wasUpdated) {
                this.restartAuthServer();
                testContext.reconnectAdminClient();
            }
        }
    }

    public void initializeTLS(@Observes(precedence=3) BeforeClass event) throws Exception {
        if (!this.suiteContext.isAuthServerCrossDc() && !this.suiteContext.isAuthServerCluster()) {
            AuthServerTestEnricher.initializeTLS(this.suiteContext.getAuthServerInfo());
        }
    }

    public static void initializeTLS(ContainerInfo containerInfo) {
        if (ServerURLs.AUTH_SERVER_SSL_REQUIRED && containerInfo.isJBossBased()) {
            log.infof("\n\n### Setting up TLS for %s ##\n\n", (Object)containerInfo);
            try (OnlineManagementClient client = AuthServerTestEnricher.getManagementClient(containerInfo);){
                AuthServerTestEnricher.enableTLS(client);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to set up TLS for container '" + containerInfo.getQualifier() + "'. This may lead to unexpected behavior unless the test sets it up manually"), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setJsseSecurityProviderForOutboundSslConnectionsOfElytronClient(@Observes(precedence=100) StartSuiteContainers event) {
        File wildflyConfigXml;
        log.info((Object)"Determining the JSSE security provider to use for outbound SSL/TLS connections of the Elytron client");
        String wildflyConfigXmlPath = System.getProperty("wildfly-client.config.path");
        if (wildflyConfigXmlPath == null) {
            log.debug((Object)"Scanning classpath to locate wildfly-config.xml");
            String javaClassPath = System.getProperty("java.class.path");
            for (String dir : javaClassPath.split(File.pathSeparator)) {
                String candidatePath;
                if (dir.isEmpty() || !new File(candidatePath = dir + File.separator + "wildfly-config.xml").exists()) continue;
                wildflyConfigXmlPath = candidatePath;
                log.debugf("Found wildfly-config.xml at '%s' location", (Object)wildflyConfigXmlPath);
                break;
            }
        }
        File file = wildflyConfigXml = wildflyConfigXmlPath != null ? new File(wildflyConfigXmlPath) : null;
        if (wildflyConfigXml == null || !wildflyConfigXml.exists()) {
            throw new RuntimeException("Failed to locate the wildfly-config.xml to use for the configuration of Elytron client");
        }
        log.debugf("Using wildfly-config.xml from '%s' location", (Object)wildflyConfigXmlPath);
        String jsseSecurityProviderSystemProperty = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDoc = documentBuilder.parse(wildflyConfigXml);
            NodeList nodeList = xmlDoc.getElementsByTagName("provider-name");
            if (nodeList.getLength() != 1) {
                throw new RuntimeException("Failed to locate the 'provider-name' element in wildfly-config.xml XML file");
            }
            String providerNameElement = nodeList.item(0).getAttributes().getNamedItem("name").getNodeValue();
            jsseSecurityProviderSystemProperty = providerNameElement.replaceAll("(\\$|\\{|\\}|(:.*$))", new String());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error reading the '%s' file. Please make sure the provided path is correct and retry", wildflyConfigXml.getAbsolutePath()));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(String.format("Failed to parse the '%s' XML file", wildflyConfigXml.getAbsolutePath()));
        }
        boolean determineJsseSecurityProviderName = false;
        if (jsseSecurityProviderSystemProperty == null) throw new RuntimeException("Failed to determine the name of system property holding JSSE security provider's name for Elytron client");
        if (System.getProperty(jsseSecurityProviderSystemProperty) == null) {
            determineJsseSecurityProviderName = true;
        }
        if (!determineJsseSecurityProviderName) return;
        String jreExtensionsDir = System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext" + File.separator + "openjsse.jar";
        boolean openJsseExtensionPresent = new File(jreExtensionsDir).exists();
        Provider platformJsseProvider = Security.getProviders("SSLContext.TLSv1.2")[0];
        if (platformJsseProvider == null) throw new RuntimeException("Cannot identify a security provider for Elytron client offering the TLSv1.2 capability");
        if (openJsseExtensionPresent) {
            Provider sunJsseProvider = (Provider)Stream.of(Security.getProviders()).filter(p -> p.getName().equals("SunJSSE")).collect(Collectors.toList()).get(0);
            if (sunJsseProvider == null) throw new RuntimeException("The SunJSSE provider is not present on the platform");
            platformJsseProvider = sunJsseProvider;
        }
        System.setProperty(jsseSecurityProviderSystemProperty, platformJsseProvider.getName());
        log.infof("Using the '%s' JSSE provider", (Object)platformJsseProvider.getName());
    }

    private static OnlineManagementClient getManagementClient(ContainerInfo containerInfo) {
        try {
            return ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort("localhost", Integer.parseInt(containerInfo.getProperties().get("managementPort"))).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void enableTLS(OnlineManagementClient client) throws Exception {
        Administration administration = new Administration(client);
        Operations operations = new Operations(client);
        if (!operations.exists(Address.subsystem((String)"elytron").and("server-ssl-context", "httpsSSC"))) {
            client.execute("/subsystem=elytron/key-store=httpsKS:add(relative-to=jboss.server.config.dir,path=keycloak.jks,credential-reference={clear-text=secret},type=JKS)");
            client.execute("/subsystem=elytron/key-manager=httpsKM:add(key-store=httpsKS,credential-reference={clear-text=secret})");
            client.execute("/subsystem=elytron/key-store=twoWayTS:add(relative-to=jboss.server.config.dir,path=keycloak.truststore,credential-reference={clear-text=secret},type=JKS)");
            client.execute("/subsystem=elytron/trust-manager=twoWayTM:add(key-store=twoWayTS)");
            client.execute("/subsystem=elytron/server-ssl-context=httpsSSC:add(key-manager=httpsKM,protocols=[\"TLSv1.2\"],trust-manager=twoWayTM,want-client-auth=true)");
            ServerTestEnricherUtil.removeHttpsListener(client, administration);
            ServerTestEnricherUtil.addHttpsListener(client);
            ServerTestEnricherUtil.reloadOrRestartTimeoutClient(administration);
        } else {
            log.info((Object)"## The Auth Server has already configured TLS. Skipping ##");
        }
    }

    protected boolean isAuthServerJBossBased() {
        return ((ContainerRegistry)this.containerRegistry.get()).getContainers().stream().map(ContainerInfo::new).anyMatch(ContainerInfo::isJBossBased);
    }

    public void initializeOAuthClient(@Observes(precedence=4) BeforeClass event) {
        OAuthClient.updateURLs(this.suiteContext.getAuthServerInfo().getContextRoot().toString());
        OAuthClient oAuthClient = new OAuthClient();
        this.oAuthClientProducer.set((Object)oAuthClient);
    }

    public void beforeTest(@Observes(precedence=100) Before event) throws IOException {
        this.suiteContext.getServerLogChecker().updateLastCheckedPositionsOfAllFilesToEndOfFile();
    }

    public void startTestClassProvider(@Observes(precedence=1) BeforeSuite beforeSuite) {
        TestClassProvider testClassProvider = new TestClassProvider();
        testClassProvider.start();
        this.suiteContext.setTestClassProvider(testClassProvider);
    }

    public void stopTestClassProvider(@Observes(precedence=-1) AfterSuite afterSuite) {
        this.suiteContext.getTestClassProvider().stop();
    }

    private void checkForNoUnexpectedUncaughtError(Stream<String> logStream) {
        Optional<Matcher> anyUncaughtError = logStream.map(UNEXPECTED_UNCAUGHT_ERROR::matcher).filter(Matcher::find).findAny();
        if (anyUncaughtError.isPresent()) {
            Matcher m = anyUncaughtError.get();
            Assert.fail((String)("Uncaught server error detected: " + m.group(1)));
        }
    }

    public void afterTest(@Observes(precedence=-1) After event) throws IOException {
        if (event.getTestMethod().getAnnotation(UncaughtServerErrorExpected.class) == null) {
            this.suiteContext.getServerLogChecker().checkFiles(false, this::checkForNoUnexpectedUncaughtError);
        }
    }

    public void afterClass(@Observes(precedence=1) AfterClass event) throws Exception {
        ContainerController controller = (ContainerController)this.containerConroller.get();
        if (!controller.isStarted(this.suiteContext.getAuthServerInfo().getQualifier())) {
            log.warn((Object)("Auth server wasn't running. Starting " + this.suiteContext.getAuthServerInfo().getQualifier()));
            controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        }
        TestContext testContext = (TestContext)this.testContextProducer.get();
        Keycloak adminClient = testContext.getAdminClient();
        KeycloakTestingClient testingClient = testContext.getTestingClient();
        AuthServerTestEnricher.removeTestRealms(testContext, adminClient);
        if (!AuthServerTestEnricher.isAuthServerRemote()) {
            boolean wasUpdated = false;
            if (event.getTestClass().isAnnotationPresent(SetDefaultProvider.class)) {
                SpiProvidersSwitchingUtils.resetProvider(this.suiteContext, (SetDefaultProvider)event.getTestClass().getAnnotation(SetDefaultProvider.class));
                wasUpdated = true;
            }
            if (event.getTestClass().isAnnotationPresent(EnableVault.class) && !AuthServerTestEnricher.isAuthServerQuarkus()) {
                VaultUtils.disableVault(this.suiteContext, ((EnableVault)event.getTestClass().getAnnotation(EnableVault.class)).providerId());
                wasUpdated = true;
            }
            if (wasUpdated) {
                this.restartAuthServer();
                testContext.reconnectAdminClient();
            }
        }
        if (adminClient != null) {
            adminClient.close();
        }
        if (testingClient != null) {
            testingClient.close();
        }
    }

    public static void removeTestRealms(TestContext testContext, Keycloak adminClient) {
        List<RealmRepresentation> testRealmReps = testContext.getTestRealmReps();
        if (testRealmReps != null && !testRealmReps.isEmpty()) {
            log.info((Object)"removing test realms after test class");
            StringBuilder realms = new StringBuilder();
            for (RealmRepresentation testRealm : testRealmReps) {
                try {
                    adminClient.realms().realm(testRealm.getRealm()).remove();
                    realms.append(testRealm.getRealm()).append(", ");
                }
                catch (NotFoundException notFoundException) {}
            }
            log.info((Object)("removed realms: " + realms));
        }
    }
}

