/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.ServerTestEnricherUtil;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.containers.SelfManagedAppContainerLifecycle;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.fuse.FuseUtils;
import org.wildfly.extras.creaper.commands.web.AddConnector;
import org.wildfly.extras.creaper.commands.web.AddConnectorSslConfig;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.ManagementProtocol;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AppServerTestEnricher {
    private static final Logger log = Logger.getLogger(AppServerTestEnricher.class);
    public static final String CURRENT_APP_SERVER = System.getProperty("app.server", "undertow");
    public static final boolean APP_SERVER_SSL_REQUIRED = Boolean.parseBoolean(System.getProperty("app.server.ssl.required", "false"));
    @Inject
    private Instance<ContainerController> containerConrollerInstance;
    @Inject
    private Instance<TestContext> testContextInstance;
    private TestContext testContext;

    public static Set<String> getAppServerQualifiers(Class testClass) {
        HashSet<String> appServerQualifiers = new HashSet<String>();
        Class annotatedClass = AppServerTestEnricher.getNearestSuperclassWithAppServerAnnotation(testClass);
        if (annotatedClass != null) {
            AppServerContainer[] appServerContainers;
            AppServerContainer[] appServerContainerArray = appServerContainers = (AppServerContainer[])annotatedClass.getAnnotationsByType(AppServerContainer.class);
            int n = appServerContainerArray.length;
            for (int i = 0; i < n; ++i) {
                AppServerContainer appServerContainer = appServerContainerArray[i];
                appServerQualifiers.add(appServerContainer.value());
            }
        }
        for (Method method : testClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(AppServerContainers.class)) {
                for (AppServerContainer appServerContainer : method.getAnnotation(AppServerContainers.class).value()) {
                    appServerQualifiers.add(appServerContainer.value());
                }
            }
            if (!method.isAnnotationPresent(AppServerContainer.class)) continue;
            appServerQualifiers.add(method.getAnnotation(AppServerContainer.class).value());
        }
        return appServerQualifiers;
    }

    public static String getAppServerBrowserContextRoot() throws MalformedURLException {
        return AppServerTestEnricher.getAppServerBrowserContextRoot(new URL(ServerURLs.getAuthServerContextRoot()));
    }

    public static String getAppServerBrowserContextRoot(URL contextRoot) {
        String browserHost = System.getProperty("app.server.browserHost");
        if (StringUtils.isEmpty((String)browserHost)) {
            browserHost = contextRoot.getHost();
        }
        return String.format("%s://%s:%s", contextRoot.getProtocol(), browserHost, contextRoot.getPort());
    }

    public void updateTestContextWithAppServerInfo(@Observes(precedence=1) BeforeClass event) {
        this.testContext = (TestContext)this.testContextInstance.get();
        Set<String> appServerQualifiers = AppServerTestEnricher.getAppServerQualifiers(this.testContext.getTestClass());
        if (appServerQualifiers.isEmpty()) {
            log.info((Object)("\n\n" + this.testContext));
            return;
        }
        String appServerQualifier = null;
        block0: for (String qualifier : appServerQualifiers) {
            if (qualifier.contains(";")) {
                List<String> appServers = Arrays.asList(qualifier.split("\\s*;\\s*"));
                List<ContainerInfo> appServerBackendsInfo = this.testContext.getSuiteContext().getContainers().stream().filter(ci -> appServers.contains(ci.getQualifier())).map(this::updateWithAppServerInfo).collect(Collectors.toList());
                this.testContext.setAppServerBackendsInfo(appServerBackendsInfo);
                continue;
            }
            for (ContainerInfo container : this.testContext.getSuiteContext().getContainers()) {
                if (!container.getQualifier().equals(qualifier)) continue;
                this.testContext.setAppServerInfo(this.updateWithAppServerInfo(container));
                appServerQualifier = qualifier;
                continue block0;
            }
        }
        if (appServerQualifier != null && this.testContext.getAppServerInfo() == null) {
            throw new RuntimeException(String.format("No app server container matching '%s' was activated. Check if defined and enabled in arquillian.xml.", appServerQualifier));
        }
        log.info((Object)("\n\n" + this.testContext));
    }

    private ContainerInfo updateWithAppServerInfo(ContainerInfo appServerInfo) {
        return this.updateWithAppServerInfo(appServerInfo, 0);
    }

    private ContainerInfo updateWithAppServerInfo(ContainerInfo appServerInfo, int clusterPortOffset) {
        try {
            URL appServerContextRoot = new URL(AppServerTestEnricher.isRelative() ? ServerURLs.getAuthServerContextRoot((int)clusterPortOffset) : ServerURLs.getAppServerContextRoot((int)clusterPortOffset));
            appServerInfo.setContextRoot(appServerContextRoot);
            appServerInfo.setBrowserContextRoot(new URL(AppServerTestEnricher.getAppServerBrowserContextRoot(appServerContextRoot)));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        return appServerInfo;
    }

    public static OnlineManagementClient getManagementClient() {
        return AppServerTestEnricher.getManagementClient(200);
    }

    public static OnlineManagementClient getManagementClient(int portOffset) {
        try {
            return ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort(System.getProperty("app.server.host", "localhost"), System.getProperty("app.server", "").startsWith("eap6") ? 9999 + portOffset : 9990 + portOffset).protocol(System.getProperty("app.server", "").startsWith("eap6") ? ManagementProtocol.REMOTE : ManagementProtocol.HTTP_REMOTING).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void startAppServer(@Observes(precedence=-1) BeforeClass event) throws MalformedURLException, InterruptedException, IOException {
        if (SelfManagedAppContainerLifecycle.class.isAssignableFrom(event.getTestClass().getJavaClass())) {
            log.debug((Object)"Skipping starting App server. Server should be started by testClass.");
            return;
        }
        if (this.testContext.isAdapterContainerEnabled() && !this.testContext.isRelativeAdapterTest()) {
            ContainerController controller;
            if (this.isJBossBased()) {
                AppServerTestEnricher.prepareServerDir("standalone");
            }
            if (!(controller = (ContainerController)this.containerConrollerInstance.get()).isStarted(this.testContext.getAppServerInfo().getQualifier())) {
                log.info((Object)("Starting app server: " + this.testContext.getAppServerInfo().getQualifier()));
                controller.start(this.testContext.getAppServerInfo().getQualifier());
            }
            if (AppServerTestEnricher.isFuseAppServer()) {
                FuseUtils.setUpFuse((String)("app-server-" + CURRENT_APP_SERVER));
            }
        }
    }

    public static void enableHTTPSForManagementClient(OnlineManagementClient client) throws CommandFailedException, InterruptedException, TimeoutException, IOException, CliException, OperationException {
        Administration administration = new Administration(client);
        Operations operations = new Operations(client);
        if (!operations.exists(Address.coreService((String)"management").and("security-realm", "UndertowRealm"))) {
            client.execute("/core-service=management/security-realm=UndertowRealm:add()");
            client.execute("/core-service=management/security-realm=UndertowRealm/server-identity=ssl:add(keystore-relative-to=jboss.server.config.dir,keystore-password=secret,keystore-path=adapter.jks");
        }
        client.execute("/system-property=javax.net.ssl.trustStore:add(value=${jboss.server.config.dir}/keycloak.truststore)");
        client.execute("/system-property=javax.net.ssl.trustStorePassword:add(value=secret)");
        if (AppServerTestEnricher.isEAP6AppServer()) {
            if (!operations.exists(Address.subsystem((String)"web").and("connector", "https"))) {
                client.apply(new OnlineCommand[]{new AddConnector.Builder("https").protocol("HTTP/1.1").scheme("https").socketBinding("https").secure(Boolean.valueOf(true)).build()});
                client.apply(new OnlineCommand[]{new AddConnectorSslConfig.Builder("https").password("secret").certificateKeyFile("${jboss.server.config.dir}/adapter.jks").build()});
                String appServerJavaHome = System.getProperty("app.server.java.home", "");
                if (appServerJavaHome.contains("ibm")) {
                    client.execute("/subsystem=web/connector=https/configuration=ssl:write-attribute(name=cipher-suite, value=\"SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256,SSL_RSA_WITH_AES_128_CBC_SHA256,SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA256,SSL_ECDH_RSA_WITH_AES_128_CBC_SHA256,SSL_DHE_RSA_WITH_AES_128_CBC_SHA256,SSL_DHE_DSS_WITH_AES_128_CBC_SHA256,SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA,SSL_RSA_WITH_AES_128_CBC_SHA,SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA,SSL_ECDH_RSA_WITH_AES_128_CBC_SHA,SSL_DHE_RSA_WITH_AES_128_CBC_SHA,SSL_DHE_DSS_WITH_AES_128_CBC_SHA\")");
                }
            }
        } else {
            ServerTestEnricherUtil.removeHttpsListener(client, administration);
            ServerTestEnricherUtil.addHttpsListenerAppServer(client);
        }
        ServerTestEnricherUtil.reloadOrRestartTimeoutClient(administration);
    }

    public static void enableHTTPSForAppServer() throws CommandFailedException, InterruptedException, TimeoutException, IOException, CliException, OperationException {
        try (OnlineManagementClient client = AppServerTestEnricher.getManagementClient();){
            AppServerTestEnricher.enableHTTPSForManagementClient(client);
        }
    }

    public static void enableHTTPSForAppServer(int portOffset) throws CommandFailedException, InterruptedException, TimeoutException, IOException, CliException, OperationException {
        try (OnlineManagementClient client = AppServerTestEnricher.getManagementClient(portOffset);){
            AppServerTestEnricher.enableHTTPSForManagementClient(client);
        }
    }

    public void stopAppServer(@Observes(precedence=2) AfterClass event) {
        if (this.testContext.getAppServerInfo() == null) {
            return;
        }
        ContainerController controller = (ContainerController)this.containerConrollerInstance.get();
        if (controller.isStarted(this.testContext.getAppServerInfo().getQualifier())) {
            log.info((Object)("Stopping app server: " + this.testContext.getAppServerInfo().getQualifier()));
            controller.stop(this.testContext.getAppServerInfo().getQualifier());
        }
    }

    public static void prepareServerDir(String baseDir) throws IOException {
        log.debug((Object)("Creating cleanServerBaseDir from: " + baseDir));
        Path path = Paths.get(System.getProperty("app.server.home"), "standalone-test");
        File targetSubdirFile = path.toFile();
        FileUtils.deleteDirectory((File)targetSubdirFile);
        FileUtils.forceMkdir((File)targetSubdirFile);
        FileUtils.copyDirectory((File)Paths.get(System.getProperty("app.server.home"), baseDir, "deployments").toFile(), (File)new File(targetSubdirFile, "deployments"));
        FileUtils.copyDirectory((File)Paths.get(System.getProperty("app.server.home"), baseDir, "configuration").toFile(), (File)new File(targetSubdirFile, "configuration"));
    }

    public static Class getNearestSuperclassWithAppServerAnnotation(Class<?> testClass) {
        return testClass.isAnnotationPresent(AppServerContainer.class) || testClass.isAnnotationPresent(AppServerContainers.class) ? testClass : (testClass.getSuperclass().equals(Object.class) ? null : AppServerTestEnricher.getNearestSuperclassWithAppServerAnnotation(testClass.getSuperclass()));
    }

    public static boolean hasAppServerContainerAnnotation(Class testClass) {
        return AppServerTestEnricher.getNearestSuperclassWithAppServerAnnotation(testClass) != null;
    }

    public static boolean isUndertowAppServer() {
        return CURRENT_APP_SERVER.equals("undertow");
    }

    public static boolean isRelative() {
        return CURRENT_APP_SERVER.equals("relative");
    }

    public static boolean isWildflyAppServer() {
        return CURRENT_APP_SERVER.equals("wildfly");
    }

    public static boolean isWildfly10AppServer() {
        return CURRENT_APP_SERVER.equals("wildfly10");
    }

    public static boolean isWildfly9AppServer() {
        return CURRENT_APP_SERVER.equals("wildfly9");
    }

    public static boolean isTomcatAppServer() {
        return CURRENT_APP_SERVER.startsWith("tomcat");
    }

    public static boolean isEAP6AppServer() {
        return CURRENT_APP_SERVER.equals("eap6");
    }

    public static boolean isEAPAppServer() {
        return CURRENT_APP_SERVER.equals("eap");
    }

    public static boolean isWASAppServer() {
        return CURRENT_APP_SERVER.equals("was");
    }

    public static boolean isWLSAppServer() {
        return CURRENT_APP_SERVER.equals("wls");
    }

    public static boolean isFuseAppServer() {
        return CURRENT_APP_SERVER.contains("fuse");
    }

    public static boolean isRemoteAppServer() {
        return CURRENT_APP_SERVER.contains("remote");
    }

    private boolean isJBossBased() {
        return this.testContext.getAppServerInfo().isJBossBased();
    }
}

