/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.javascript.JavascriptStateValidator;
import org.keycloak.testsuite.util.javascript.JavascriptTestExecutorWithAuthorization;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.keycloak.testsuite.util.javascript.XMLHttpRequest;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PhotozClientAuthzTestApp
extends AbstractPageWithInjectedUrl {
    public static final String DEPLOYMENT_NAME = "photoz-html5-client";
    public static final int WAIT_AFTER_OPERATION = 1000;
    @ArquillianResource
    @OperateOnDeployment(value="photoz-html5-client")
    private URL url;
    @Drone
    @JavascriptBrowser
    protected WebDriver driver;
    @Page
    @JavascriptBrowser
    protected OIDCLogin loginPage;
    @FindBy(xpath="//a[@ng-click = 'Identity.logout()']")
    @JavascriptBrowser
    private WebElement signOutButton;
    @FindBy(id="entitlement")
    @JavascriptBrowser
    private WebElement entitlement;
    @FindBy(id="entitlements")
    @JavascriptBrowser
    private WebElement entitlements;
    @FindBy(id="get-all-resources")
    @JavascriptBrowser
    private WebElement viewAllAlbums;
    @FindBy(id="output")
    @JavascriptBrowser
    private WebElement output;
    private JavascriptTestExecutorWithAuthorization testExecutor;
    private String apiUrl;

    public void setTestExecutorPlayground(JavascriptTestExecutorWithAuthorization executor, String apiUrl) {
        this.testExecutor = executor;
        this.apiUrl = apiUrl;
    }

    public void createAlbum(String name) {
        this.createAlbum(name, false);
    }

    public void createAlbum(String name, boolean managed) {
        this.createAlbum(name, managed, false, null);
    }

    public void createAlbum(String name, boolean managed, boolean invalidUser, ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("POST").url(this.apiUrl + "/album" + (invalidUser ? "?user=invalidUser" : "")).content("JSON.stringify(JSON.parse('{\"name\" : \"" + name + "\", \"userManaged\": " + Boolean.toString(managed) + " }'))").addHeader("Content-Type", "application/json; charset=UTF-8"), validator);
    }

    public void createAlbumWithInvalidUser(String name, ResponseValidator validator) {
        this.createAlbum(name, false, true, validator);
    }

    @Override
    public URL getInjectedUrl() {
        return this.url;
    }

    public void deleteAlbum(String name, ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("DELETE").url(this.apiUrl + "/album/" + name + "/"), validator);
    }

    public void navigateToAdminAlbum(ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("GET").addHeader("Accept", "application/json").url(this.apiUrl + "/admin/album"), validator);
    }

    public void logOut() {
        this.navigateTo();
        WaitUtils.waitUntilElement(this.signOutButton).is().clickable();
        UIUtils.clickLink(this.signOutButton);
    }

    public void requestEntitlement(JavascriptStateValidator validator) {
        this.testExecutor.executeAsyncScript("var callback = arguments[arguments.length - 1];window.authorization.entitlement('photoz-restful-api', {    \"permissions\": [        {            \"id\" : \"Album Resource\"        }    ]}).then(function (rpt) {    callback(JSON.stringify(jwt_decode(rpt), null, '  '));});", validator);
    }

    public void requestEntitlements(JavascriptStateValidator validator) {
        this.testExecutor.executeAsyncScript("var callback = arguments[arguments.length - 1];window.authorization.entitlement('photoz-restful-api', {}).then(function (rpt) {     callback(JSON.stringify(jwt_decode(rpt), null, '  '));});", validator);
    }

    private void waitForDenial() {
        WaitUtils.waitUntilElement(this.output).text().contains("You can not access");
    }

    private void waitForNotDenial() {
        ((StringMatcher)WaitUtils.waitUntilElement(this.output).text().not()).contains("You can not access");
    }

    public void viewAllAlbums() {
        this.viewAllAlbums.click();
        WaitUtils.pause(1000L);
    }

    public void viewProfile(ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("GET").addHeader("Accept", "application/json").url(this.apiUrl + "/profile"), validator);
    }

    public void viewAlbum(String name, ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("GET").addHeader("Accept", "application/json").url(this.apiUrl + "/album/" + name + "/"), validator);
    }

    public void accountPage() {
        this.testExecutor.openAccountPage(null);
    }

    public void accountMyResources() {
        this.accountPage();
        WebElement myResources = this.driver.findElement(By.xpath((String)"//a[text() = 'My Resources']"));
        WaitUtils.waitUntilElement(myResources).is().clickable();
        myResources.click();
    }

    public void accountMyResource(String name) {
        this.accountMyResources();
        WebElement myResource = this.driver.findElement(By.id((String)("detail-" + name)));
        WaitUtils.waitUntilElement(myResource).is().clickable();
        myResource.click();
    }

    public void accountGrantResource(String name, String requester) {
        this.accountMyResources();
        this.grantResource(name, requester);
    }

    public void grantResource(String name, String requester) {
        WebElement grantResource = this.driver.findElement(By.id((String)("grant-" + name + "-" + requester)));
        WaitUtils.waitUntilElement(grantResource).is().clickable();
        grantResource.click();
    }

    public void accountGrantRemoveScope(String name, String requester, String scope) {
        this.accountMyResources();
        WebElement grantRemoveScope = this.driver.findElement(By.id((String)("grant-remove-scope-" + name + "-" + requester + "-" + scope)));
        WaitUtils.waitUntilElement(grantRemoveScope).is().clickable();
        grantRemoveScope.click();
    }

    public void accountRevokeResource(String name, String requester) {
        this.accountMyResource(name);
        this.revokeResource(name, requester);
    }

    public void revokeResource(String name, String requester) {
        WebElement revokeResource = this.driver.findElement(By.id((String)("revoke-" + name + "-" + requester)));
        WaitUtils.waitUntilElement(revokeResource).is().clickable();
        revokeResource.click();
    }

    public void accountShareResource(String name, String user) {
        this.accountMyResource(name);
        this.shareResource(user);
    }

    public void accountShareRemoveScope(String name, String user, String scope) {
        this.accountMyResource(name);
        WebElement shareRemoveScope = this.driver.findElement(By.id((String)("share-remove-scope-" + name + "-" + scope)));
        WaitUtils.waitUntilElement(shareRemoveScope).is().clickable();
        shareRemoveScope.click();
        this.shareResource(user);
    }

    public void shareResource(String user) {
        WebElement userIdInput = this.driver.findElement(By.id((String)"user_id"));
        UIUtils.setTextInputValue(userIdInput, user);
        WaitUtils.pause(200L);
        WaitUtils.waitUntilElement(userIdInput).attribute("value").contains(user);
        WebElement shareButton = this.driver.findElement(By.id((String)"share-button"));
        WaitUtils.waitUntilElement(shareButton).is().clickable();
        shareButton.click();
    }

    public void assertError() {
        Assert.assertEquals((Object)"We are sorry...", (Object)this.driver.findElement(By.id((String)"kc-page-title")).getText());
    }

    public void accountDenyResource(String name) {
        this.accountMyResource(name);
        WebElement denyLink = this.driver.findElement(By.linkText((String)"Deny"));
        WaitUtils.waitUntilElement(denyLink).is().clickable();
        denyLink.click();
        WaitUtils.waitForPageToLoad();
    }

    public void requestResourceProtectedAnyScope(ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("GET").url(this.apiUrl + "/scope-any"), validator);
    }

    public void requestResourceProtectedAllScope(ResponseValidator validator) {
        this.testExecutor.sendXMLHttpRequest(XMLHttpRequest.create().method("GET").url(this.apiUrl + "/scope-all"), validator);
    }

    public WebElement getOutput() {
        return this.output;
    }

    @Override
    public void navigateTo() {
        this.driver.navigate().to(this.toString());
        WaitUtils.waitForPageToLoad();
    }

    @Override
    public boolean isCurrent() {
        return URLUtils.currentUrlStartsWith(this.toString());
    }

    public void executeScript(String script) {
        this.testExecutor.executeScript(script);
    }
}

