/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.adapter.page.SAMLServlet;
import org.keycloak.testsuite.auth.page.login.SAMLPostLogin;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public class EmployeeRoleMappingServlet
extends SAMLServlet {
    public static final String DEPLOYMENT_NAME = "employee-role-mapping";
    @ArquillianResource
    @OperateOnDeployment(value="employee-role-mapping")
    private URL url;
    private SAMLPostLogin loginPage;
    private UserRepresentation user;

    @Override
    public URL getInjectedUrl() {
        return this.url;
    }

    public void setupLoginInfo(SAMLPostLogin page, UserRepresentation user) {
        this.loginPage = page;
        this.user = user;
    }

    public void clearLoginInfo() {
        this.loginPage = null;
        this.user = null;
    }

    @Override
    public void setRolesToCheck(String roles) {
        if (this.loginPage != null) {
            this.driver.navigate().to(this.getUriBuilder().clone().path("setCheckRoles").queryParam("roles", new Object[]{roles}).build(new Object[0]).toASCIIString());
            this.loginPage.form().login(this.user);
            WaitUtils.waitUntilElement(By.tagName((String)"body")).text().contains("These roles will be checked:");
            this.logout();
        } else {
            super.setRolesToCheck(roles);
        }
    }

    @Override
    public void checkRolesEndPoint(boolean value) {
        if (this.loginPage != null) {
            this.driver.navigate().to(this.getUriBuilder().clone().path((value ? "" : "un") + "checkRoles").build(new Object[0]).toASCIIString());
            this.loginPage.form().login(this.user);
            WaitUtils.waitUntilElement(By.tagName((String)"body")).text().contains("Roles will " + (value ? "" : "not ") + "be checked");
            this.logout();
        } else {
            super.checkRolesEndPoint(value);
        }
    }
}

