/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import com.google.common.base.Charsets;
import io.undertow.Undertow;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.openqa.selenium.WebDriver;

public class X509OCSPResponderFailOpenTest
extends AbstractX509AuthenticationTest {
    private static final String OCSP_RESPONDER_HOST = "localhost";
    private static final int OCSP_RESPONDER_PORT = 8888;
    private Undertow ocspResponder;
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @Test
    public void ocspFailCloseLoginFailed() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setOCSPEnabled(true).setOCSPResponder("http://localhost.invalid.host:8888/oscp").setOCSPFailOpen(false).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509OCSPResponderFailOpenTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertThat((Object)response.getErrorDescription(), (Matcher)Matchers.containsString((String)"OCSP check failed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ocspFailOpenLoginSuccess() throws Exception {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setOCSPEnabled(true).setOCSPFailOpen(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setOCSPResponder("http://localhost.invalid.host:8888/oscp").setOCSPResponderCertificate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/client-auth-test/intermediate-ca.crt"), (Charset)Charsets.UTF_8).replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "")).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509OCSPResponderFailOpenTest.newConfig("x509-directgrant-config", config.getConfig());
        String cfgId = this.createConfig(this.directGrantExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        String keyStorePath = Paths.get(System.getProperty("client.certificate.keystore"), new String[0]).getParent().resolve("client-ca.jks").toString();
        String keyStorePassword = System.getProperty("client.certificate.keystore.passphrase");
        String trustStorePath = System.getProperty("client.truststore");
        String trustStorePassword = System.getProperty("client.truststore.passphrase");
        Supplier previous = this.oauth.getHttpClient();
        try {
            this.oauth.clientId("resource-owner");
            this.oauth.httpClient(() -> OAuthClient.newCloseableHttpClientSSL((String)keyStorePath, (String)keyStorePassword, (String)trustStorePath, (String)trustStorePassword));
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "", "", null);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        }
        finally {
            this.oauth.httpClient(previous);
        }
    }
}

