/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.openqa.selenium.WebDriver;

public class X509BrowserLoginIssuerDnTest
extends AbstractX509AuthenticationTest {
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @BeforeClass
    public static void checkAssumption() {
        try {
            CertificateFactory.getInstance("X.509", "SUN");
        }
        catch (NoSuchProviderException | CertificateException e) {
            Assume.assumeNoException((String)"Test assumes the SUN security provider", (Throwable)e);
        }
    }

    @BeforeClass
    public static void onBeforeTestClass() {
        X509BrowserLoginIssuerDnTest.configurePhantomJS("/ca.crt", "/certs/clients/test-user-san@localhost.cert.pem", "/certs/clients/test-user@localhost.key.pem", "password");
    }

    private String setup(boolean canonicalDnEnabled) throws Exception {
        String issuerDn = canonicalDnEnabled ? "1.2.840.113549.1.9.1=#1614636f6e74616374406b6579636c6f616b2e6f7267,cn=keycloak intermediate ca,ou=keycloak,o=red hat,st=ma,c=us" : "EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US";
        UserRepresentation user = this.findUser("test-user@localhost");
        user.singleAttribute("x509_certificate_identity", issuerDn);
        this.updateUser(user);
        return issuerDn;
    }

    @Test
    public void loginAsUserFromCertIssuerDnCanonical() throws Exception {
        String issuerDn = this.setup(true);
        this.x509BrowserLogin(X509BrowserLoginIssuerDnTest.createLoginIssuerDNToCustomAttributeConfig(true), this.userId, "test-user@localhost", issuerDn);
    }

    @Test
    public void loginAsUserFromCertIssuerDnNonCanonical() throws Exception {
        String issuerDn = this.setup(false);
        this.x509BrowserLogin(X509BrowserLoginIssuerDnTest.createLoginIssuerDNToCustomAttributeConfig(false), this.userId, "test-user@localhost", issuerDn);
    }
}

