/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;
import org.keycloak.testsuite.x509.CRLRule;
import org.openqa.selenium.WebDriver;

public class X509BrowserCRLTest
extends AbstractX509AuthenticationTest {
    @ClassRule
    public static CRLRule crlRule = new CRLRule();
    @Drone
    @PhantomJSBrowser
    private WebDriver phantomJS;

    @Before
    public void replaceTheDefaultDriver() {
        this.replaceDefaultWebDriver(this.phantomJS);
    }

    @Test
    public void loginSuccessWithEmptyRevocationListFromFile() {
        ContainerAssume.assumeNotAuthServerUndertow();
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("empty.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        this.x509BrowserLogin(config, this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginFailedWithIntermediateRevocationListFromFile() {
        ContainerAssume.assumeNotAuthServerUndertow();
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("intermediate-ca.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserCRLTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.assertLoginFailedDueRevokedCertificate();
    }

    @Test
    public void loginSuccessWithEmptyRevocationListFromHttp() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("http://localhost:8889/empty.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        this.x509BrowserLogin(config, this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginFailedWithIntermediateRevocationListFromHttp() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("http://localhost:8889/intermediate-ca.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserCRLTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.assertLoginFailedDueRevokedCertificate();
    }

    @Test
    public void loginFailedWithInvalidSignatureCRL() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("http://localhost:8889/intermediate-ca-invalid-signature.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserCRLTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.assertLoginFailedWithExpectedX509Error("Certificate validation's failed.\nSignature length not correct");
    }

    @Test
    public void loginSuccessWithCRLSignedWithIntermediateCA3FromTruststore() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("http://localhost:8889/intermediate-ca-3.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserCRLTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.x509BrowserLogin(config, this.userId, "test-user@localhost", "test-user@localhost");
    }

    @Test
    public void loginWithMultipleRevocationLists() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLRelativePath("http://localhost:8889/empty.crl##http://localhost:8889/intermediate-ca.crl").setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserCRLTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.assertLoginFailedDueRevokedCertificate();
    }

    @Test
    public void loginFailedWithRevocationListFromDistributionPoints() {
        X509AuthenticatorConfigModel config = new X509AuthenticatorConfigModel().setCRLEnabled(true).setCRLDistributionPointEnabled(true).setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
        AuthenticatorConfigRepresentation cfg = X509BrowserCRLTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        Assert.assertNotNull((Object)cfgId);
        this.assertLoginFailedDueRevokedCertificate();
    }

    private void assertLoginFailedDueRevokedCertificate() {
        this.assertLoginFailedWithExpectedX509Error("Certificate validation's failed.\nCertificate has been revoked, certificate's subject:");
    }

    private void assertLoginFailedWithExpectedX509Error(String expectedError) {
        this.loginConfirmationPage.open();
        this.loginPage.assertCurrent();
        Assert.assertNotNull((Object)this.loginPage.getError());
        Assert.assertThat((Object)this.loginPage.getError(), (Matcher)Matchers.containsString((String)expectedError));
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(this.userId).detail("username", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
    }
}

