/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import com.google.common.collect.ImmutableMap;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.Req;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.keycloak.testsuite.x509.X509OCSPResponderTest;

final class OcspHandler
implements HttpHandler {
    public static final String OCSP_RESPONDER_CERT_PATH = "/client-auth-test/intermediate-ca.crt";
    public static final String OCSP_RESPONDER_KEYPAIR_PATH = "/client-auth-test/intermediate-ca.key";
    public static final String OCSP_RESPONDER_CERT_PATH_SPECIFIC = "/client-auth-test/intermediate-ca-2.crt";
    public static final String OCSP_RESPONDER_KEYPAIR_PATH_SPECIFIC = "/client-auth-test/intermediate-ca-2.key";
    private static final Map<BigInteger, CertificateStatus> REVOKED_CERTIFICATES_STATUS = ImmutableMap.of((Object)BigInteger.valueOf(4105L), (Object)new RevokedStatus(new Date(1472169600000L), 0));
    private final SubjectPublicKeyInfo subjectPublicKeyInfo;
    private final X509CertificateHolder[] chain;
    private final AsymmetricKeyParameter privateKey;

    public OcspHandler(String responderCertPath, String responderKeyPath) throws OperatorCreationException, GeneralSecurityException, IOException {
        Certificate certificate = CertificateFactory.getInstance("X509").generateCertificate(X509OCSPResponderTest.class.getResourceAsStream(responderCertPath));
        this.chain = new X509CertificateHolder[]{new X509CertificateHolder(certificate.getEncoded())};
        AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey((byte[])certificate.getPublicKey().getEncoded());
        this.subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)publicKey);
        InputStream keyPairStream = X509OCSPResponderTest.class.getResourceAsStream(responderKeyPath);
        try (PEMParser keyPairReader = new PEMParser((Reader)new InputStreamReader(keyPairStream));){
            PEMKeyPair keyPairPem = (PEMKeyPair)keyPairReader.readObject();
            this.privateKey = PrivateKeyFactory.createKey((PrivateKeyInfo)keyPairPem.getPrivateKeyInfo());
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        byte[] buffy = new byte[16384];
        try (InputStream requestStream = exchange.getInputStream();){
            requestStream.read(buffy);
        }
        OCSPReq request = new OCSPReq(buffy);
        Req[] requested = request.getRequestList();
        Extension nonce = request.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        DigestCalculator sha1Calculator = new JcaDigestCalculatorProviderBuilder().build().get(AlgorithmIdentifier.getInstance((Object)RespID.HASH_SHA1));
        BasicOCSPRespBuilder responseBuilder = new BasicOCSPRespBuilder(this.subjectPublicKeyInfo, sha1Calculator);
        if (nonce != null) {
            responseBuilder.setResponseExtensions(new Extensions(nonce));
        }
        for (Req req : requested) {
            CertificateID certId = req.getCertID();
            BigInteger certificateSerialNumber = certId.getSerialNumber();
            responseBuilder.addResponse(certId, REVOKED_CERTIFICATES_STATUS.get(certificateSerialNumber));
        }
        ContentSigner contentSigner = new BcRSAContentSignerBuilder(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption), new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)).build(this.privateKey);
        OCSPResp response = new OCSPRespBuilder().build(0, (Object)responseBuilder.build(contentSigner, this.chain, new Date()));
        byte[] responseBytes = response.getEncoded();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        responseHeaders.put(Headers.CONTENT_TYPE, "application/ocsp-response");
        Sender responseSender = exchange.getResponseSender();
        responseSender.send(ByteBuffer.wrap(responseBytes));
        exchange.endExchange();
    }
}

