/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import io.undertow.Undertow;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.jboss.logging.Logger;
import org.junit.rules.ExternalResource;
import org.keycloak.testsuite.x509.AbstractX509AuthenticationTest;

public class CRLRule
extends ExternalResource {
    protected static final Logger log = Logger.getLogger(CRLRule.class);
    private static final String CRL_RESPONDER_HOST = "localhost";
    private static final int CRL_RESPONDER_PORT = 8889;
    public static final String CRL_RESPONDER_ORIGIN = "http://localhost:8889";
    private Undertow crlResponder;

    protected void before() throws Throwable {
        log.info((Object)"Starting CRL Responder");
        PathHandler pathHandler = new PathHandler();
        pathHandler.addExactPath("empty.crl", (HttpHandler)new CRLHandler("empty.crl"));
        pathHandler.addExactPath("intermediate-ca.crl", (HttpHandler)new CRLHandler("intermediate-ca.crl"));
        pathHandler.addExactPath("intermediate-ca-invalid-signature.crl", (HttpHandler)new CRLHandler("intermediate-ca-invalid-signature.crl"));
        pathHandler.addExactPath("intermediate-ca-3.crl", (HttpHandler)new CRLHandler("intermediate-ca-3.crl"));
        this.crlResponder = Undertow.builder().addHttpListener(8889, CRL_RESPONDER_HOST).setHandler((HttpHandler)new BlockingHandler((HttpHandler)pathHandler)).build();
        this.crlResponder.start();
    }

    protected void after() {
        log.info((Object)"Stoping CRL Responder");
        this.crlResponder.stop();
    }

    private class CRLHandler
    implements HttpHandler {
        private String crlFileName;

        public CRLHandler(String crlFileName) {
            this.crlFileName = crlFileName;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.isInIoThread()) {
                exchange.dispatch((HttpHandler)this);
                return;
            }
            String fullFile = AbstractX509AuthenticationTest.getAuthServerHome() + File.separator + this.crlFileName;
            FileInputStream is = new FileInputStream(new File(fullFile));
            byte[] responseBytes = IOUtils.toByteArray((InputStream)is);
            HeaderMap responseHeaders = exchange.getResponseHeaders();
            responseHeaders.put(Headers.CONTENT_TYPE, "application/pkix-crl");
            Sender responseSender = exchange.getResponseSender();
            responseSender.send(ByteBuffer.wrap(responseBytes));
            exchange.endExchange();
        }
    }
}

