/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.x509;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.common.util.Encode;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.x509.X509IdentityConfirmationPage;
import org.keycloak.testsuite.updaters.SetSystemProperty;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.PhantomJSBrowser;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.WebDriver;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractX509AuthenticationTest
extends AbstractTestRealmKeycloakTest {
    public static final String EMPTY_CRL_PATH = "empty.crl";
    public static final String INTERMEDIATE_CA_CRL_PATH = "intermediate-ca.crl";
    public static final String INTERMEDIATE_CA_INVALID_SIGNATURE_CRL_PATH = "intermediate-ca-invalid-signature.crl";
    public static final String INTERMEDIATE_CA_3_CRL_PATH = "intermediate-ca-3.crl";
    protected final Logger log = Logger.getLogger(this.getClass());
    static final String REQUIRED = "REQUIRED";
    static final String OPTIONAL = "OPTIONAL";
    static final String DISABLED = "DISABLED";
    static final String ALTERNATIVE = "ALTERNATIVE";
    public static final String REALM_NAME = "test";
    protected String userId;
    protected String userId2;
    protected AuthenticationManagementResource authMgmtResource;
    protected AuthenticationExecutionInfoRepresentation browserExecution;
    protected AuthenticationExecutionInfoRepresentation directGrantExecution;
    private static SetSystemProperty phantomjsCliArgs;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);
    @Page
    @PhantomJSBrowser
    protected AppPage appPage;
    @Page
    @PhantomJSBrowser
    protected X509IdentityConfirmationPage loginConfirmationPage;
    @Page
    @PhantomJSBrowser
    protected LoginPage loginPage;

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Before
    public void validateConfiguration() {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @BeforeClass
    public static void onBeforeTestClass() {
        AbstractX509AuthenticationTest.configurePhantomJS("/ca.crt", "/client.crt", "/client.key", "password");
    }

    @AfterClass
    public static void onAfterTestClass() {
        phantomjsCliArgs.revert();
    }

    protected static void configurePhantomJS(String certificatesPath, String clientCertificateFile, String clientKeyFile, String clientKeyPassword) {
        String authServerHome = AbstractX509AuthenticationTest.getAuthServerHome();
        if (authServerHome != null && System.getProperty("auth.server.ssl.required") != null) {
            StringBuilder cliArgs = new StringBuilder();
            cliArgs.append("--ignore-ssl-errors=true ");
            cliArgs.append("--web-security=false ");
            cliArgs.append("--ssl-certificates-path=").append(authServerHome).append(certificatesPath).append(" ");
            cliArgs.append("--ssl-client-certificate-file=").append(authServerHome).append(clientCertificateFile).append(" ");
            cliArgs.append("--ssl-client-key-file=").append(authServerHome).append(clientKeyFile).append(" ");
            cliArgs.append("--ssl-client-key-passphrase=" + clientKeyPassword).append(" ");
            phantomjsCliArgs = new SetSystemProperty("keycloak.phantomjs.cli.args", cliArgs.toString());
        }
    }

    private static boolean isAuthServerJBoss() {
        return Boolean.parseBoolean(System.getProperty("auth.server.jboss"));
    }

    protected static String getAuthServerHome() {
        String authServerHome = System.getProperty("auth.server.home");
        if (authServerHome == null) {
            return null;
        }
        if (AbstractX509AuthenticationTest.isAuthServerJBoss()) {
            authServerHome = authServerHome + "/standalone/configuration";
        }
        return authServerHome;
    }

    @Before
    public void configureFlows() {
        this.authMgmtResource = this.adminClient.realms().realm(REALM_NAME).flows();
        AuthenticationFlowRepresentation browserFlow = this.copyBrowserFlow();
        org.junit.Assert.assertNotNull((Object)browserFlow);
        AuthenticationFlowRepresentation directGrantFlow = this.createDirectGrantFlow();
        org.junit.Assert.assertNotNull((Object)directGrantFlow);
        this.setBrowserFlow(browserFlow);
        org.junit.Assert.assertEquals((Object)this.testRealm().toRepresentation().getBrowserFlow(), (Object)browserFlow.getAlias());
        this.setDirectGrantFlow(directGrantFlow);
        org.junit.Assert.assertEquals((Object)this.testRealm().toRepresentation().getDirectGrantFlow(), (Object)directGrantFlow.getAlias());
        org.junit.Assert.assertEquals((long)0L, (long)directGrantFlow.getAuthenticationExecutions().size());
        this.directGrantExecution = this.addAssertExecution(directGrantFlow, "direct-grant-auth-x509-username", REQUIRED);
        org.junit.Assert.assertNotNull((Object)this.directGrantExecution);
        directGrantFlow = this.authMgmtResource.getFlow(directGrantFlow.getId());
        org.junit.Assert.assertNotNull((Object)directGrantFlow.getAuthenticationExecutions());
        org.junit.Assert.assertEquals((long)1L, (long)directGrantFlow.getAuthenticationExecutions().size());
        this.browserExecution = this.addAssertExecution(browserFlow, "auth-x509-client-username-form", ALTERNATIVE);
        org.junit.Assert.assertNotNull((Object)this.browserExecution);
        this.authMgmtResource.raisePriority(this.browserExecution.getId());
        UserRepresentation user = this.findUser("test-user@localhost");
        this.userId = user.getId();
        user.singleAttribute("x509_certificate_identity", "-");
        user.singleAttribute("alternative_email", "test-user-altmail@localhost");
        user.singleAttribute("upn", "test_upn_name@localhost");
        this.updateUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationExecutionInfoRepresentation addAssertExecution(AuthenticationFlowRepresentation flow, String providerId, String requirement) {
        AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
        rep.setPriority(10);
        rep.setAuthenticator(providerId);
        rep.setRequirement(requirement);
        rep.setParentFlow(flow.getId());
        try (Response response = this.authMgmtResource.addExecution(rep);){
            org.junit.Assert.assertEquals((String)"added execution", (long)201L, (long)response.getStatus());
        }
        List executionReps = this.authMgmtResource.getExecutions(flow.getAlias());
        return this.findExecution(providerId, executionReps);
    }

    AuthenticationExecutionInfoRepresentation findExecution(String providerId, List<AuthenticationExecutionInfoRepresentation> reps) {
        for (AuthenticationExecutionInfoRepresentation exec : reps) {
            if (!providerId.equals(exec.getProviderId())) continue;
            return exec;
        }
        return null;
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation app = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("resource-owner").directAccessGrants().secret("secret").build();
        UserRepresentation user = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("Keycloak").email("localhost@localhost").enabled(true).password("password").addAttribute("x509_issuer_identity", "Keycloak Intermediate CA").build();
        this.userId2 = user.getId();
        ClientRepresentation client = this.findTestApp(testRealm);
        URI baseUri = URI.create((String)client.getRedirectUris().get(0));
        URI redir = URI.create("https://localhost:" + System.getProperty("auth.server.https.port", "8543") + baseUri.getRawPath());
        client.getRedirectUris().add(redir.toString());
        testRealm.setBruteForceProtected(Boolean.valueOf(true));
        testRealm.setFailureFactor(Integer.valueOf(2));
        RealmBuilder.edit(testRealm).user(user).client(app);
    }

    AuthenticationFlowRepresentation createFlow(AuthenticationFlowRepresentation flowRep) {
        try (Response response = this.authMgmtResource.createFlow(flowRep);){
            Assert.assertEquals((long)201L, (long)response.getStatus());
        }
        this.assertAdminEvents.assertEvent(REALM_NAME, OperationType.CREATE, AssertAdminEvents.isExpectedPrefixFollowedByUuid(AdminEventPaths.authFlowsPath()), (Object)flowRep, ResourceType.AUTH_FLOW);
        for (AuthenticationFlowRepresentation flow : this.authMgmtResource.getFlows()) {
            if (!flow.getAlias().equalsIgnoreCase(flowRep.getAlias())) continue;
            return flow;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationFlowRepresentation copyFlow(String existingFlow, String newFlow) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", newFlow);
        Response response = this.authMgmtResource.copy(existingFlow, params);
        this.assertAdminEvents.assertEvent(REALM_NAME, OperationType.CREATE, Encode.decode((String)AdminEventPaths.authCopyFlowPath(existingFlow)), params, ResourceType.AUTH_FLOW);
        try {
            org.junit.Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        for (AuthenticationFlowRepresentation flow : this.authMgmtResource.getFlows()) {
            if (!flow.getAlias().equalsIgnoreCase(newFlow)) continue;
            return flow;
        }
        return null;
    }

    AuthenticationFlowRepresentation createDirectGrantFlow() {
        AuthenticationFlowRepresentation newFlow = this.newFlow("Copy-of-direct-grant", "desc", "basic-flow", true, false);
        return this.createFlow(newFlow);
    }

    AuthenticationFlowRepresentation newFlow(String alias, String description, String providerId, boolean topLevel, boolean builtIn) {
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(alias);
        flow.setDescription(description);
        flow.setProviderId(providerId);
        flow.setTopLevel(topLevel);
        flow.setBuiltIn(builtIn);
        return flow;
    }

    AuthenticationFlowRepresentation copyBrowserFlow() {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        return this.copyFlow(realm.getBrowserFlow(), "Copy-of-browser");
    }

    void setBrowserFlow(AuthenticationFlowRepresentation flow) {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setBrowserFlow(flow.getAlias());
        this.testRealm().update(realm);
    }

    void setDirectGrantFlow(AuthenticationFlowRepresentation flow) {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setDirectGrantFlow(flow.getAlias());
        this.testRealm().update(realm);
    }

    static AuthenticatorConfigRepresentation newConfig(String alias, Map<String, String> params) {
        AuthenticatorConfigRepresentation config = new AuthenticatorConfigRepresentation();
        config.setAlias(alias);
        config.setConfig(params);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createConfig(String executionId, AuthenticatorConfigRepresentation cfg) {
        try (Response resp = this.authMgmtResource.newExecutionConfig(executionId, cfg);){
            org.junit.Assert.assertEquals((long)201L, (long)resp.getStatus());
        }
        return ApiUtil.getCreatedId((Response)resp);
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectEmail2UsernameOrEmailConfig() {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectAltNameEmail2UserAttributeConfig() {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTALTNAME_EMAIL).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName("alternative_email");
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectAltNameOtherName2UserAttributeConfig() {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTALTNAME_OTHERNAME).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName("upn");
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectEmailWithKeyUsage(String keyUsage) {
        return AbstractX509AuthenticationTest.createLoginSubjectEmail2UsernameOrEmailConfig().setKeyUsage(keyUsage);
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectEmailWithExtendedKeyUsage(String extendedKeyUsage) {
        return AbstractX509AuthenticationTest.createLoginSubjectEmail2UsernameOrEmailConfig().setExtendedKeyUsage(extendedKeyUsage);
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectEmailWithRevalidateCert(boolean revalidateCertEnabled) {
        return AbstractX509AuthenticationTest.createLoginSubjectEmail2UsernameOrEmailConfig().setRevalidateCertificateEnabled(revalidateCertEnabled);
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectCN2UsernameOrEmailConfig() {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN_CN).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USERNAME_EMAIL);
    }

    protected static X509AuthenticatorConfigModel createLoginWithSpecifiedSourceTypeToCustomAttributeConfig(X509AuthenticatorConfigModel.MappingSourceType sourceType, String userAttributeName) {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(sourceType).setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName(userAttributeName);
    }

    protected static X509AuthenticatorConfigModel createLoginIssuerDN_OU2CustomAttributeConfig() {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.ISSUERDN).setRegularExpression("O=(.*?)(?:,|$)").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName("x509_certificate_identity");
    }

    protected static X509AuthenticatorConfigModel createLoginSubjectDNToCustomAttributeConfig(boolean canonicalDnEnabled) {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setCanonicalDnEnabled(canonicalDnEnabled).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.SUBJECTDN).setRegularExpression("(.*?)(?:$)").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName("x509_certificate_identity");
    }

    protected static X509AuthenticatorConfigModel createLoginIssuerDNToCustomAttributeConfig(boolean canonicalDnEnabled) {
        return new X509AuthenticatorConfigModel().setConfirmationPageAllowed(true).setCanonicalDnEnabled(canonicalDnEnabled).setMappingSourceType(X509AuthenticatorConfigModel.MappingSourceType.ISSUERDN).setRegularExpression("(.*?)(?:$)").setUserIdentityMapperType(X509AuthenticatorConfigModel.IdentityMapperType.USER_ATTRIBUTE).setCustomAttributeName("x509_certificate_identity");
    }

    protected void setUserEnabled(String userName, boolean enabled) {
        UserRepresentation user = this.findUser(userName);
        org.junit.Assert.assertNotNull((Object)user);
        user.setEnabled(Boolean.valueOf(enabled));
        this.updateUser(user);
    }

    public void replaceDefaultWebDriver(WebDriver driver) {
        this.driver = driver;
        DroneUtils.addWebDriver((WebDriver)driver);
        ArrayList<Field> allFields = new ArrayList<Field>();
        Class<?> testClass = this.getClass();
        while (AbstractX509AuthenticationTest.class.isAssignableFrom(testClass)) {
            allFields.addAll(Arrays.asList(testClass.getDeclaredFields()));
            allFields.addAll(Arrays.asList(testClass.getFields()));
            testClass = testClass.getSuperclass();
        }
        for (Field f : allFields) {
            if (f.getAnnotation(Page.class) == null) continue;
            try {
                AbstractPage page = (AbstractPage)f.get(this);
                page.setDriver(driver);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not replace the driver in " + f, e);
            }
        }
    }

    protected void x509BrowserLogin(X509AuthenticatorConfigModel config, String userId, String username, String attemptedUsername) {
        AuthenticatorConfigRepresentation cfg = AbstractX509AuthenticationTest.newConfig("x509-browser-config", config.getConfig());
        String cfgId = this.createConfig(this.browserExecution.getId(), cfg);
        org.junit.Assert.assertNotNull((Object)cfgId);
        this.loginConfirmationPage.open();
        org.junit.Assert.assertTrue((boolean)this.loginConfirmationPage.getSubjectDistinguishedNameText().startsWith("EMAILADDRESS=test-user@localhost"));
        org.junit.Assert.assertEquals((Object)username, (Object)this.loginConfirmationPage.getUsernameText());
        this.loginConfirmationPage.confirm();
        org.junit.Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        org.junit.Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectLogin().user(userId).detail("username", attemptedUsername).removeDetail("redirect_uri");
        this.addX509CertificateDetails(expectedEvent).assertEvent();
    }

    protected AssertEvents.ExpectedEvent addX509CertificateDetails(AssertEvents.ExpectedEvent expectedEvent) {
        return expectedEvent.detail("x509_cert_serial_number", (Matcher<? super String>)Matchers.not((Matcher)Matchers.isEmptyOrNullString())).detail("x509_cert_subject_distinguished_name", (Matcher<? super String>)Matchers.startsWith((String)"EMAILADDRESS=test-user@localhost")).detail("x509_cert_issuer_distinguished_name", (Matcher<? super String>)Matchers.startsWith((String)"EMAILADDRESS=contact@keycloak.org"));
    }
}

