/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.validation;

import java.util.Collections;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.Validators;

public class ValidatorTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.user("alice");
    }

    @Test
    public void testDateValidator() {
        this.getTestingClient().server("test").run(ValidatorTest::testDateValidator);
    }

    private static void testDateValidator(KeycloakSession session) {
        Assert.assertTrue((boolean)Validators.dateValidator().validate(null, new ValidationContext(session)).isValid());
        Assert.assertTrue((boolean)Validators.dateValidator().validate((Object)"", new ValidationContext(session)).isValid());
        Assert.assertFalse((boolean)Validators.dateValidator().validate((Object)"13/12/2021", new ValidationContext(session)).isValid());
        Assert.assertFalse((boolean)Validators.dateValidator().validate((Object)"13/12/21", new ValidationContext(session)).isValid());
        Assert.assertTrue((boolean)Validators.dateValidator().validate((Object)"12/13/2021", new ValidationContext(session)).isValid());
        RealmModel realm = session.getContext().getRealm();
        realm.setInternationalizationEnabled(true);
        realm.setDefaultLocale(Locale.FRANCE.getLanguage());
        Assert.assertTrue((boolean)Validators.dateValidator().validate((Object)"13/12/21", new ValidationContext(session)).isValid());
        Assert.assertTrue((boolean)Validators.dateValidator().validate((Object)"13/12/2021", new ValidationContext(session)).isValid());
        Assert.assertFalse((boolean)Validators.dateValidator().validate((Object)"12/13/2021", new ValidationContext(session)).isValid());
        UserModel alice = session.users().getUserByUsername(realm, "alice");
        alice.setAttribute("locale", Collections.singletonList(Locale.ENGLISH.getLanguage()));
        ValidationContext context = new ValidationContext(session);
        context.getAttributes().put(UserModel.class.getName(), alice);
        Assert.assertFalse((boolean)Validators.dateValidator().validate((Object)"13/12/2021", context).isValid());
    }
}

