/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class RealmRepUtil {
    private RealmRepUtil() {
    }

    public static UserRepresentation findUser(RealmRepresentation testRealm, String userName) {
        for (UserRepresentation user : testRealm.getUsers()) {
            if (!user.getUsername().equals(userName)) continue;
            return user;
        }
        return null;
    }

    public static ClientRepresentation findClientByClientId(RealmRepresentation testRealm, String clientId) {
        for (ClientRepresentation client : testRealm.getClients()) {
            if (!client.getClientId().equals(clientId)) continue;
            return client;
        }
        return null;
    }

    public static ClientRepresentation findClientById(RealmRepresentation testRealm, String id) {
        for (ClientRepresentation client : testRealm.getClients()) {
            if (!client.getId().equals(id)) continue;
            return client;
        }
        return null;
    }

    public static RoleRepresentation findRealmRole(RealmRepresentation realm, String roleName) {
        if (realm.getRoles() == null) {
            return null;
        }
        if (realm.getRoles().getRealm() == null) {
            return null;
        }
        for (RoleRepresentation role : realm.getRoles().getRealm()) {
            if (!role.getName().equals(roleName)) continue;
            return role;
        }
        return null;
    }

    public static RoleRepresentation findClientRole(RealmRepresentation realm, String clientId, String roleName) {
        if (realm.getRoles() == null) {
            return null;
        }
        if (realm.getRoles().getClient() == null) {
            return null;
        }
        if (realm.getRoles().getClient().get(clientId) == null) {
            return null;
        }
        for (RoleRepresentation role : (List)realm.getRoles().getClient().get(clientId)) {
            if (!roleName.equals(role.getName())) continue;
            return role;
        }
        return null;
    }

    public static String findDefaultRole(RealmRepresentation realm, String roleName) {
        if (realm.getDefaultRoles() == null) {
            return null;
        }
        for (String role : realm.getDefaultRoles()) {
            if (!role.equals(roleName)) continue;
            return role;
        }
        return null;
    }

    public static Set<RoleRepresentation> allRoles(RealmRepresentation realm, UserRepresentation user) {
        HashSet<RoleRepresentation> allRoles = new HashSet<RoleRepresentation>();
        for (String roleName : user.getRealmRoles()) {
            allRoles.add(RealmRepUtil.findRealmRole(realm, roleName));
        }
        for (String clientId : user.getClientRoles().keySet()) {
            for (String roleName : (List)user.getClientRoles().get(clientId)) {
                allRoles.add(RealmRepUtil.findClientRole(realm, clientId, roleName));
            }
        }
        return allRoles;
    }
}

