/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.http.entity.ContentType;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.representations.LogoutToken;
import org.keycloak.util.JsonSerialization;

public class LogoutTokenUtil {
    public static String generateSignedLogoutToken(PrivateKey privateKey, String keyId, String issuer, String clientId, String userId, String sessionId, boolean revokeOfflineSessions) throws IOException {
        JWSHeader jwsHeader = new JWSHeader(Algorithm.RS256, "JWT", ContentType.APPLICATION_JSON.toString(), keyId);
        String logoutTokenHeaderEncoded = Base64Url.encode((byte[])JsonSerialization.writeValueAsBytes((Object)jwsHeader));
        LogoutToken logoutToken = new LogoutToken();
        logoutToken.setSid(sessionId);
        logoutToken.putEvents("http://schemas.openid.net/event/backchannel-logout", new HashMap());
        logoutToken.putEvents("revoke_offline_access", (Object)revokeOfflineSessions);
        logoutToken.setSubject(userId);
        logoutToken.issuer(issuer);
        logoutToken.id(UUID.randomUUID().toString());
        logoutToken.issuedNow();
        logoutToken.audience(new String[]{clientId});
        String logoutTokenPayloadEncoded = Base64Url.encode((byte[])JsonSerialization.writeValueAsBytes((Object)logoutToken));
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            String data = logoutTokenHeaderEncoded + "." + logoutTokenPayloadEncoded;
            byte[] dataByteArray = data.getBytes();
            signature.update(dataByteArray);
            byte[] signatureByteArray = signature.sign();
            return data + "." + Base64Url.encode((byte[])signatureByteArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return null;
        }
    }
}

