/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.junit.rules.ExternalResource;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.CrossDCTestEnricher;

public class InfinispanTestTimeServiceRule
extends ExternalResource {
    private static final Logger log = Logger.getLogger(InfinispanTestTimeServiceRule.class);
    private final AbstractKeycloakTest test;

    public InfinispanTestTimeServiceRule(AbstractKeycloakTest test) {
        this.test = test;
    }

    protected void before() throws Throwable {
        if (!this.test.getTestContext().getSuiteContext().isAuthServerCrossDc()) {
            this.test.getTestingClient().testing().setTestingInfinispanTimeService();
        } else {
            AtomicInteger count = new AtomicInteger(0);
            CrossDCTestEnricher.forAllBackendNodesStream().filter(ContainerInfo::isStarted).map(CrossDCTestEnricher.getBackendTestingClients()::get).forEach(testingClient -> {
                testingClient.testing().setTestingInfinispanTimeService();
                count.incrementAndGet();
            });
            log.infof("Totally set infinispanTimeService rule in %d servers", (Object)count.get());
        }
    }

    protected void after() {
        if (!this.test.getTestContext().getSuiteContext().isAuthServerCrossDc()) {
            this.test.getTestingClient().testing().revertTestingInfinispanTimeService();
        } else {
            CrossDCTestEnricher.forAllBackendNodesStream().filter(ContainerInfo::isStarted).map(CrossDCTestEnricher.getBackendTestingClients()::get).forEach(testingClient -> testingClient.testing().revertTestingInfinispanTimeService());
        }
    }
}

