/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.AuthenticationManagementResource;

public class FlowUtil {
    private RealmModel realm;
    private AuthenticationFlowModel currentFlow;
    private String flowAlias;
    private int maxPriority = 0;
    private Random rand = new Random(System.currentTimeMillis());
    private List<AuthenticationExecutionModel> executions = null;

    public FlowUtil(RealmModel realm) {
        this.realm = realm;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public AuthenticationFlowModel build() {
        return this.currentFlow;
    }

    public static FlowUtil inCurrentRealm(KeycloakSession session) {
        return new FlowUtil(session.getContext().getRealm());
    }

    private FlowUtil newFlowUtil(AuthenticationFlowModel flowModel) {
        FlowUtil subflow = new FlowUtil(this.realm);
        subflow.currentFlow = flowModel;
        return subflow;
    }

    public FlowUtil selectFlow(String flowAlias) {
        this.currentFlow = this.realm.getFlowByAlias(flowAlias);
        if (this.currentFlow == null) {
            throw new FlowUtilException("Can't select flow: " + flowAlias + " does not exist");
        }
        this.flowAlias = flowAlias;
        return this;
    }

    public FlowUtil copyBrowserFlow(String newFlowAlias) {
        return this.copyFlow("browser", newFlowAlias);
    }

    public FlowUtil copyResetCredentialsFlow(String newFlowAlias) {
        return this.copyFlow("reset credentials", newFlowAlias);
    }

    public FlowUtil copyFirstBrokerLoginFlow(String newFlowAlias) {
        return this.copyFlow("first broker login", newFlowAlias);
    }

    public FlowUtil copyRegistrationFlow(String newFlowAlias) {
        return this.copyFlow("registration", newFlowAlias);
    }

    public FlowUtil copyDirectGrantFlow(String newFlowAlias) {
        return this.copyFlow("direct grant", newFlowAlias);
    }

    public FlowUtil copyFlow(String original, String newFlowAlias) {
        this.flowAlias = newFlowAlias;
        AuthenticationFlowModel existingBrowserFlow = this.realm.getFlowByAlias(original);
        if (existingBrowserFlow == null) {
            throw new FlowUtilException("Can't copy flow: " + original + " does not exist");
        }
        this.currentFlow = AuthenticationManagementResource.copyFlow((RealmModel)this.realm, (AuthenticationFlowModel)existingBrowserFlow, (String)newFlowAlias);
        return this;
    }

    public FlowUtil inForms(Consumer<FlowUtil> subFlowInitializer) {
        return this.inFlow(this.flowAlias + " forms", subFlowInitializer);
    }

    public FlowUtil inVerifyExistingAccountByReAuthentication(Consumer<FlowUtil> subFlowInitializer) {
        return this.inFlow(this.flowAlias + " Verify Existing Account by Re-authentication", subFlowInitializer);
    }

    public FlowUtil inFlow(String alias, Consumer<FlowUtil> subFlowInitializer) {
        if (subFlowInitializer != null) {
            AuthenticationFlowModel flow = this.realm.getFlowByAlias(alias);
            if (flow == null) {
                throw new FlowUtilException("Can't find flow by alias: " + alias);
            }
            FlowUtil subFlow = this.newFlowUtil(flow);
            subFlowInitializer.accept(subFlow);
        }
        return this;
    }

    public FlowUtil clear() {
        this.realm.getAuthenticationExecutionsStream(this.currentFlow.getId()).forEachOrdered(arg_0 -> ((RealmModel)this.realm).removeAuthenticatorExecution(arg_0));
        return this;
    }

    public FlowUtil addAuthenticatorExecution(AuthenticationExecutionModel.Requirement requirement, String providerId) {
        return this.addAuthenticatorExecution(requirement, providerId, null);
    }

    public FlowUtil addAuthenticatorExecution(AuthenticationExecutionModel.Requirement requirement, String providerId, int priority) {
        return this.addAuthenticatorExecution(requirement, providerId, priority, null);
    }

    public FlowUtil addAuthenticatorExecution(AuthenticationExecutionModel.Requirement requirement, String providerId, Consumer<AuthenticatorConfigModel> configInitializer) {
        return this.addAuthenticatorExecution(requirement, providerId, this.maxPriority + 10, configInitializer);
    }

    public FlowUtil addAuthenticatorExecution(AuthenticationExecutionModel.Requirement requirement, String providerId, int priority, Consumer<AuthenticatorConfigModel> configInitializer) {
        this.maxPriority = Math.max(this.maxPriority, priority);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setRequirement(requirement);
        execution.setAuthenticatorFlow(false);
        execution.setAuthenticator(providerId);
        execution.setPriority(priority);
        execution.setParentFlow(this.currentFlow.getId());
        if (configInitializer != null) {
            AuthenticatorConfigModel authConfig = new AuthenticatorConfigModel();
            authConfig.setId(UUID.randomUUID().toString());
            authConfig.setAlias("cfg" + authConfig.getId().hashCode());
            authConfig.setConfig(new HashMap());
            configInitializer.accept(authConfig);
            this.realm.addAuthenticatorConfig(authConfig);
            execution.setAuthenticatorConfig(authConfig.getId());
        }
        this.realm.addAuthenticatorExecution(execution);
        return this;
    }

    public FlowUtil defineAsBrowserFlow() {
        this.realm.setBrowserFlow(this.currentFlow);
        return this;
    }

    public FlowUtil defineAsDirectGrantFlow() {
        this.realm.setDirectGrantFlow(this.currentFlow);
        return this;
    }

    public FlowUtil defineAsResetCredentialsFlow() {
        this.realm.setResetCredentialsFlow(this.currentFlow);
        return this;
    }

    public FlowUtil defineAsRegistrationFlow() {
        this.realm.setRegistrationFlow(this.currentFlow);
        return this;
    }

    public FlowUtil usesInIdentityProvider(String idpAlias) {
        IdentityProviderModel idp = this.realm.getIdentityProviderByAlias(idpAlias);
        idp.setFirstBrokerLoginFlowId(this.currentFlow.getId());
        this.realm.updateIdentityProvider(idp);
        return this;
    }

    public FlowUtil addSubFlowExecution(AuthenticationExecutionModel.Requirement requirement, Consumer<FlowUtil> flowInitializer) {
        return this.addSubFlowExecution("sf" + this.rand.nextInt(), "basic-flow", requirement, flowInitializer);
    }

    public FlowUtil addSubFlowExecution(String alias, String providerId, AuthenticationExecutionModel.Requirement requirement, Consumer<FlowUtil> flowInitializer) {
        return this.addSubFlowExecution(alias, providerId, requirement, this.maxPriority + 10, flowInitializer);
    }

    public FlowUtil addSubFlowExecution(String alias, String providerId, AuthenticationExecutionModel.Requirement requirement, int priority, Consumer<FlowUtil> flowInitializer) {
        AuthenticationFlowModel flowModel = FlowUtil.createFlowModel(alias, providerId, null, false, false);
        return this.addSubFlowExecution(flowModel, requirement, priority, flowInitializer);
    }

    public static AuthenticationFlowModel createFlowModel(String alias, String providerId, String desc, boolean topLevel, boolean builtIn) {
        AuthenticationFlowModel flowModel = new AuthenticationFlowModel();
        flowModel.setId(UUID.randomUUID().toString());
        flowModel.setAlias(alias);
        flowModel.setDescription(desc);
        flowModel.setProviderId(providerId);
        flowModel.setTopLevel(topLevel);
        flowModel.setBuiltIn(builtIn);
        return flowModel;
    }

    public FlowUtil addSubFlowExecution(AuthenticationFlowModel flowModel, AuthenticationExecutionModel.Requirement requirement, Consumer<FlowUtil> flowInitializer) {
        return this.addSubFlowExecution(flowModel, requirement, this.maxPriority + 10, flowInitializer);
    }

    public FlowUtil addSubFlowExecution(AuthenticationFlowModel flowModel, AuthenticationExecutionModel.Requirement requirement, int priority, Consumer<FlowUtil> flowInitializer) {
        this.maxPriority = Math.max(this.maxPriority, priority);
        flowModel = this.realm.addAuthenticationFlow(flowModel);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setRequirement(requirement);
        if (flowModel.getProviderId() == "form-flow") {
            execution.setAuthenticator("registration-page-form");
        }
        execution.setAuthenticatorFlow(true);
        execution.setPriority(priority);
        execution.setFlowId(flowModel.getId());
        execution.setParentFlow(this.currentFlow.getId());
        this.realm.addAuthenticatorExecution(execution);
        if (flowInitializer != null) {
            FlowUtil subflow = this.newFlowUtil(flowModel);
            flowInitializer.accept(subflow);
        }
        return this;
    }

    public List<AuthenticationExecutionModel> getExecutions() {
        if (this.executions == null) {
            this.executions = this.realm.getAuthenticationExecutionsStream(this.currentFlow.getId()).collect(Collectors.toList());
        }
        return this.executions;
    }

    public FlowUtil removeExecution(int index) {
        List<AuthenticationExecutionModel> executions = this.getExecutions();
        this.realm.removeAuthenticatorExecution(executions.remove(index));
        return this;
    }

    public FlowUtil updateExecution(int index, Consumer<AuthenticationExecutionModel> updater) {
        List<AuthenticationExecutionModel> executions = this.getExecutions();
        if (executions != null && updater != null) {
            AuthenticationExecutionModel execution = executions.get(index);
            updater.accept(execution);
            this.realm.updateAuthenticatorExecution(execution);
        }
        return this;
    }

    public class FlowUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 5118401044519260295L;

        public FlowUtilException(String message) {
            super(message);
        }
    }
}

