/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.util.JsonSerialization;

public class AssertAdminEvents
implements TestRule {
    private AbstractKeycloakTest context;

    public AssertAdminEvents(AbstractKeycloakTest ctx) {
        this.context = ctx;
    }

    public Statement apply(final Statement base, org.junit.runner.Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AssertAdminEvents.this.clear();
                base.evaluate();
            }
        };
    }

    public AdminEventRepresentation poll() {
        AdminEventRepresentation event = this.fetchNextEvent();
        Assert.assertNotNull((String)"Admin event expected", (Object)event);
        return event;
    }

    public void assertEmpty() {
        AdminEventRepresentation event = this.fetchNextEvent();
        Assert.assertNull((String)("Empty admin event queue expected, but there is " + event), (Object)event);
    }

    public void clear() {
        this.context.getTestingClient().testing().clearAdminEventQueue();
    }

    private AdminEventRepresentation fetchNextEvent() {
        return this.context.getTestingClient().testing().pollAdminEvent();
    }

    public ExpectedAdminEvent expect() {
        return new ExpectedAdminEvent();
    }

    public AdminEventRepresentation assertEvent(String realmId, OperationType operationType, String resourcePath, ResourceType resourceType) {
        return this.assertEvent(realmId, operationType, resourcePath, null, resourceType);
    }

    public AdminEventRepresentation assertEvent(String realmId, OperationType operationType, Matcher<String> resourcePath, ResourceType resourceType) {
        return this.assertEvent(realmId, operationType, resourcePath, null, resourceType);
    }

    public AdminEventRepresentation assertEvent(String realmId, OperationType operationType, String resourcePath, Object representation, ResourceType resourceType) {
        return this.assertEvent(realmId, operationType, (Matcher<String>)Matchers.equalTo((Object)resourcePath), representation, resourceType);
    }

    public AdminEventRepresentation assertEvent(String realmId, OperationType operationType, Matcher<String> resourcePath, Object representation, ResourceType resourceType) {
        return this.expect().realmId(realmId).operationType(operationType).resourcePath(resourcePath).resourceType(resourceType).representation(representation).assertEvent();
    }

    private AuthDetailsRepresentation defaultAuthDetails() {
        String accessTokenString = this.context.getAdminClient().tokenManager().getAccessTokenString();
        try {
            JWSInput input = new JWSInput(accessTokenString);
            AccessToken token = (AccessToken)input.readJsonContent(AccessToken.class);
            AuthDetailsRepresentation authDetails = new AuthDetailsRepresentation();
            String realmId = token.getIssuer().substring(token.getIssuer().lastIndexOf(47) + 1);
            authDetails.setRealmId(realmId);
            authDetails.setUserId(token.getSubject());
            return authDetails;
        }
        catch (JWSInputException jwe) {
            throw new RuntimeException(jwe);
        }
    }

    public static Matcher<String> isExpectedPrefixFollowedByUuid(final String prefix) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                int expectedLength = prefix.length() + 1 + KeycloakModelUtils.generateId().length();
                return item.startsWith(prefix) && expectedLength == item.length();
            }

            public void describeTo(Description description) {
                description.appendText("resourcePath in the format like \"" + prefix + "/<UUID>\"");
            }
        };
    }

    public class ExpectedAdminEvent {
        private AdminEventRepresentation expected = new AdminEventRepresentation();
        private Matcher<String> resourcePath;
        private ResourceType resourceType;
        private Object expectedRep;

        public ExpectedAdminEvent realmId(String realmId) {
            this.expected.setRealmId(realmId);
            return this;
        }

        public ExpectedAdminEvent realm(RealmRepresentation realm) {
            return this.realmId(realm.getId());
        }

        public ExpectedAdminEvent operationType(OperationType operationType) {
            this.expected.setOperationType(operationType.toString());
            this.updateOperationTypeIfError();
            return this;
        }

        public ExpectedAdminEvent resourcePath(String resourcePath) {
            return this.resourcePath((Matcher<String>)Matchers.equalTo((Object)resourcePath));
        }

        public ExpectedAdminEvent resourcePath(Matcher<String> resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public ExpectedAdminEvent resourceType(ResourceType resourceType) {
            this.expected.setResourceType(resourceType.toString());
            return this;
        }

        public ExpectedAdminEvent error(String error) {
            this.expected.setError(error);
            this.updateOperationTypeIfError();
            return this;
        }

        private void updateOperationTypeIfError() {
            if (this.expected.getError() != null && this.expected.getOperationType() != null) {
                this.expected.setOperationType(this.expected.getOperationType() + "_ERROR");
            }
        }

        public ExpectedAdminEvent authDetails(String realmId, String clientId, String userId) {
            AuthDetailsRepresentation authDetails = new AuthDetailsRepresentation();
            authDetails.setRealmId(realmId);
            authDetails.setClientId(clientId);
            authDetails.setUserId(userId);
            this.expected.setAuthDetails(authDetails);
            return this;
        }

        public ExpectedAdminEvent representation(Object representation) {
            this.expectedRep = representation;
            return this;
        }

        public AdminEventRepresentation assertEvent() {
            return this.assertEvent(AssertAdminEvents.this.poll());
        }

        public AdminEventRepresentation assertEvent(AdminEventRepresentation actual) {
            Assert.assertEquals((Object)this.expected.getRealmId(), (Object)actual.getRealmId());
            Assert.assertThat((Object)actual.getResourcePath(), this.resourcePath);
            Assert.assertEquals((Object)this.expected.getResourceType(), (Object)actual.getResourceType());
            Assert.assertEquals((Object)this.expected.getOperationType(), (Object)actual.getOperationType());
            Assert.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)this.expected.getError(), (Object)actual.getError()));
            AuthDetailsRepresentation expectedAuth = this.expected.getAuthDetails();
            if (expectedAuth == null) {
                expectedAuth = AssertAdminEvents.this.defaultAuthDetails();
            }
            AuthDetailsRepresentation actualAuth = actual.getAuthDetails();
            Assert.assertEquals((Object)expectedAuth.getRealmId(), (Object)actualAuth.getRealmId());
            Assert.assertEquals((Object)expectedAuth.getUserId(), (Object)actualAuth.getUserId());
            if (expectedAuth.getClientId() != null) {
                Assert.assertEquals((Object)expectedAuth.getClientId(), (Object)actualAuth.getClientId());
            }
            if (this.expectedRep != null) {
                if (actual.getRepresentation() == null) {
                    Assert.fail((String)("Expected representation " + this.expectedRep + " but no representation was available on actual event"));
                } else {
                    try {
                        if (this.expectedRep instanceof List) {
                            List expectedRoles = (List)this.expectedRep;
                            List actualRoles = (List)JsonSerialization.readValue((InputStream)new ByteArrayInputStream(actual.getRepresentation().getBytes()), (TypeReference)new TypeReference<List<RoleRepresentation>>(){});
                            HashMap<String, String> expectedRolesMap = new HashMap<String, String>();
                            for (Object role : expectedRoles) {
                                expectedRolesMap.put(role.getId(), role.getName());
                            }
                            HashMap<String, String> actualRolesMap = new HashMap<String, String>();
                            for (RoleRepresentation role : actualRoles) {
                                actualRolesMap.put(role.getId(), role.getName());
                            }
                            Assert.assertEquals(expectedRolesMap, actualRolesMap);
                        } else if (this.expectedRep instanceof Map) {
                            Object actualRep = JsonSerialization.readValue((String)actual.getRepresentation(), Map.class);
                            Map expectedRepMap = (Map)this.expectedRep;
                            Map actualRepMap = (Map)actualRep;
                            for (Map.Entry entry : expectedRepMap.entrySet()) {
                                Object expectedValue = entry.getValue();
                                if (expectedValue == null) continue;
                                Object actualValue = actualRepMap.get(entry.getKey());
                                Assert.assertEquals((String)("Map item with key '" + entry.getKey() + "' not equal."), expectedValue, actualValue);
                            }
                        } else {
                            Object actualRep = JsonSerialization.readValue((String)actual.getRepresentation(), this.expectedRep.getClass());
                            for (Method method : Reflections.getAllDeclaredMethods(this.expectedRep.getClass())) {
                                Object expectedValue;
                                if (method.getParameterCount() != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || (expectedValue = Reflections.invokeMethod((Method)method, (Object)this.expectedRep, (Object[])new Object[0])) == null) continue;
                                Object actualValue = Reflections.invokeMethod((Method)method, (Object)actualRep, (Object[])new Object[0]);
                                Assert.assertEquals((String)("Property method '" + method.getName() + "' of representation not equal."), (Object)expectedValue, (Object)actualValue);
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
            return actual;
        }
    }
}

