/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class AdapterServletDeployment {
    public static final String JBOSS_DEPLOYMENT_STRUCTURE_XML = "jboss-deployment-structure.xml";
    public static final String TOMCAT_CONTEXT_XML = "context.xml";
    public static final URL tomcatContext = AdapterServletDeployment.class.getResource("/adapter-test/context.xml");

    public static WebArchive oidcDeployment(String name, String configRoot, Class ... servletClasses) {
        return AdapterServletDeployment.oidcDeployment(name, configRoot, "keycloak.json", new Class[0]);
    }

    public static WebArchive oidcDeployment(String name, String configRoot, String adapterConfigFilename, Class ... servletClasses) {
        URL jbossDeploymentStructure;
        String configPath = configRoot + "/" + name;
        String webInfPath = configPath + "/WEB-INF/";
        URL keycloakJSON = AdapterServletDeployment.class.getResource(webInfPath + adapterConfigFilename);
        URL webXML = AdapterServletDeployment.class.getResource(webInfPath + "web.xml");
        WebArchive deployment = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(name + ".war"))).addClasses(servletClasses)).addAsWebInfResource(webXML, "web.xml");
        URL keystore = AdapterServletDeployment.class.getResource(webInfPath + "keystore.jks");
        if (keystore != null) {
            deployment.addAsWebInfResource(keystore, "classes/keystore.jks");
        }
        if (keycloakJSON != null) {
            deployment.addAsWebInfResource(keycloakJSON, "keycloak.json");
        }
        if ((jbossDeploymentStructure = AdapterServletDeployment.class.getResource(webInfPath + JBOSS_DEPLOYMENT_STRUCTURE_XML)) == null) {
            jbossDeploymentStructure = AdapterServletDeployment.class.getResource(configRoot + "/" + JBOSS_DEPLOYMENT_STRUCTURE_XML);
        }
        if (jbossDeploymentStructure != null) {
            deployment.addAsWebInfResource(jbossDeploymentStructure, JBOSS_DEPLOYMENT_STRUCTURE_XML);
        }
        AdapterServletDeployment.addContextXml((Archive)deployment, name);
        return deployment;
    }

    public static void addContextXml(Archive archive, String contextPath) {
        try {
            String contextXmlContent = IOUtils.toString((InputStream)tomcatContext.openStream()).replace("%CONTEXT_PATH%", contextPath);
            archive.add((Asset)new StringAsset(contextXmlContent), "/META-INF/context.xml");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

