/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.user.profile.config;

import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.config.UPConfigUtils;

public class UPConfigUtilsTest {
    @Test
    public void canBeAuthFlowContext() {
        Assert.assertFalse((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.ACCOUNT));
        Assert.assertFalse((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.ACCOUNT_OLD));
        Assert.assertFalse((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.USER_API));
        Assert.assertTrue((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.IDP_REVIEW));
        Assert.assertTrue((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.REGISTRATION_PROFILE));
        Assert.assertTrue((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.REGISTRATION_USER_CREATION));
        Assert.assertTrue((boolean)UPConfigUtils.canBeAuthFlowContext((UserProfileContext)UserProfileContext.UPDATE_PROFILE));
    }

    @Test
    public void isRoleForContext() {
        Assert.assertFalse((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT, null));
        HashSet<String> roles = new HashSet<String>();
        roles.add("admin");
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.USER_API, roles));
        Assert.assertFalse((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT, roles));
        Assert.assertFalse((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT_OLD, roles));
        Assert.assertFalse((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.UPDATE_PROFILE, roles));
        roles = new HashSet();
        roles.add("user");
        Assert.assertFalse((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.USER_API, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT_OLD, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.IDP_REVIEW, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.REGISTRATION_PROFILE, roles));
        roles.add("admin");
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.USER_API, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.ACCOUNT_OLD, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.IDP_REVIEW, roles));
        Assert.assertTrue((boolean)UPConfigUtils.isRoleForContext((UserProfileContext)UserProfileContext.REGISTRATION_PROFILE, roles));
    }

    @Test
    public void breakString() {
        List ret = UPConfigUtils.getChunks(null, (int)2);
        Assert.assertEquals((long)0L, (long)ret.size());
        ret = UPConfigUtils.getChunks((String)"", (int)2);
        this.assertListContent(ret, "");
        ret = UPConfigUtils.getChunks((String)"1234567", (int)3);
        this.assertListContent(ret, "123", "456", "7");
        ret = UPConfigUtils.getChunks((String)"12345678", (int)3);
        this.assertListContent(ret, "123", "456", "78");
        ret = UPConfigUtils.getChunks((String)"123456789", (int)3);
        this.assertListContent(ret, "123", "456", "789");
    }

    private void assertListContent(List<String> actual, String ... expectedParts) {
        int i = 0;
        Assert.assertEquals((long)expectedParts.length, (long)actual.size());
        for (String ep : expectedParts) {
            Assert.assertEquals((Object)ep, (Object)actual.get(i++));
        }
    }

    @Test
    public void capitalizeFirstLetter() {
        Assert.assertNull((Object)UPConfigUtils.capitalizeFirstLetter(null));
        Assert.assertEquals((Object)"", (Object)UPConfigUtils.capitalizeFirstLetter((String)""));
        Assert.assertEquals((Object)"A", (Object)UPConfigUtils.capitalizeFirstLetter((String)"a"));
        Assert.assertEquals((Object)"AbcDefGh", (Object)UPConfigUtils.capitalizeFirstLetter((String)"abcDefGh"));
    }
}

