/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.user.profile.config;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPAttributePermissions;
import org.keycloak.userprofile.config.UPAttributeRequired;
import org.keycloak.userprofile.config.UPConfig;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.userprofile.config.UPGroup;

public class UPConfigParserTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setClientScopes(new ArrayList());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("phone-1-sel").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("phone-1").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("phone-2-sel").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("phone-2").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("phone-3-sel").build());
    }

    @Test
    public void attributeNameIsValid() {
        Assert.assertFalse((boolean)UPConfigUtils.isValidAttributeName((String)""));
        Assert.assertFalse((boolean)UPConfigUtils.isValidAttributeName((String)" "));
        Assert.assertFalse((boolean)UPConfigUtils.isValidAttributeName((String)"a b"));
        Assert.assertFalse((boolean)UPConfigUtils.isValidAttributeName((String)"a*b"));
        Assert.assertFalse((boolean)UPConfigUtils.isValidAttributeName((String)"a%b"));
        Assert.assertFalse((boolean)UPConfigUtils.isValidAttributeName((String)"a$b"));
        Assert.assertTrue((boolean)UPConfigUtils.isValidAttributeName((String)"a-b"));
        Assert.assertTrue((boolean)UPConfigUtils.isValidAttributeName((String)"a.b"));
        Assert.assertTrue((boolean)UPConfigUtils.isValidAttributeName((String)"a_b"));
        Assert.assertTrue((boolean)UPConfigUtils.isValidAttributeName((String)"a3B"));
    }

    @Test
    public void loadConfigurationFromJsonFile() throws IOException {
        UPConfig config = UPConfigUtils.readConfig((InputStream)UPConfigParserTest.getValidConfigFileIS());
        Assert.assertEquals((long)5L, (long)config.getAttributes().size());
    }

    @Test
    public void parseConfigurationFile_OK() throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)5L, (long)config.getAttributes().size());
        UPAttribute att = (UPAttribute)config.getAttributes().get(1);
        Assert.assertNotNull((Object)att);
        Assert.assertEquals((Object)"email", (Object)att.getName());
        Assert.assertEquals((long)3L, (long)att.getValidations().size());
        Assert.assertEquals((long)1L, (long)((Map)att.getValidations().get("length")).size());
        Assert.assertEquals((Object)255, ((Map)att.getValidations().get("length")).get("max"));
        Assert.assertEquals((Object)"userEmailFormFieldHint", att.getAnnotations().get("formHintKey"));
        att = (UPAttribute)config.getAttributes().get(4);
        Assert.assertNotNull((Object)att.getRequired());
        Assert.assertFalse((boolean)att.getRequired().isAlways());
        Assert.assertNotNull((Object)att.getRequired().getScopes());
        Assert.assertNotNull((Object)att.getRequired().getRoles());
        Assert.assertEquals((long)2L, (long)att.getRequired().getRoles().size());
        att = (UPAttribute)config.getAttributes().get(3);
        Assert.assertTrue((boolean)att.getRequired().isAlways());
        Assert.assertNotNull((Object)att.getPermissions());
        Assert.assertNotNull((Object)att.getPermissions().getEdit());
        Assert.assertEquals((long)1L, (long)att.getPermissions().getEdit().size());
        Assert.assertTrue((boolean)att.getPermissions().getEdit().contains("admin"));
        Assert.assertNotNull((Object)att.getPermissions().getView());
        Assert.assertEquals((long)2L, (long)att.getPermissions().getView().size());
        Assert.assertTrue((boolean)att.getPermissions().getView().contains("admin"));
        Assert.assertTrue((boolean)att.getPermissions().getView().contains("user"));
        att = (UPAttribute)config.getAttributes().get(4);
        Assert.assertNotNull((Object)att.getSelector().getScopes());
        Assert.assertEquals((long)3L, (long)att.getSelector().getScopes().size());
        Assert.assertTrue((boolean)att.getSelector().getScopes().contains("phone-3-sel"));
        att = (UPAttribute)config.getAttributes().get(4);
        Assert.assertEquals((Object)"${profile.phone}", (Object)att.getDisplayName());
        Assert.assertEquals((Object)"contact", (Object)att.getGroup());
        Assert.assertEquals((long)1L, (long)config.getGroups().size());
        UPGroup group = (UPGroup)config.getGroups().get(0);
        Assert.assertEquals((Object)"contact", (Object)group.getName());
        Assert.assertEquals((Object)"Contact information", (Object)group.getDisplayHeader());
        Assert.assertEquals((Object)"Required to contact you in case of emergency", (Object)group.getDisplayDescription());
        Assert.assertEquals((long)1L, (long)group.getAnnotations().size());
        Assert.assertEquals((Object)"value1", group.getAnnotations().get("contactanno1"));
    }

    private static UPConfig loadValidConfig() throws IOException {
        return UPConfigUtils.readConfig((InputStream)UPConfigParserTest.getValidConfigFileIS());
    }

    private static InputStream getValidConfigFileIS() {
        return UPConfigParserTest.class.getResourceAsStream("test-OK.json");
    }

    @Test(expected=JsonMappingException.class)
    public void parseConfigurationFile_invalidJsonFormat() throws IOException {
        UPConfigUtils.readConfig((InputStream)this.getClass().getResourceAsStream("test-invalidJsonFormat.json"));
    }

    @Test(expected=IOException.class)
    public void parseConfigurationFile_invalidType() throws IOException {
        UPConfigUtils.readConfig((InputStream)this.getClass().getResourceAsStream("test-invalidType.json"));
    }

    @Test(expected=IOException.class)
    public void parseConfigurationFile_unknownField() throws IOException {
        UPConfigUtils.readConfig((InputStream)this.getClass().getResourceAsStream("test-unknownField.json"));
    }

    @Test
    public void validateConfiguration_OK() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_OK);
    }

    public static void validateConfiguration_OK(KeycloakSession session) throws IOException {
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)UPConfigParserTest.loadValidConfig());
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void validateConfiguration_attributeNameErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributeNameErrors);
    }

    public static void validateConfiguration_attributeNameErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        UPAttribute attConfig = (UPAttribute)config.getAttributes().get(1);
        attConfig.setName(null);
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        attConfig.setName(" ");
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        attConfig.setName("firstName");
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        attConfig.setName("ema il");
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void validateConfiguration_attributePermissionsErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributePermissionsErrors);
    }

    public static void validateConfiguration_attributePermissionsErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        UPAttribute attConfig = (UPAttribute)config.getAttributes().get(1);
        attConfig.setPermissions(null);
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)0L, (long)errors.size());
        UPAttributePermissions permsConfig = new UPAttributePermissions();
        attConfig.setPermissions(permsConfig);
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertTrue((boolean)errors.isEmpty());
        permsConfig.setEdit(Collections.emptySet());
        permsConfig.setView(Collections.emptySet());
        attConfig.setPermissions(permsConfig);
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)0L, (long)errors.size());
        Set<String> withInvRole = Collections.singleton("invalid");
        permsConfig.setView(withInvRole);
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        permsConfig.setEdit(withInvRole);
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)2L, (long)errors.size());
    }

    @Test
    public void validateConfiguration_attributeRequirementsErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributeRequirementsErrors);
    }

    public static void validateConfiguration_attributeRequirementsErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        UPAttribute attConfig = (UPAttribute)config.getAttributes().get(1);
        attConfig.setRequired(null);
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)0L, (long)errors.size());
        UPAttributeRequired reqConfig = new UPAttributeRequired();
        attConfig.setRequired(reqConfig);
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)0L, (long)errors.size());
        Assert.assertTrue((boolean)reqConfig.isAlways());
        reqConfig.setRoles(Collections.singleton("invalid"));
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertFalse((boolean)reqConfig.isAlways());
    }

    @Test
    public void validateConfiguration_attributeValidationsErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributeValidationsErrors);
    }

    private static void validateConfiguration_attributeValidationsErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        for (UPAttribute att : config.getAttributes()) {
            att.setValidations(null);
        }
        HashMap validationConfig = new HashMap();
        ((UPAttribute)config.getAttributes().get(1)).setValidations(validationConfig);
        validationConfig.put(" ", null);
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        validationConfig.clear();
        HashMap<String, String> vc = new HashMap<String, String>();
        vc.put("min", "aaa");
        validationConfig.put("length", vc);
        errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void validateConfiguration_attributeGroupConfigurationErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributeGroupConfigurationErrors);
    }

    private static void validateConfiguration_attributeGroupConfigurationErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        UPGroup groupWithoutName = new UPGroup();
        config.addGroup(groupWithoutName);
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)"Name is mandatory for groups, found 1 group(s) without name.", errors.get(0));
    }

    @Test
    public void validateConfiguration_attributeGroupReferenceErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributeGroupReferenceErrors);
    }

    private static void validateConfiguration_attributeGroupReferenceErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        UPAttribute firstAttribute = (UPAttribute)config.getAttributes().get(0);
        firstAttribute.setGroup("non-existing-group");
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)"Attribute 'username' references unknown group 'non-existing-group'", errors.get(0));
    }

    @Test
    public void validateConfiguration_attributeAnnotationsErrors() {
        this.getTestingClient().server("test").run(UPConfigParserTest::validateConfiguration_attributeAnnotationsErrors);
    }

    private static void validateConfiguration_attributeAnnotationsErrors(KeycloakSession session) throws IOException {
        UPConfig config = UPConfigParserTest.loadValidConfig();
        UPAttribute att = (UPAttribute)config.getAttributes().get(1);
        att.getAnnotations().put("inputOptions", "");
        att.getAnnotations().put("inputOptionLabels", "");
        List errors = UPConfigUtils.validate((KeycloakSession)session, (UPConfig)config);
        Assert.assertEquals((long)2L, (long)errors.size());
    }
}

