/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.url;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.UriUtils;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.url.AbstractHostnameTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class DefaultHostnameTest
extends AbstractHostnameTest {
    @ArquillianResource
    protected ContainerController controller;
    private String expectedBackendUrl;
    private String globalFrontEndUrl = "https://keycloak.127.0.0.1.nip.io/custom";
    private String realmFrontEndUrl = "https://my-realm.127.0.0.1.nip.io";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation test = RealmBuilder.create().name("test").client(ClientBuilder.create().name("direct-grant").clientId("direct-grant").enabled(true).secret("password").directAccessGrants()).user(UserBuilder.create().username("test-user@localhost").password("password")).build();
        testRealms.add(test);
        RealmRepresentation customHostname = RealmBuilder.create().name("frontendUrl").client(ClientBuilder.create().name("direct-grant").clientId("direct-grant").enabled(true).secret("password").directAccessGrants()).user(UserBuilder.create().username("test-user@localhost").password("password")).attribute("frontendUrl", this.realmFrontEndUrl).build();
        testRealms.add(customHostname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fixedFrontendUrl() throws Exception {
        this.expectedBackendUrl = this.transformUrlIfQuarkusServer(OAuthClient.AUTH_SERVER_ROOT);
        this.oauth.clientId("direct-grant");
        try (Keycloak testAdminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)ServerURLs.getAuthServerContextRoot());){
            this.assertWellKnown("test", this.expectedBackendUrl);
            this.configureDefault(this.globalFrontEndUrl, false, null);
            this.assertWellKnown("test", this.globalFrontEndUrl);
            this.assertTokenIssuer("test", this.globalFrontEndUrl);
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "test", this.globalFrontEndUrl);
            this.assertBackendForcedToFrontendWithMatchingHostname("test", this.globalFrontEndUrl);
            this.assertAdminPage("master", this.globalFrontEndUrl, this.transformUrlIfQuarkusServer(this.globalFrontEndUrl, true));
            this.assertWellKnown("frontendUrl", this.realmFrontEndUrl);
            this.assertTokenIssuer("frontendUrl", this.realmFrontEndUrl);
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "frontendUrl", this.realmFrontEndUrl);
            this.assertBackendForcedToFrontendWithMatchingHostname("frontendUrl", this.realmFrontEndUrl);
            this.assertAdminPage("frontendUrl", this.realmFrontEndUrl, this.transformUrlIfQuarkusServer(this.realmFrontEndUrl, true));
        }
        finally {
            this.reset();
        }
    }

    @Test
    public void emptyRealmFrontendUrl() throws Exception {
        this.expectedBackendUrl = this.transformUrlIfQuarkusServer(OAuthClient.AUTH_SERVER_ROOT);
        this.oauth.clientId("direct-grant");
        RealmResource realmResource = this.realmsResouce().realm("frontendUrl");
        RealmRepresentation rep = realmResource.toRepresentation();
        try {
            rep.getAttributes().put("frontendUrl", "");
            realmResource.update(rep);
            this.assertWellKnown("frontendUrl", this.transformUrlIfQuarkusServer(OAuthClient.AUTH_SERVER_ROOT));
        }
        finally {
            rep.getAttributes().put("frontendUrl", this.realmFrontEndUrl);
            realmResource.update(rep);
            this.reset();
        }
    }

    @Test
    public void fixedAdminUrl() throws Exception {
        this.expectedBackendUrl = this.transformUrlIfQuarkusServer(OAuthClient.AUTH_SERVER_ROOT);
        String adminUrl = this.transformUrlIfQuarkusServer("https://admin.127.0.0.1.nip.io/custom-admin", true);
        this.oauth.clientId("direct-grant");
        try {
            this.assertWellKnown("test", this.expectedBackendUrl);
            this.configureDefault(this.globalFrontEndUrl, false, adminUrl);
            this.assertWelcomePage(adminUrl);
            this.assertAdminPage("master", this.globalFrontEndUrl, adminUrl);
            this.assertAdminPage("frontendUrl", this.realmFrontEndUrl, adminUrl);
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forceBackendUrlToFrontendUrl() throws Exception {
        this.expectedBackendUrl = this.transformUrlIfQuarkusServer(OAuthClient.AUTH_SERVER_ROOT);
        this.oauth.clientId("direct-grant");
        try (Keycloak testAdminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)ServerURLs.getAuthServerContextRoot());){
            this.assertWellKnown("test", this.expectedBackendUrl);
            this.configureDefault(this.globalFrontEndUrl, true, null);
            this.expectedBackendUrl = this.globalFrontEndUrl;
            this.assertWellKnown("test", this.globalFrontEndUrl);
            this.assertTokenIssuer("test", this.globalFrontEndUrl);
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "test", this.globalFrontEndUrl);
            this.expectedBackendUrl = this.realmFrontEndUrl;
            this.assertWellKnown("frontendUrl", this.realmFrontEndUrl);
            this.assertTokenIssuer("frontendUrl", this.realmFrontEndUrl);
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "frontendUrl", this.realmFrontEndUrl);
        }
        finally {
            this.reset();
        }
    }

    private void assertInitialAccessTokenFromMasterRealm(Keycloak testAdminClient, String realm, String expectedBaseUrl) throws JWSInputException, ClientRegistrationException {
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(1));
        rep.setExpiration(Integer.valueOf(10000));
        ClientInitialAccessPresentation initialAccess = testAdminClient.realm(realm).clientInitialAccess().create(rep);
        JsonWebToken token = (JsonWebToken)new JWSInput(initialAccess.getToken()).readJsonContent(JsonWebToken.class);
        Assert.assertEquals((Object)(expectedBaseUrl + "/realms/" + realm), (Object)token.getIssuer());
        ClientRegistration clientReg = ClientRegistration.create().url(OAuthClient.AUTH_SERVER_ROOT, realm).build();
        clientReg.auth(Auth.token((String)initialAccess.getToken()));
        ClientRepresentation client = new ClientRepresentation();
        client.setEnabled(Boolean.valueOf(true));
        ClientRepresentation response = clientReg.create(client);
        String registrationAccessToken = response.getRegistrationAccessToken();
        JsonWebToken registrationToken = (JsonWebToken)new JWSInput(registrationAccessToken).readJsonContent(JsonWebToken.class);
        Assert.assertEquals((Object)(expectedBaseUrl + "/realms/" + realm), (Object)registrationToken.getIssuer());
    }

    private void assertTokenIssuer(String realm, String expectedBaseUrl) throws Exception {
        this.oauth.realm(realm);
        this.oauth.requestHeaders(this.createRequestHeaders(expectedBaseUrl));
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        AccessToken token = (AccessToken)new JWSInput(tokenResponse.getAccessToken()).readJsonContent(AccessToken.class);
        Assert.assertEquals((Object)(expectedBaseUrl + "/realms/" + realm), (Object)token.getIssuer());
        String introspection = this.oauth.introspectAccessTokenWithClientCredential(this.oauth.getClientId(), "password", tokenResponse.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode introspectionNode = objectMapper.readTree(introspection);
        Assert.assertTrue((boolean)introspectionNode.get("active").asBoolean());
        Assert.assertEquals((Object)(expectedBaseUrl + "/realms/" + realm), (Object)introspectionNode.get("iss").asText());
    }

    private void assertWellKnown(String realm, String expectedFrontendUrl) {
        OIDCConfigurationRepresentation config = this.oauth.requestHeaders(this.createRequestHeaders(expectedFrontendUrl)).doWellKnownRequest(realm);
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm), (Object)config.getIssuer());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/auth"), (Object)config.getAuthorizationEndpoint());
        Assert.assertEquals((Object)(this.expectedBackendUrl + "/realms/" + realm + "/protocol/openid-connect/token"), (Object)config.getTokenEndpoint());
        Assert.assertEquals((Object)(this.expectedBackendUrl + "/realms/" + realm + "/protocol/openid-connect/userinfo"), (Object)config.getUserinfoEndpoint());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/logout"), (Object)config.getLogoutEndpoint());
        Assert.assertEquals((Object)(this.expectedBackendUrl + "/realms/" + realm + "/protocol/openid-connect/certs"), (Object)config.getJwksUri());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/login-status-iframe.html"), (Object)config.getCheckSessionIframe());
        Assert.assertEquals((Object)(this.expectedBackendUrl + "/realms/" + realm + "/clients-registrations/openid-connect"), (Object)config.getRegistrationEndpoint());
    }

    private Map<String, String> createRequestHeaders(String expectedFrontendUrl) {
        HashMap<String, String> headers = new HashMap<String, String>();
        URI uri = URI.create(expectedFrontendUrl);
        headers.put("X-Forwarded-Port", String.valueOf(uri.getPort()));
        return headers;
    }

    private void assertBackendForcedToFrontendWithMatchingHostname(String realm, String expectedFrontendUrl) throws URISyntaxException {
        String host = new URI(expectedFrontendUrl).getHost();
        this.oauth.baseUrl("http://" + host + ":" + System.getProperty("auth.server.http.port") + "/auth");
        OIDCConfigurationRepresentation config = this.oauth.requestHeaders(this.createRequestHeaders(expectedFrontendUrl)).doWellKnownRequest(realm);
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm), (Object)config.getIssuer());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/auth"), (Object)config.getAuthorizationEndpoint());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/token"), (Object)config.getTokenEndpoint());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/userinfo"), (Object)config.getUserinfoEndpoint());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/logout"), (Object)config.getLogoutEndpoint());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/certs"), (Object)config.getJwksUri());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/protocol/openid-connect/login-status-iframe.html"), (Object)config.getCheckSessionIframe());
        Assert.assertEquals((Object)(expectedFrontendUrl + "/realms/" + realm + "/clients-registrations/openid-connect"), (Object)config.getRegistrationEndpoint());
        this.oauth.baseUrl(OAuthClient.AUTH_SERVER_ROOT);
    }

    private void assertWelcomePage(String expectedAdminUrl) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            SimpleHttp get = SimpleHttp.doGet((String)(OAuthClient.AUTH_SERVER_ROOT + "/"), (HttpClient)client);
            for (Map.Entry<String, String> entry : this.createRequestHeaders(expectedAdminUrl).entrySet()) {
                get.header(entry.getKey(), entry.getValue());
            }
            String welcomePage = get.asString();
            Assert.assertTrue((boolean)welcomePage.contains("<a href=\"" + expectedAdminUrl + "/admin/\">"));
        }
    }

    private void assertAdminPage(String realm, String expectedFrontendUrl, String expectedAdminUrl) throws IOException, URISyntaxException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            SimpleHttp get = SimpleHttp.doGet((String)(OAuthClient.AUTH_SERVER_ROOT + "/admin/" + realm + "/console/"), (HttpClient)client);
            for (Map.Entry<String, String> entry : this.createRequestHeaders(expectedAdminUrl).entrySet()) {
                get.header(entry.getKey(), entry.getValue());
            }
            SimpleHttp.Response response = get.asResponse();
            String indexPage = response.asString();
            Assert.assertTrue((boolean)indexPage.contains("authServerUrl = '" + expectedFrontendUrl + "'"));
            Assert.assertTrue((boolean)indexPage.contains("authUrl = '" + expectedAdminUrl + "'"));
            Assert.assertTrue((boolean)indexPage.contains("consoleBaseUrl = '" + new URI(expectedAdminUrl).getPath() + "/admin/" + realm + "/console/'"));
            Assert.assertTrue((boolean)indexPage.contains("resourceUrl = '" + new URI(expectedAdminUrl).getPath() + "/resources/"));
            String cspHeader = response.getFirstHeader(BrowserSecurityHeaders.CONTENT_SECURITY_POLICY.getHeaderName());
            if (expectedFrontendUrl.equalsIgnoreCase(expectedAdminUrl)) {
                Assert.assertEquals((Object)"frame-src 'self'; frame-ancestors 'self'; object-src 'none';", (Object)cspHeader);
            } else {
                Assert.assertEquals((Object)("frame-src " + UriUtils.getOrigin((String)expectedFrontendUrl) + "; frame-ancestors 'self'; object-src 'none';"), (Object)cspHeader);
            }
        }
    }

    public String transformUrlIfQuarkusServer(String expectedUrl) {
        return this.transformUrlIfQuarkusServer(expectedUrl, false);
    }

    public String transformUrlIfQuarkusServer(String expectedUrl, boolean adminUrl) {
        if (this.suiteContext.getAuthServerInfo().isQuarkus()) {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)expectedUrl).port(-1);
            if (adminUrl) {
                uriBuilder.replacePath("/auth");
            }
            return uriBuilder.build(new Object[0]).toString();
        }
        return expectedUrl;
    }
}

