/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.theme;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.Version;
import org.keycloak.platform.Platform;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.theme.Theme;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ThemeResourceProviderTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void getTheme() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme("base", Theme.Type.LOGIN);
                Assert.assertNotNull((Object)theme.getTemplate("test.ftl"));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void getResourceAsStream() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme("base", Theme.Type.LOGIN);
                Assert.assertNotNull((Object)theme.getResourceAsStream("test.js"));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void getMessages() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme("base", Theme.Type.LOGIN);
                Assert.assertNotNull((Object)theme.getMessages("messages", Locale.ENGLISH).get("test.keycloak-8818"));
                Assert.assertNotEquals((Object)"Full name (Theme-resources)", (Object)theme.getMessages("messages", Locale.ENGLISH).get("fullName"));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void getResourceIllegalTraversal() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme("base", Theme.Type.LOGIN);
                Assert.assertNull((Object)theme.getResourceAsStream("../templates/test.ftl"));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void gzipEncoding() throws IOException {
        String resourcesVersion = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> Version.RESOURCES_VERSION, String.class);
        boolean filesNotExistsInTmp = (Boolean)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            File file2;
            boolean deleted = true;
            File file1 = Paths.get(System.getProperty("java.io.tmpdir"), "kc-gzip-cache", resourcesVersion, "welcome", "keycloak", "css", "welcome.css.gz").toFile();
            if (file1.isFile()) {
                deleted = file1.delete();
            }
            if ((file2 = Paths.get(System.getProperty("java.io.tmpdir"), "kc-gzip-cache", resourcesVersion, "js", "keycloak.js.gz").toFile()).isFile()) {
                deleted = deleted && file2.delete();
            }
            return deleted;
        }, Boolean.class);
        this.assertEncoded(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/resources/" + resourcesVersion + "/welcome/keycloak/css/welcome.css", "body {");
        this.assertEncoded(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/js/keycloak.js", "function(root, factory)");
        if (filesNotExistsInTmp) {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                Assert.assertFalse((boolean)Paths.get(System.getProperty("java.io.tmpdir"), "kc-gzip-cache", resourcesVersion, "welcome", "keycloak", "css", "welcome.css.gz").toFile().isFile());
                Assert.assertFalse((boolean)Paths.get(System.getProperty("java.io.tmpdir"), "kc-gzip-cache", resourcesVersion, "js", "keycloak.js.gz").toFile().isFile());
            });
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            String serverTmpDir = Platform.getPlatform().getTmpDirectory().toString();
            Assert.assertTrue((boolean)Paths.get(serverTmpDir, "kc-gzip-cache", resourcesVersion, "welcome", "keycloak", "css", "welcome.css.gz").toFile().isFile());
            Assert.assertTrue((boolean)Paths.get(serverTmpDir, "kc-gzip-cache", resourcesVersion, "js", "keycloak.js.gz").toFile().isFile());
        });
    }

    private void assertEncoded(String url, String expectedContent) throws IOException {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().disableContentCompression().build();){
            HttpGet get = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            InputStream is = response.getEntity().getContent();
            Assert.assertNull((Object)response.getFirstHeader("Content-Encoding"));
            String plain = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            response.close();
            get = new HttpGet(url);
            get.addHeader("Accept-Encoding", "gzip");
            response = httpClient.execute((HttpUriRequest)get);
            is = response.getEntity().getContent();
            Assert.assertEquals((Object)"gzip", (Object)response.getFirstHeader("Content-Encoding").getValue());
            String gzip = IOUtils.toString((InputStream)new GZIPInputStream(is), (Charset)StandardCharsets.UTF_8);
            response.close();
            Assert.assertEquals((Object)plain, (Object)gzip);
            Assert.assertTrue((boolean)plain.contains(expectedContent));
        }
    }

    @Test
    public void getMessagesLocaleResolving() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme("base", Theme.Type.LOGIN);
                Assert.assertEquals((Object)"Test en_US_variant", (Object)theme.getMessages("messages", new Locale("en", "US", "variant")).get("test.keycloak-12926"));
                Assert.assertEquals((Object)"Test en_US", (Object)theme.getMessages("messages", new Locale("en", "US")).get("test.keycloak-12926"));
                Assert.assertEquals((Object)"Test en", (Object)theme.getMessages("messages", Locale.ENGLISH).get("test.keycloak-12926"));
                Assert.assertEquals((Object)"Test en_US", (Object)theme.getMessages("messages", new Locale("en", "US")).get("test.keycloak-12926"));
                Assert.assertEquals((Object)"Test en", (Object)theme.getMessages("messages", Locale.ENGLISH).get("test.keycloak-12926"));
                Assert.assertEquals((Object)"only de_AT_variant", (Object)theme.getMessages("messages", new Locale("de", "AT", "variant")).get("test.keycloak-12926-resolving1"));
                Assert.assertNull((Object)theme.getMessages("messages", new Locale("de", "AT")).get("test.keycloak-12926-resolving1"));
                Assert.assertEquals((Object)"only de_AT", (Object)theme.getMessages("messages", new Locale("de", "AT", "variant")).get("test.keycloak-12926-resolving2"));
                Assert.assertNull((Object)theme.getMessages("messages", new Locale("de")).get("test.keycloak-12926-resolving2"));
                Assert.assertEquals((Object)"only de", (Object)theme.getMessages("messages", new Locale("de", "AT", "variant")).get("test.keycloak-12926-only_de"));
                Assert.assertNull((Object)theme.getMessages("messages", Locale.ENGLISH).get("test.keycloak-12926-only_de"));
                Assert.assertEquals((Object)"fallback en", (Object)theme.getMessages("messages", new Locale("de", "AT", "variant")).get("test.keycloak-12926-resolving3"));
                Assert.assertEquals((Object)"fallback en", (Object)theme.getMessages("messages", new Locale("de", "AT")).get("test.keycloak-12926-resolving3"));
                Assert.assertEquals((Object)"fallback en", (Object)theme.getMessages("messages", new Locale("de")).get("test.keycloak-12926-resolving3"));
                Assert.assertNull((Object)theme.getMessages("messages", Locale.ENGLISH).get("fallback en"));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }
}

