/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.theme;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.theme.Theme;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class DefaultThemeManagerTest
extends AbstractKeycloakTest {
    private static final String THEME_NAME = "environment-agnostic";

    @Before
    public void setUp() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            System.setProperty("existing_system_property", "Keycloak is awesome");
            session.theme().clearCache();
        });
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Test
    public void systemPropertiesSubstitutionInThemeProperties() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme(THEME_NAME, Theme.Type.LOGIN);
                Assert.assertEquals((String)"getTheme(...) returns default theme when no matching theme found, but we need environment-agnostic theme deployed.", (Object)THEME_NAME, (Object)theme.getName());
                Assert.assertEquals((Object)"Keycloak is awesome", (Object)theme.getProperties().getProperty("system.property.found"));
                Assert.assertEquals((Object)"${missing_system_property}", (Object)theme.getProperties().getProperty("system.property.missing"));
                Assert.assertEquals((Object)"defaultValue", (Object)theme.getProperties().getProperty("system.property.missing.with.default"));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void environmentVariablesSubstitutionInThemeProperties() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            try {
                Theme theme = session.theme().getTheme(THEME_NAME, Theme.Type.LOGIN);
                Assert.assertEquals((String)"getTheme(...) returns default theme when no matching theme found, but we need environment-agnostic theme deployed.", (Object)THEME_NAME, (Object)theme.getName());
                Assert.assertEquals((Object)"${env.MISSING_ENVIRONMENT_VARIABLE}", (Object)theme.getProperties().getProperty("env.missing"));
                Assert.assertEquals((Object)"defaultValue", (Object)theme.getProperties().getProperty("env.missingWithDefault"));
                if (System.getenv().containsKey("HOMEPATH")) {
                    Assert.assertEquals((Object)System.getenv().get("HOMEPATH"), (Object)theme.getProperties().getProperty("env.windowsHome"));
                } else if (System.getenv().containsKey("HOME")) {
                    Assert.assertEquals((Object)System.getenv().get("HOME"), (Object)theme.getProperties().getProperty("env.unixHome"));
                } else {
                    Assert.fail((String)"No default env variable found, can't verify");
                }
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }
}

