/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.ssl;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.account.AccountManagement;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.VerifyEmail;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.MailAssert;
import org.keycloak.testsuite.util.SslMailServer;
import org.keycloak.testsuite.util.URLAssert;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class TrustStoreEmailTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected OIDCLogin testRealmLoginPage;
    @Page
    protected AuthRealm testRealmPage;
    @Page
    protected AccountManagement accountManagement;
    @Page
    private VerifyEmail testRealmVerifyEmailPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        this.log.info((Object)"enable verify email and configure smtp server to run with ssl in test realm");
        testRealm.setSmtpServer(SslMailServer.getServerConfiguration());
        testRealm.setVerifyEmail(Boolean.valueOf(true));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
        this.testRealmVerifyEmailPage.setAuthRealm(this.testRealmPage);
        this.accountManagement.setAuthRealm(this.testRealmPage);
        this.testRealmLoginPage.setAuthRealm(this.testRealmPage);
    }

    @After
    public void afterTrustStoreEmailTest() {
        SslMailServer.stop();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void verifyEmailWithSslEnabled() {
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        SslMailServer.startWithSsl(this.getClass().getClassLoader().getResource("keystore/keycloak.jks").getFile());
        this.accountManagement.navigateTo();
        this.testRealmLoginPage.form().login(user.getUsername(), "password");
        EventRepresentation sendEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).user(user.getId()).client("account").detail("username", "test-user@localhost").detail("email", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        org.junit.Assert.assertEquals((Object)"You need to verify your email address to activate your account.", (Object)this.testRealmVerifyEmailPage.feedbackMessage().getText());
        String verifyEmailUrl = MailAssert.assertEmailAndGetUrl("server@mail.test", user.getEmail(), "Someone has created a Test account with this email address.", true);
        this.log.info((Object)("navigating to url from email: " + verifyEmailUrl));
        this.driver.navigate().to(verifyEmailUrl);
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(user.getId()).client("account").detail("username", "test-user@localhost").detail("email", "test-user@localhost").detail("code_id", mailCodeId).removeDetail("redirect_uri").assertEvent();
        this.events.expectLogin().client("account").user(user.getId()).session(mailCodeId).detail("username", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.accountManagement);
        this.accountManagement.signOut();
        this.testRealmLoginPage.form().login(user.getUsername(), "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.accountManagement);
    }

    @Test
    public void verifyEmailWithSslWrongCertificate() throws Exception {
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        SslMailServer.startWithSsl(this.getClass().getClassLoader().getResource("keystore/email_invalid.jks").getFile());
        this.accountManagement.navigateTo();
        this.loginPage.form().login(user.getUsername(), "password");
        this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL_ERROR).error("email_send_failed").user(user.getId()).client("account").detail("username", "test-user@localhost").detail("email", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
        Assert.assertNull((Object)SslMailServer.getLastReceivedMessage());
        org.junit.Assert.assertEquals((Object)"You need to verify your email address to activate your account.", (Object)this.testRealmVerifyEmailPage.feedbackMessage().getText());
    }

    @Test
    public void verifyEmailWithSslWrongHostname() throws Exception {
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        realmRep.getSmtpServer().put("host", "localhost.localdomain");
        this.testRealm().update(realmRep);
        try {
            SslMailServer.startWithSsl(this.getClass().getClassLoader().getResource("keystore/keycloak.jks").getFile());
            this.accountManagement.navigateTo();
            this.loginPage.form().login(user.getUsername(), "password");
            this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL_ERROR).error("email_send_failed").user(user.getId()).client("account").detail("username", "test-user@localhost").detail("email", "test-user@localhost").removeDetail("redirect_uri").assertEvent();
            Assert.assertNull((Object)SslMailServer.getLastReceivedMessage());
            org.junit.Assert.assertEquals((Object)"You need to verify your email address to activate your account.", (Object)this.testRealmVerifyEmailPage.feedbackMessage().getText());
        }
        finally {
            realmRep.getSmtpServer().put("host", "localhost");
            this.testRealm().update(realmRep);
        }
    }
}

