/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.script;

import java.io.IOException;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.util.JsonSerialization;

public class DeployedScriptMapperTest
extends AbstractTestRealmKeycloakTest {
    private static final String SCRIPT_DEPLOYMENT_NAME = "scripts.jar";
    @ArquillianResource
    private Deployer deployer;

    @Deployment(name="scripts.jar", managed=false, testable=false)
    @TargetsContainer(value="auth-server-current")
    public static JavaArchive deploy() throws IOException {
        ScriptProviderDescriptor representation = new ScriptProviderDescriptor();
        representation.addMapper("My Mapper", "mapper-a.js");
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)SCRIPT_DEPLOYMENT_NAME)).addAsManifestResource((Asset)new StringAsset(JsonSerialization.writeValueAsPrettyString((Object)representation)), "keycloak-scripts.json")).addAsResource("scripts/mapper-example.js", "mapper-a.js");
    }

    @BeforeClass
    public static void verifyEnvironment() {
        ContainerAssume.assumeNotAuthServerUndertow();
    }

    @Before
    public void configureFlows() throws Exception {
        this.deployer.deploy(SCRIPT_DEPLOYMENT_NAME);
        this.reconnectAdminClient();
    }

    @After
    public void onAfter() throws Exception {
        this.deployer.undeploy(SCRIPT_DEPLOYMENT_NAME);
        this.reconnectAdminClient();
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testScriptMapperNotAvailable() {
        Assert.assertFalse((boolean)((List)this.adminClient.serverInfo().getInfo().getProtocolMapperTypes().get("openid-connect")).stream().anyMatch(mapper -> "oidc-script-based-protocol-mapper".equals(mapper.getId())));
    }

    @Test
    @EnableFeature(value=Profile.Feature.SCRIPTS, skipRestart=true, executeAsLast=false)
    public void testTokenScriptMapping() {
        ClientResource app = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ProtocolMapperRepresentation mapper = ProtocolMapperUtil.createScriptMapper("test-script-mapper1", "computed-via-script", "computed-via-script", "String", true, true, "'hello_' + user.username", false);
        mapper.setProtocolMapper("script-mapper-a.js");
        app.getProtocolMappers().createMapper(mapper).close();
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)"hello_test-user@localhost", accessToken.getOtherClaims().get("computed-via-script"));
    }

    private OAuthClient.AccessTokenResponse browserLogin(String clientSecret, String username, String password) {
        OAuthClient.AuthorizationEndpointResponse authzEndpointResponse = this.oauth.doLogin(username, password);
        return this.oauth.doAccessTokenRequest(authzEndpointResponse.getCode(), clientSecret);
    }
}

