/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.script;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.AbstractFlowTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.ExecutionBuilder;
import org.keycloak.testsuite.util.FlowBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

@EnableFeature(value=Profile.Feature.SCRIPTS, skipRestart=true)
public class DeployedScriptAuthenticatorTest
extends AbstractFlowTest {
    public static final String EXECUTION_ID = "scriptAuth";
    private static final String SCRIPT_DEPLOYMENT_NAME = "scripts.jar";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected LoginPage loginPage;
    @ArquillianResource
    private Deployer deployer;
    private AuthenticationFlowRepresentation flow;

    @Deployment(name="scripts.jar", managed=false, testable=false)
    @TargetsContainer(value="auth-server-current")
    public static JavaArchive deploy() throws IOException {
        ScriptProviderDescriptor representation = new ScriptProviderDescriptor();
        representation.addAuthenticator("My Authenticator", "authenticator-a.js");
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)SCRIPT_DEPLOYMENT_NAME)).addAsManifestResource((Asset)new StringAsset(JsonSerialization.writeValueAsPrettyString((Object)representation)), "keycloak-scripts.json")).addAsResource("scripts/authenticator-example.js", "authenticator-a.js");
    }

    @BeforeClass
    public static void verifyEnvironment() {
        ContainerAssume.assumeNotAuthServerUndertow();
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation failUser = UserBuilder.create().id("fail").username("fail").email("fail@test.com").enabled(true).password("password").build();
        UserRepresentation okayUser = UserBuilder.create().id("user").username("user").email("user@test.com").enabled(true).password("password").build();
        RealmBuilder.edit(testRealm).user(failUser).user(okayUser);
    }

    public void configureFlows() throws Exception {
        this.deployer.deploy(SCRIPT_DEPLOYMENT_NAME);
        this.reconnectAdminClient();
        if (this.testContext.isInitialized()) {
            return;
        }
        String scriptFlow = "scriptBrowser";
        AuthenticationFlowRepresentation scriptBrowserFlow = FlowBuilder.create().alias(scriptFlow).description("dummy pass through registration").providerId("basic-flow").topLevel(true).builtIn(false).build();
        Response createFlowResponse = this.adminClient.realm("test").flows().createFlow(scriptBrowserFlow);
        Assert.assertEquals((long)201L, (long)createFlowResponse.getStatus());
        RealmRepresentation realm = this.adminClient.realm("test").toRepresentation();
        realm.setBrowserFlow(scriptFlow);
        realm.setDirectGrantFlow(scriptFlow);
        this.testRealm().update(realm);
        this.flow = this.findFlowByAlias(scriptFlow);
        AuthenticationExecutionRepresentation usernamePasswordFormExecution = ExecutionBuilder.create().id("username password form").parentFlow(this.flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.name()).authenticator("auth-username-password-form").build();
        AuthenticationExecutionRepresentation authScriptExecution = ExecutionBuilder.create().id(EXECUTION_ID).parentFlow(this.flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.name()).authenticator("script-authenticator-a.js").build();
        Response addExecutionResponse = this.testRealm().flows().addExecution(usernamePasswordFormExecution);
        Assert.assertEquals((long)201L, (long)addExecutionResponse.getStatus());
        addExecutionResponse.close();
        addExecutionResponse = this.testRealm().flows().addExecution(authScriptExecution);
        Assert.assertEquals((long)201L, (long)addExecutionResponse.getStatus());
        addExecutionResponse.close();
        this.testContext.setInitialized(true);
    }

    @After
    public void onAfter() throws Exception {
        this.deployer.undeploy(SCRIPT_DEPLOYMENT_NAME);
        this.reconnectAdminClient();
    }

    @Test
    public void loginShouldWorkWithScriptAuthenticator() throws Exception {
        this.configureFlows();
        this.loginPage.open();
        this.loginPage.login("user", "password");
        this.events.expectLogin().user("user").detail("username", "user").assertEvent();
    }

    @Test
    public void loginShouldFailWithScriptAuthenticator() throws Exception {
        this.configureFlows();
        this.loginPage.open();
        this.loginPage.login("fail", "password");
        this.events.expect(EventType.LOGIN_ERROR).user((String)null).error("user_not_found").assertEvent();
    }

    @Test
    @DisableFeature(value=Profile.Feature.SCRIPTS, executeAsLast=false, skipRestart=true)
    public void testScriptAuthenticatorNotAvailable() {
        Assert.assertFalse((boolean)this.testRealm().flows().getAuthenticatorProviders().stream().anyMatch(provider -> "auth-script-based".equals(provider.get("id"))));
    }
}

