/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.LinkedList;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.Matchers;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class SamlXMLAttacksTest
extends AbstractSamlTest {
    private static final String REQUEST_VALID = "<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"a123\" Version=\"2.0\" IssueInstant=\"2014-07-16T23:52:45Z\" ><saml:Issuer>http://localhost:8280/sales-post/</saml:Issuer></samlp:AuthnRequest>";
    private static final String REQUEST_FLAWED = "<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"&sp;\" Version=\"2.0\" IssueInstant=\"2014-07-16T23:52:45Z\" ><saml:Issuer>http://localhost:8280/sales-post/</saml:Issuer></samlp:AuthnRequest>";
    private static final String REQUEST_FLAWED_LOCAL = "<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"&heh;\" Version=\"2.0\" IssueInstant=\"2014-07-16T23:52:45Z\" ><saml:Issuer>http://localhost:8280/sales-post/</saml:Issuer></samlp:AuthnRequest>";
    private static final String REQUEST_INVALID = "<samlp:InvalidAuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"a123\" Version=\"2.0\" IssueInstant=\"2014-07-16T23:52:45Z\" ><saml:Issuer>http://localhost:8280/sales-post/</saml:Issuer></samlp:AuthnRequest>";

    @Test
    public void testXMLBombAttackResistance() throws Exception {
        this.runTestWithTimeout(4000L, () -> {
            String bombDoctype = "<!DOCTYPE AuthnRequest [ <!ENTITY lol \"lol\"><!ELEMENT AuthnRequest (#PCDATA)><!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\"><!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\"><!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\"><!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\"><!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\"><!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\"><!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\"><!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\"><!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">]>";
            String samlAuthnRequest = "<samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"a123\" Version=\"2.0\" IssueInstant=\"2014-07-16T23:52:45Z\" ><saml:Issuer>http://localhost:8280/sales-post/&lol9;</saml:Issuer></samlp:AuthnRequest>";
            try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                UrlEncodedFormEntity formEntity;
                HttpPost post = new HttpPost(this.getAuthServerSamlEndpoint("demo"));
                LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
                String encoded = PostBindingUtil.base64Encode((String)(bombDoctype + samlAuthnRequest));
                parameters.add(new BasicNameValuePair("SAMLRequest", encoded));
                try {
                    formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                post.setEntity((HttpEntity)formEntity);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                    Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"Invalid Request")));
                }
            }
        });
    }

    @Deployment(name="DTD")
    protected static WebArchive employee() {
        String attackerDtd = "<!ENTITY % file SYSTEM \"file:///etc/passwd\">\n<!ENTITY % eval \"<!ENTITY &#x25; error SYSTEM 'file:///nonexistent/%file;'>\">\n%eval;\n%error;";
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"dtd.war")).add((Asset)new StringAsset(attackerDtd), "/attacker.dtd");
    }

    private void assertBlackboxInputValidation(String s, Matcher<? super CloseableHttpResponse> matcher) throws IOException, RuntimeException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getAuthServerSamlEndpoint("demo"));
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            String encoded = PostBindingUtil.base64Encode((String)s);
            parameters.add(new BasicNameValuePair("SAMLRequest", encoded));
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                Assert.assertThat((Object)response, matcher);
            }
        }
    }

    @Test
    public void testValidator(@ArquillianResource @OperateOnDeployment(value="DTD") URL attackerDtdUrl) throws Exception {
        String preamble = "<!DOCTYPE AuthnRequest [<!ELEMENT AuthnRequest (#PCDATA)><!ENTITY % sp SYSTEM \"" + attackerDtdUrl + "/attacker.dtd\" >%sp;<!ENTITY heh SYSTEM \"file:///etc/passwd\">" + "]>".replaceAll("//attacker", "/attacker");
        this.assertBlackboxInputValidation(REQUEST_VALID, (Matcher<? super CloseableHttpResponse>)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
        this.assertBlackboxInputValidation(REQUEST_INVALID, (Matcher<? super CloseableHttpResponse>)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"Invalid Request")));
        this.assertBlackboxInputValidation(preamble + REQUEST_VALID, (Matcher<? super CloseableHttpResponse>)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"Invalid Request")));
        this.assertBlackboxInputValidation(preamble + REQUEST_FLAWED, (Matcher<? super CloseableHttpResponse>)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"Invalid Request")));
        this.assertBlackboxInputValidation(preamble + REQUEST_FLAWED_LOCAL, (Matcher<? super CloseableHttpResponse>)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"Invalid Request")));
        this.assertBlackboxInputValidation(preamble + "<AuthnRequest></AuthnRequest>", (Matcher<? super CloseableHttpResponse>)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"Invalid Request")));
    }
}

