/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.saml.SAML2LoginResponseBuilder;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.IdentityProviderCreator;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateLogoutRequestStepBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

public class LogoutTest
extends AbstractSamlTest {
    private static final String SP_PROVIDED_ID = "spProvidedId";
    private static final String SP_NAME_QUALIFIER = "spNameQualifier";
    private static final String NAME_QUALIFIER = "nameQualifier";
    private static final String BROKER_SIGN_ON_SERVICE_URL = "https://saml.idp/saml";
    private static final String BROKER_LOGOUT_SERVICE_URL = "https://saml.idp/SLO/saml";
    private static final String BROKER_SERVICE_ID = "https://saml.idp/saml";
    private ClientRepresentation salesRep;
    private ClientRepresentation sales2Rep;

    @Before
    public void setup() {
        this.salesRep = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        this.sales2Rep = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post2/").get(0);
        this.adminClient.realm("demo").clients().get(this.salesRep.getId()).update(ClientBuilder.edit(this.salesRep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "http://url").build());
        this.nameIdRef.set(null);
        this.sessionIndexRef.set(null);
        this.adminClient.realm("demo").clearEvents();
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    private SamlClientBuilder logIntoUnsignedSalesAppViaIdp() throws IllegalArgumentException, UriBuilderException {
        return ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().idp("saml-broker").build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createAuthnResponse)).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).build().updateProfile().username("a").email("a@b.c").firstName("A").lastName("B").build().followOneRedirect().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build();
    }

    private SamlClientBuilder prepareLogIntoTwoApps() {
        return ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SAML_ASSERTION_CONSUMER_URL_SALES_POST2, SamlClient.Binding.POST).build().login().sso(true).build().processSamlResponse(SamlClient.Binding.POST).transformObject(so -> {
            Assert.assertThat((Object)so, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            return null;
        })).build();
    }

    @Test
    public void testLogoutDifferentBrowser() {
        this.adminClient.realm("demo").clients().get(this.sales2Rep.getId()).update(ClientBuilder.edit(this.sales2Rep).frontchannelLogout(false).attribute("saml_single_logout_service_url_post", "").removeAttribute("saml_single_logout_service_url_redirect").build());
        SAMLDocumentHolder samlResponse = this.prepareLogIntoTwoApps().clearCookies().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testFrontchannelLogoutInSameBrowser() {
        this.adminClient.realm("demo").clients().get(this.sales2Rep.getId()).update(ClientBuilder.edit(this.sales2Rep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "").build());
        SAMLDocumentHolder samlResponse = this.prepareLogIntoTwoApps().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        this.assertLogoutEvent("http://localhost:8280/sales-post/");
    }

    @Test
    public void testFrontchannelLogoutNoLogoutServiceUrlSetInSameBrowser() {
        this.adminClient.realm("demo").clients().get(this.sales2Rep.getId()).update(ClientBuilder.edit(this.sales2Rep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "").attribute("saml_single_logout_service_url_redirect", "").build());
        SAMLDocumentHolder samlResponse = this.prepareLogIntoTwoApps().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testFrontchannelLogoutDifferentBrowser() {
        this.adminClient.realm("demo").clients().get(this.sales2Rep.getId()).update(ClientBuilder.edit(this.sales2Rep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "").build());
        SAMLDocumentHolder samlResponse = this.prepareLogIntoTwoApps().clearCookies().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testFrontchannelLogoutWithRedirectUrlDifferentBrowser() {
        this.adminClient.realm("demo").clients().get(this.salesRep.getId()).update(ClientBuilder.edit(this.salesRep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "").attribute("saml_single_logout_service_url_redirect", "http://url").build());
        this.adminClient.realm("demo").clients().get(this.sales2Rep.getId()).update(ClientBuilder.edit(this.sales2Rep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "").attribute("saml_single_logout_service_url_redirect", "").build());
        SAMLDocumentHolder samlResponse = this.prepareLogIntoTwoApps().clearCookies().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().getSamlResponse(SamlClient.Binding.REDIRECT);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testLogoutWithPostBindingUnsetRedirectBindingSet() {
        this.adminClient.realm("demo").clients().get(this.sales2Rep.getId()).update(ClientBuilder.edit(this.sales2Rep).frontchannelLogout(true).attribute("saml_single_logout_service_url_post", "").attribute("saml_single_logout_service_url_redirect", "http://url-to-sales-2").build());
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)this.prepareLogIntoTwoApps().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().processSamlResponse(SamlClient.Binding.REDIRECT).transformDocument(doc -> {
            SAML2Object so = (SAML2Object)SAMLParser.getInstance().parse((Source)new DOMSource(doc));
            Assert.assertThat((Object)so, (Matcher)Matchers.isSamlLogoutRequest((String)"http://url-to-sales-2"));
            return new SAML2LogoutResponseBuilder().destination(this.getAuthServerSamlEndpoint("demo").toString()).issuer("http://localhost:8280/sales-post2/").logoutRequestID(((LogoutRequestType)so).getID()).buildDocument();
        })).targetAttributeSamlResponse().targetUri(this.getAuthServerSamlEndpoint("demo")).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        Assert.assertThat((Object)((StatusResponseType)samlResponse.getSamlObject()).getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)"http://url"));
        this.assertLogoutEvent("http://localhost:8280/sales-post2/");
    }

    private void assertLogoutEvent(String clientId) {
        List logoutEvents = this.adminClient.realm("demo").getEvents(Arrays.asList(EventType.LOGOUT.name()), clientId, null, null, null, null, null, null);
        Assert.assertFalse((boolean)logoutEvents.isEmpty());
        Assert.assertEquals((long)1L, (long)logoutEvents.size());
        EventRepresentation logoutEvent = (EventRepresentation)logoutEvents.get(0);
        Assert.assertEquals((Object)"http://url", logoutEvent.getDetails().get("redirect_uri"));
        Assert.assertEquals((Object)this.bburkeUser.getUsername(), logoutEvent.getDetails().get("username"));
        Assert.assertEquals((Object)"post", logoutEvent.getDetails().get("response_mode"));
        Assert.assertEquals((Object)"saml", logoutEvent.getDetails().get("auth_method"));
        Assert.assertNotNull(logoutEvent.getDetails().get("SAML_LOGOUT_REQUEST_ID"));
    }

    private IdentityProviderRepresentation addIdentityProvider() {
        IdentityProviderRepresentation identityProvider = IdentityProviderBuilder.create().providerId("saml").alias("saml-broker").displayName("SAML").setAttribute("singleSignOnServiceUrl", "https://saml.idp/saml").setAttribute("singleLogoutServiceUrl", BROKER_LOGOUT_SERVICE_URL).setAttribute("nameIDPolicyFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress").setAttribute("postBindingResponse", "false").setAttribute("postBindingAuthnRequest", "false").setAttribute("backchannelSupported", "false").build();
        return identityProvider;
    }

    private SAML2Object createAuthnResponse(SAML2Object so) {
        AuthnRequestType req = (AuthnRequestType)so;
        try {
            ResponseType res = new SAML2LoginResponseBuilder().requestID(req.getID()).destination(req.getAssertionConsumerServiceURL().toString()).issuer("https://saml.idp/saml").assertionExpiration(1000000).subjectExpiration(1000000).requestIssuer(this.getAuthServerRealmBase("demo").toString()).nameIdentifier(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get(), "a@b.c").authMethod(JBossSAMLURIConstants.AC_UNSPECIFIED.get()).sessionIndex("idp:" + UUID.randomUUID()).buildModel();
            NameIDType nameId = (NameIDType)((ResponseType.RTChoiceType)res.getAssertions().get(0)).getAssertion().getSubject().getSubType().getBaseID();
            nameId.setNameQualifier(NAME_QUALIFIER);
            nameId.setSPNameQualifier(SP_NAME_QUALIFIER);
            nameId.setSPProvidedID(SP_PROVIDED_ID);
            return res;
        }
        catch (ConfigurationException | ProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private SAML2Object createIdPLogoutResponse(SAML2Object so) {
        LogoutRequestType req = (LogoutRequestType)so;
        try {
            return new SAML2LogoutResponseBuilder().logoutRequestID(req.getID()).destination(this.getSamlBrokerUrl("demo").toString()).issuer("https://saml.idp/saml").buildModel();
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Test
    public void testLogoutPropagatesToSamlIdentityProvider() throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        try (ServerResourceUpdater sales = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setFrontchannelLogout(Boolean.valueOf(true)).removeAttribute("saml_single_logout_service_url_post").setAttribute("saml_single_logout_service_url_redirect", "http://url").update();
             IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider());){
            SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)this.logIntoUnsignedSalesAppViaIdp().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createIdPLogoutResponse)).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).build().getSamlResponse(SamlClient.Binding.REDIRECT);
            Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        }
    }

    @Test
    public void testLogoutPropagatesToSamlIdentityProviderNameIdPreserved() throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        try (ServerResourceUpdater sales = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setFrontchannelLogout(Boolean.valueOf(true)).removeAttribute("saml_single_logout_service_url_post").setAttribute("saml_single_logout_service_url_redirect", "http://url").update();
             IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider());){
            SAMLDocumentHolder samlResponse = this.logIntoUnsignedSalesAppViaIdp().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().getSamlResponse(SamlClient.Binding.REDIRECT);
            Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlLogoutRequest((String)BROKER_LOGOUT_SERVICE_URL));
            LogoutRequestType lr = (LogoutRequestType)samlResponse.getSamlObject();
            NameIDType logoutRequestNameID = lr.getNameID();
            Assert.assertThat((Object)logoutRequestNameID.getFormat(), (Matcher)org.hamcrest.Matchers.is((Object)JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.getUri()));
            Assert.assertThat((Object)logoutRequestNameID.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"a@b.c"));
            Assert.assertThat((Object)logoutRequestNameID.getNameQualifier(), (Matcher)org.hamcrest.Matchers.is((Object)NAME_QUALIFIER));
            Assert.assertThat((Object)logoutRequestNameID.getSPProvidedID(), (Matcher)org.hamcrest.Matchers.is((Object)SP_PROVIDED_ID));
            Assert.assertThat((Object)logoutRequestNameID.getSPNameQualifier(), (Matcher)org.hamcrest.Matchers.is((Object)SP_NAME_QUALIFIER));
        }
    }

    @Test
    public void testLogoutDestinationOptionalIfUnsignedRedirect() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.REDIRECT, builder -> builder.transformObject(logoutReq -> logoutReq.setDestination(null)), LogoutTest::assertSamlLogoutRequest);
    }

    @Test
    public void testLogoutMandatoryDestinationUnsetRedirect() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.REDIRECT, builder -> ((CreateLogoutRequestStepBuilder)builder.transformObject(logoutReq -> logoutReq.setDestination(null))).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), LogoutTest::assertBadRequest);
    }

    @Test
    public void testLogoutMandatoryDestinationSetRedirect() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.REDIRECT, builder -> builder.signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), LogoutTest::assertSamlLogoutRequest);
    }

    @Test
    public void testLogoutDestinationOptionalIfUnsignedPost() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.POST, builder -> builder.transformObject(logoutReq -> logoutReq.setDestination(null)), LogoutTest::assertSamlLogoutRequest);
    }

    @Test
    public void testLogoutMandatoryDestinationUnsetPost() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.POST, builder -> ((CreateLogoutRequestStepBuilder)builder.transformObject(logoutReq -> logoutReq.setDestination(null))).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), LogoutTest::assertBadRequest);
    }

    @Test
    public void testLogoutMandatoryDestinationSetPost() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.POST, builder -> builder.signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), LogoutTest::assertSamlLogoutRequest);
    }

    private void testLogoutDestination(SamlClient.Binding binding, Consumer<CreateLogoutRequestStepBuilder> logoutReqUpdater, Consumer<? super CloseableHttpResponse> responseTester) throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        try (ServerResourceUpdater sales = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setFrontchannelLogout(Boolean.valueOf(true)).removeAttribute("saml_single_logout_service_url_post").setAttribute("saml_single_logout_service_url_redirect", "http://url").update();
             IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider());){
            ((CreateLogoutRequestStepBuilder)this.logIntoUnsignedSalesAppViaIdp().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", binding).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).apply(logoutReqUpdater)).build().doNotFollowRedirects().assertResponse(responseTester).execute();
        }
    }

    public static void assertSamlLogoutRequest(CloseableHttpResponse response) {
        try {
            Assert.assertThat((Object)SamlClient.Binding.REDIRECT.extractResponse(response).getSamlObject(), (Matcher)Matchers.isSamlLogoutRequest((String)BROKER_LOGOUT_SERVICE_URL));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void assertBadRequest(HttpResponse response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
    }
}

