/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.OneTimeUseType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class IncludeOneTimeUseConditionTest
extends AbstractSamlTest {
    @Test
    public void testOneTimeUseConditionIsAdded() throws Exception {
        this.testOneTimeUseConditionIncluded(Boolean.TRUE);
    }

    @Test
    public void testOneTimeUseConditionIsNotAdded() throws Exception {
        this.testOneTimeUseConditionIncluded(Boolean.FALSE);
    }

    private void testOneTimeUseConditionIncluded(Boolean oneTimeUseConditionShouldBeIncluded) throws IOException {
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.onetimeuse.condition", oneTimeUseConditionShouldBeIncluded.toString()).update();){
            SAMLDocumentHolder res = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
            Assert.assertThat((Object)res.getSamlObject(), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)res.getSamlObject(), (Matcher)Matchers.instanceOf(ResponseType.class));
            ResponseType rt = (ResponseType)res.getSamlObject();
            Assert.assertThat((Object)rt.getAssertions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            ConditionsType conditionsType = ((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion().getConditions();
            Assert.assertThat((Object)conditionsType, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)conditionsType.getConditions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            List conditions = conditionsType.getConditions();
            Collection oneTimeUseConditions = Collections2.filter((Collection)conditions, input -> input instanceof OneTimeUseType);
            boolean oneTimeUseConditionAdded = !oneTimeUseConditions.isEmpty();
            Assert.assertThat((Object)oneTimeUseConditionAdded, (Matcher)Matchers.is((Object)oneTimeUseConditionShouldBeIncluded));
        }
    }
}

