/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.IdentityProviderCreator;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

public class IdpInitiatedLoginTest
extends AbstractSamlTest {
    @Test
    public void testIdpInitiatedLoginPost() {
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)SAML_ASSERTION_CONSUMER_URL_SALES_POST));
            return null;
        })).build().execute();
    }

    @Test
    public void testIdpInitiatedLoginPostAdminUrl() throws IOException {
        String url = (String)((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0)).getAttributes().get("saml_assertion_consumer_url_post");
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAdminUrl(url).setAttribute("saml_assertion_consumer_url_post", null).setAttribute("saml_assertion_consumer_url_redirect", null).update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
                Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
                ResponseType resp = (ResponseType)ob;
                Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)SAML_ASSERTION_CONSUMER_URL_SALES_POST));
                return null;
            })).build().execute();
        }
    }

    @Test
    public void testIdpInitiatedLoginRedirect() throws IOException {
        String url = (String)((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0)).getAttributes().get("saml_assertion_consumer_url_post");
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_assertion_consumer_url_post", null).setAttribute("saml_assertion_consumer_url_redirect", url).update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(ob -> {
                Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
                ResponseType resp = (ResponseType)ob;
                Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)SAML_ASSERTION_CONSUMER_URL_SALES_POST));
                return null;
            })).build().execute();
        }
    }

    @Test
    public void testTwoConsequentIdpInitiatedLogins() {
        ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)SAML_ASSERTION_CONSUMER_URL_SALES_POST));
            return null;
        })).build().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post2").build().login().sso(true).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)SAML_ASSERTION_CONSUMER_URL_SALES_POST2));
            return null;
        })).build().execute();
        UsersResource users = this.adminClient.realm("demo").users();
        ClientsResource clients = this.adminClient.realm("demo").clients();
        UserRepresentation bburkeUserRepresentation = (UserRepresentation)users.search(this.bburkeUser.getUsername()).stream().findFirst().get();
        List userSessions = users.get(bburkeUserRepresentation.getId()).getUserSessions();
        Assert.assertThat((Object)userSessions, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
        Map clientSessions = ((UserSessionRepresentation)userSessions.get(0)).getClients();
        Set clientIds = clientSessions.values().stream().flatMap(c -> clients.findByClientId(c).stream()).map(ClientRepresentation::getClientId).collect(Collectors.toSet());
        Assert.assertThat(clientIds, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"http://localhost:8280/sales-post/", "http://localhost:8280/sales-post2/"}));
    }

    @Test
    public void testIdpInitiatedLoginWithOIDCClient() {
        ClientRepresentation clientRep = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        this.adminClient.realm("demo").clients().get(clientRep.getId()).update(ClientBuilder.edit(clientRep).protocol("openid-connect").build());
        new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().execute(r -> {
            Assert.assertThat((Object)r, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
            Assert.assertThat((Object)r, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"Wrong client protocol.")));
        });
        this.adminClient.realm("demo").clients().get(clientRep.getId()).update(ClientBuilder.edit(clientRep).protocol("saml").build());
    }

    @Test
    public void testSamlPostBindingPageLogin() {
        new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().execute(r -> {
            Assert.assertThat((Object)r, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            Assert.assertThat((Object)r, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"Redirecting, please wait."), (Matcher)org.hamcrest.Matchers.containsString((String)"<input type=\"hidden\" name=\"SAMLResponse\""), (Matcher)org.hamcrest.Matchers.containsString((String)"<h1 id=\"kc-page-title\">"))));
        });
    }

    @Test
    public void testSamlPostBindingPageIdP() throws Exception {
        try (IdentityProviderCreator idp = new IdentityProviderCreator(this.adminClient.realm("demo"), IdentityProviderBuilder.create().alias("saml-idp").providerId("saml").setAttribute("singleSignOnServiceUrl", "https://saml-idp-sso-service/").setAttribute("postBindingAuthnRequest", "true").build());){
            new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().idp("saml-idp").build().execute(r -> {
                Assert.assertThat((Object)r, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
                Assert.assertThat((Object)r, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"Redirecting, please wait."), (Matcher)org.hamcrest.Matchers.containsString((String)"<input type=\"hidden\" name=\"SAMLRequest\""), (Matcher)org.hamcrest.Matchers.containsString((String)"<h1 id=\"kc-page-title\">"))));
            });
        }
    }
}

