/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.saml.LoginBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.w3c.dom.Document;

@Ignore
public class ConcurrentAuthnRequestTest
extends AbstractSamlTest {
    public static final int ITERATIONS = 10000;
    public static final int CONCURRENT_THREADS = 5;

    private void loginRepeatedly(UserRepresentation user, URI samlEndpoint, String relayState, SamlClient.Binding requestBinding) {
        CloseableHttpResponse response = null;
        SamlClient.RedirectStrategyWithSwitchableFollowRedirect strategy = new SamlClient.RedirectStrategyWithSwitchableFollowRedirect();
        ExecutorService threadPool = Executors.newFixedThreadPool(5);
        try (CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)strategy).build();){
            LinkedList<Callable<Void>> futures = new LinkedList<Callable<Void>>();
            int i = 0;
            while (i < 10000) {
                int j = i++;
                AuthnRequestType loginRep = this.createLoginRequestDocument("http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, "demo");
                Document samlRequest = SAML2Request.convert((RequestAbstractType)loginRep);
                HttpUriRequest post = requestBinding.createSamlUnsignedRequest(samlEndpoint, relayState, samlRequest);
                Callable<Void> f = () -> {
                    ConcurrentAuthnRequestTest.performLogin(post, samlEndpoint, relayState, loginRep.getID(), samlRequest, response, client, user, strategy);
                    return null;
                };
                futures.add(f);
            }
            threadPool.invokeAll(futures);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void performLogin(HttpUriRequest post, URI samlEndpoint, String relayState, String requestId, Document samlRequest, CloseableHttpResponse response, CloseableHttpClient client, UserRepresentation user, SamlClient.RedirectStrategyWithSwitchableFollowRedirect strategy) {
        try {
            HttpClientContext context = HttpClientContext.create();
            response = client.execute(post, (HttpContext)context);
            String loginPageText = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            response.close();
            HttpUriRequest loginRequest = LoginBuilder.handleLoginPage((UserRepresentation)user, (String)loginPageText);
            strategy.setRedirectable(false);
            response = client.execute(loginRequest, (HttpContext)context);
            SAMLDocumentHolder parseResponsePostBinding = SAMLRequestParser.parseResponsePostBinding((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            MatcherAssert.assertThat((Object)parseResponsePostBinding.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            MatcherAssert.assertThat((Object)((ResponseType)parseResponsePostBinding.getSamlObject()).getInResponseTo(), (Matcher)org.hamcrest.Matchers.is((Object)requestId));
            response.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml.json"));
    }

    @Override
    public AuthnRequestType createLoginRequestDocument(String issuer, String assertionConsumerURL, String realmName) {
        return SamlClient.createLoginRequestDocument((String)issuer, (String)assertionConsumerURL, (URI)this.getAuthServerSamlEndpoint(realmName));
    }

    private void testLogin(SamlClient.Binding requestBinding) throws Exception {
        this.loginRepeatedly(this.bburkeUser, this.getAuthServerSamlEndpoint("demo"), null, requestBinding);
    }

    @Test
    public void testConcurrentPostLogins() throws Exception {
        this.testLogin(SamlClient.Binding.POST);
    }
}

