/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.net.URI;
import java.security.KeyPair;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2LoginResponseBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.XmlDSigQNames;
import org.keycloak.saml.processing.core.parsers.util.HasQName;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.IdentityProviderCreator;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateAuthnRequestStepBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BrokerTest
extends AbstractSamlTest {
    private static final String XMLNS_VETINARI = "vetinari";
    private static final String NS_VETINARI = "urn:dw:am:havelock";

    private IdentityProviderRepresentation addIdentityProvider(String samlEndpoint) {
        IdentityProviderRepresentation identityProvider = IdentityProviderBuilder.create().providerId("saml").alias("saml-broker").displayName("SAML").setAttribute("singleSignOnServiceUrl", samlEndpoint).setAttribute("singleLogoutServiceUrl", samlEndpoint).setAttribute("nameIDPolicyFormat", JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get()).setAttribute("postBindingResponse", "false").setAttribute("postBindingAuthnRequest", "false").setAttribute("backchannelSupported", "false").build();
        return identityProvider;
    }

    private SAML2Object createAuthnResponse(SAML2Object so) {
        AuthnRequestType req = (AuthnRequestType)so;
        try {
            ResponseType res = new SAML2LoginResponseBuilder().requestID(req.getID()).destination(req.getAssertionConsumerServiceURL().toString()).issuer("https://saml.idp/saml").assertionExpiration(1000000).subjectExpiration(1000000).requestIssuer(this.getAuthServerRealmBase("demo").toString()).sessionIndex("idp:" + UUID.randomUUID()).buildModel();
            AttributeStatementType attrStatement = new AttributeStatementType();
            AttributeType attribute = new AttributeType("mail");
            attribute.addAttributeValue((Object)"v@w.x");
            attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attribute));
            ((ResponseType.RTChoiceType)res.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attrStatement);
            return res;
        }
        catch (ConfigurationException | ProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogoutPropagatesToSamlIdentityProvider() throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        ClientsResource clients = realm.clients();
        AuthenticationExecutionInfoRepresentation reviewProfileAuthenticator = null;
        String firstBrokerLoginFlowAlias = null;
        try (IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider("https://saml.idp/saml"));){
            IdentityProviderRepresentation idpRepresentation = idp.identityProvider().toRepresentation();
            firstBrokerLoginFlowAlias = idpRepresentation.getFirstBrokerLoginFlowAlias();
            List executions = realm.flows().getExecutions(firstBrokerLoginFlowAlias);
            reviewProfileAuthenticator = executions.stream().filter(ex -> Objects.equals(ex.getProviderId(), "idp-review-profile")).findFirst().orElseGet(() -> {
                Assert.fail((String)"Could not find update profile in first broker login flow");
                return null;
            });
            reviewProfileAuthenticator.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.name());
            realm.flows().updateExecutions(firstBrokerLoginFlowAlias, reviewProfileAuthenticator);
            SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformObject(ar -> {
                NameIDPolicyType nameIDPolicy = new NameIDPolicyType();
                nameIDPolicy.setAllowCreate(Boolean.TRUE);
                nameIDPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.getUri());
                ar.setNameIDPolicy(nameIDPolicy);
                return ar;
            })).build().login().idp("saml-broker").build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createAuthnResponse)).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).build().followOneRedirect().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
            MatcherAssert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_RESPONDER, JBossSAMLURIConstants.STATUS_INVALID_NAMEIDPOLICY}));
        }
        catch (Throwable throwable) {
            reviewProfileAuthenticator.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.name());
            realm.flows().updateExecutions(firstBrokerLoginFlowAlias, reviewProfileAuthenticator);
            throw throwable;
        }
        reviewProfileAuthenticator.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.name());
        realm.flows().updateExecutions(firstBrokerLoginFlowAlias, reviewProfileAuthenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInResponseToSetCorrectly() throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        try (IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider("https://saml.idp/saml"));){
            AtomicReference serviceProvidersId = new AtomicReference();
            SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformObject(ar -> {
                serviceProvidersId.set(ar.getID());
                return ar;
            })).build().login().idp("saml-broker").build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createAuthnResponse)).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).build().followOneRedirect().updateProfile().username("userInResponseTo").email("f@g.h").firstName("a").lastName("b").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
            MatcherAssert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
            MatcherAssert.assertThat((Object)((ResponseType)samlResponse.getSamlObject()).getInResponseTo(), (Matcher)org.hamcrest.Matchers.is((Object)((String)serviceProvidersId.get())));
        }
        finally {
            this.clearUsers(realm);
        }
    }

    private void clearUsers(RealmResource realm) {
        realm.users().list().stream().map(UserRepresentation::getId).map(arg_0 -> ((UsersResource)realm.users()).get(arg_0)).forEach(UserResource::remove);
    }

    @Test
    public void testNoNameIDAndPrincipalFromAttribute() throws IOException {
        String userName = "newUser-" + UUID.randomUUID();
        RealmResource realm = this.adminClient.realm("demo");
        IdentityProviderRepresentation rep = this.addIdentityProvider("https://saml.idp/");
        rep.getConfig().put("nameIDPolicyFormat", "undefined");
        rep.getConfig().put("principalType", SamlPrincipalType.ATTRIBUTE.toString());
        rep.getConfig().put("principalAttribute", "user");
        try (IdentityProviderCreator idp = new IdentityProviderCreator(realm, rep);){
            ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().idp("saml-broker").build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createAuthnResponse)).transformObject(resp -> {
                ResponseType rt = (ResponseType)resp;
                AssertionType assertion = ((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion();
                assertion.getSubject().setSubType(null);
                AttributeStatementType attrStatement = new AttributeStatementType();
                AttributeType attribute = new AttributeType("user");
                attribute.addAttributeValue((Object)userName);
                attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attribute));
                ((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attrStatement);
                return rt;
            })).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).build().followOneRedirect().updateProfile().username(userName).firstName("someFirstName").lastName("someLastName").email("some@email.com").build().followOneRedirect().assertResponse(Matchers.statusCodeIsHC((int)200)).execute();
        }
        UserRepresentation userRepresentation = (UserRepresentation)realm.users().search(userName).stream().findFirst().get();
        List userSessions = realm.users().get(userRepresentation.getId()).getUserSessions();
        MatcherAssert.assertThat((Object)userSessions, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
    }

    @Test
    public void testRedirectQueryParametersPreserved() throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        try (IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider("https://saml.idp/?service=name&serviceType=prod"));){
            SAMLDocumentHolder samlResponse = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().idp("saml-broker").build().getSamlResponse(SamlClient.Binding.REDIRECT);
            MatcherAssert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(AuthnRequestType.class));
            AuthnRequestType ar = (AuthnRequestType)samlResponse.getSamlObject();
            MatcherAssert.assertThat((Object)ar.getDestination(), (Matcher)org.hamcrest.Matchers.equalTo((Object)URI.create("https://saml.idp/?service=name&serviceType=prod")));
            Header[] headers = (Header[])new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().idp("saml-broker").build().doNotFollowRedirects().executeAndTransform(resp -> resp.getHeaders("Location"));
            MatcherAssert.assertThat((Object)headers.length, (Matcher)org.hamcrest.Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)headers[0].getValue(), (Matcher)org.hamcrest.Matchers.containsString((String)"https://saml.idp/?service=name&serviceType=prod"));
            MatcherAssert.assertThat((Object)headers[0].getValue(), (Matcher)org.hamcrest.Matchers.containsString((String)"SAMLRequest"));
        }
    }

    private static Element appendNewElement(Element parent, QName qName, String prefix) throws DOMException {
        Document doc = parent.getOwnerDocument();
        Element res = doc.createElementNS(qName.getNamespaceURI(), prefix + ":" + qName.getLocalPart());
        parent.appendChild(res);
        return res;
    }

    private static void signAndAddCustomNamespaceElementToSignature(Document doc) {
        doc.getDocumentElement().setAttribute("xmlns:vetinari", NS_VETINARI);
        BaseSAML2BindingBuilder sb = new BaseSAML2BindingBuilder();
        try {
            KeyPair keyPair = new KeyPair(SAML_CLIENT_SALES_POST_SIG_PUBLIC_KEY_PK, SAML_CLIENT_SALES_POST_SIG_PRIVATE_KEY_PK);
            sb.signWith("kn", keyPair).signatureAlgorithm(SignatureAlgorithm.RSA_SHA1).signAssertions().signAssertion(doc);
        }
        catch (ProcessingException ex) {
            throw new RuntimeException(ex);
        }
        Element el = BrokerTest.findFirstElement(doc, (HasQName)XmlDSigQNames.KEY_INFO);
        BrokerTest.appendNewElement(el, new QName(NS_VETINARI, "Patrician"), XMLNS_VETINARI);
    }

    private static Element findFirstElement(Document doc, HasQName qName) {
        NodeList nl = doc.getElementsByTagNameNS(qName.getQName().getNamespaceURI(), qName.getQName().getLocalPart());
        return nl == null || nl.getLength() == 0 ? null : (Element)nl.item(0);
    }

    @Test
    public void testAnyNamespacePreservedInContext() throws IOException {
        RealmResource realm = this.adminClient.realm("demo");
        try (IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider("https://saml.idp/"));){
            ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().idp("saml-broker").build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createAuthnResponse)).transformDocument(BrokerTest::signAndAddCustomNamespaceElementToSignature)).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).targetBinding(SamlClient.Binding.POST).build().assertResponse(Matchers.statusCodeIsHC((Response.Status)Response.Status.OK)).execute();
        }
    }

    @Test
    public void testExpiredAssertion() throws Exception {
        XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
        XMLGregorianCalendar notBeforeInPast = XMLTimeUtil.subtract((XMLGregorianCalendar)now, (long)3600000L);
        XMLGregorianCalendar notOnOrAfterInPast = XMLTimeUtil.subtract((XMLGregorianCalendar)now, (long)3540000L);
        XMLGregorianCalendar notBeforeInFuture = XMLTimeUtil.add((XMLGregorianCalendar)now, (long)3540000L);
        XMLGregorianCalendar notOnOrAfterInFuture = XMLTimeUtil.add((XMLGregorianCalendar)now, (long)3600000L);
        this.assertExpired(notBeforeInPast, notOnOrAfterInPast, false);
        this.assertExpired(notBeforeInFuture, notOnOrAfterInPast, false);
        this.assertExpired(null, notOnOrAfterInPast, false);
        this.assertExpired(notBeforeInFuture, notOnOrAfterInFuture, false);
        this.assertExpired(notBeforeInFuture, null, false);
        this.assertExpired(notBeforeInPast, notOnOrAfterInFuture, true);
        this.assertExpired(notBeforeInPast, null, true);
        this.assertExpired(null, notOnOrAfterInFuture, true);
        this.assertExpired(null, null, true);
    }

    @Test(expected=AssertionError.class)
    public void testNonexpiredAssertionShouldFail() throws Exception {
        this.assertExpired(null, null, false);
    }

    @Test(expected=AssertionError.class)
    public void testExpiredAssertionShouldFail() throws Exception {
        XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
        XMLGregorianCalendar notBeforeInPast = XMLTimeUtil.subtract((XMLGregorianCalendar)now, (long)3600000L);
        XMLGregorianCalendar notOnOrAfterInPast = XMLTimeUtil.subtract((XMLGregorianCalendar)now, (long)3540000L);
        this.assertExpired(notBeforeInPast, notOnOrAfterInPast, true);
    }

    private void assertExpired(XMLGregorianCalendar notBefore, XMLGregorianCalendar notOnOrAfter, boolean shouldPass) throws Exception {
        Response.Status expectedStatus = shouldPass ? Response.Status.OK : Response.Status.BAD_REQUEST;
        RealmResource realm = this.adminClient.realm("demo");
        try (IdentityProviderCreator idp = new IdentityProviderCreator(realm, this.addIdentityProvider("https://saml.idp/"));){
            ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().idp("saml-broker").build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::createAuthnResponse)).transformObject(resp -> {
                ResponseType rt = (ResponseType)resp;
                AssertionType a = ((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion();
                NameIDType nameId = new NameIDType();
                nameId.setFormat(URI.create(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get()));
                nameId.setValue(UUID.randomUUID() + "@random.email.org");
                SubjectType subject = new SubjectType();
                SubjectType.STSubType subType = new SubjectType.STSubType();
                subType.addBaseID((BaseIDAbstractType)nameId);
                subject.setSubType(subType);
                a.setSubject(subject);
                ConditionsType conditions = a.getConditions();
                conditions.setNotBefore(notBefore);
                conditions.setNotOnOrAfter(notOnOrAfter);
                return rt;
            })).targetAttributeSamlResponse().targetUri(this.getSamlBrokerUrl("demo")).build().assertResponse(Matchers.statusCodeIsHC((Response.Status)expectedStatus)).execute();
        }
    }
}

