/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.net.URI;
import java.security.Signature;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.resteasy.util.Encode;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.KeyUtils;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.saml.CreateAuthnRequestStepBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicSamlTest
extends AbstractSamlTest {
    @Test
    public void testPropertyValueInAssertion() throws ParsingException, ConfigurationException, ProcessingException {
        SAMLDocumentHolder document = ((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformDocument(doc -> {
            IOUtil.setDocElementAttributeValue((Document)doc, (String)"samlp:AuthnRequest", (String)"ID", (String)"${java.version}");
            return doc;
        })).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
        MatcherAssert.assertThat((Object)IOUtil.documentToString((Document)document.getSamlDocument()), (Matcher)CoreMatchers.not((Matcher)org.hamcrest.Matchers.containsString((String)("InResponseTo=\"" + System.getProperty("java.version") + "\""))));
    }

    @Test
    public void testRedirectUrlSigned() throws Exception {
        this.testSpecialCharsInRelayState(null);
    }

    @Test
    public void testRedirectUrlUnencodedSpecialChars() throws Exception {
        this.testSpecialCharsInRelayState("New%20Document%20(1).doc");
    }

    @Test
    public void testRedirectUrlEncodedSpecialChars() throws Exception {
        this.testSpecialCharsInRelayState("New%20Document%20%281%29.doc");
    }

    private void testSpecialCharsInRelayState(String encodedRelayState) throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post-sig/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG, (URI)this.getAuthServerSamlEndpoint("demo"));
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        URI redirect = SamlClient.Binding.REDIRECT.createSamlUnsignedRequest(this.getAuthServerSamlEndpoint("demo"), null, doc).getURI();
        String query = redirect.getRawQuery();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SHA256;
        String relayStatePart = encodedRelayState == null ? "" : "&RelayState=" + encodedRelayState;
        String sigAlgPart = "&SigAlg=" + Encode.encodeQueryParamAsIs((String)signatureAlgorithm.getXmlSignatureMethod());
        Signature signature = signatureAlgorithm.createSignature();
        signature.initSign(KeyUtils.privateKeyFromString((String)"MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz"));
        signature.update(query.getBytes(GeneralConstants.SAML_CHARSET));
        signature.update(relayStatePart.getBytes(GeneralConstants.SAML_CHARSET));
        signature.update(sigAlgPart.getBytes(GeneralConstants.SAML_CHARSET));
        byte[] sig = signature.sign();
        String encodedSig = RedirectBindingUtil.base64Encode((byte[])sig);
        String sigPart = "&Signature=" + Encode.encodeQueryParamAsIs((String)encodedSig);
        new SamlClientBuilder().navigateTo(redirect.toString() + relayStatePart + sigAlgPart + sigPart).assertResponse(Matchers.statusCodeIsHC((Response.Status)Response.Status.OK)).execute();
    }

    @Test
    public void testNoDestinationPost() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        HttpUriRequest post = SamlClient.Binding.POST.createSamlUnsignedRequest(this.getAuthServerSamlEndpoint("demo"), null, doc);
        try (CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new SamlClient.RedirectStrategyWithSwitchableFollowRedirect()).build();
             CloseableHttpResponse response = client.execute(post);){
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), (Matcher)org.hamcrest.Matchers.containsString((String)"login"));
        }
    }

    @Test
    public void testNoDestinationRedirect() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        HttpUriRequest post = SamlClient.Binding.REDIRECT.createSamlUnsignedRequest(this.getAuthServerSamlEndpoint("demo"), null, doc);
        try (CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new SamlClient.RedirectStrategyWithSwitchableFollowRedirect()).build();
             CloseableHttpResponse response = client.execute(post);){
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), (Matcher)org.hamcrest.Matchers.containsString((String)"login"));
        }
    }

    @Test
    public void testNoDestinationSignedPost() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post-sig/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG, null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        HttpUriRequest post = SamlClient.Binding.POST.createSamlSignedRequest(this.getAuthServerSamlEndpoint("demo"), null, doc, "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB");
        try (CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new SamlClient.RedirectStrategyWithSwitchableFollowRedirect()).build();
             CloseableHttpResponse response = client.execute(post);){
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testNoPortInDestination() throws Exception {
        this.testWithOverriddenPort(-1, Response.Status.OK, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"login"));
    }

    @Test
    public void testExplicitPortInDestination() throws Exception {
        this.testWithOverriddenPort(Integer.valueOf(ServerURLs.AUTH_SERVER_PORT), Response.Status.OK, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"login"));
    }

    @Test
    public void testWrongPortInDestination() throws Exception {
        this.testWithOverriddenPort(123, Response.Status.BAD_REQUEST, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"Invalid Request"));
    }

    private void testWithOverriddenPort(int port, Response.Status expectedHttpCode, Matcher<String> pageTextMatcher) throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, (URI)RealmsResource.protocolUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot()).port(port)).build(new Object[]{"demo", "saml"}));
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        HttpUriRequest post = SamlClient.Binding.POST.createSamlUnsignedRequest(this.getAuthServerSamlEndpoint("demo"), null, doc);
        try (CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new SamlClient.RedirectStrategyWithSwitchableFollowRedirect()).build();
             CloseableHttpResponse response = client.execute(post);){
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)expectedHttpCode));
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), pageTextMatcher);
        }
    }

    @Test
    public void testReauthnWithForceAuthnNotSet() throws Exception {
        this.testReauthnWithForceAuthn(null);
    }

    @Test
    public void testReauthnWithForceAuthnFalse() throws Exception {
        this.testReauthnWithForceAuthn(false);
    }

    @Test
    public void testReauthnWithForceAuthnTrue() throws Exception {
        this.testReauthnWithForceAuthn(true);
    }

    private void testReauthnWithForceAuthn(Boolean reloginRequired) throws Exception {
        SamlClient samlClient = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().execute(hr -> {
            try {
                SAMLDocumentHolder doc = SamlClient.Binding.POST.extractResponse(hr);
                MatcherAssert.assertThat((Object)doc.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
            }
            catch (IOException ex) {
                Logger.getLogger(BasicSamlTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        List secondAuthn = ((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SAML_ASSERTION_CONSUMER_URL_SALES_POST2, SamlClient.Binding.POST).transformObject(so -> {
            so.setForceAuthn(reloginRequired);
            return so;
        })).build().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)(Objects.equals(reloginRequired, Boolean.TRUE) ? "Sign in" : "SAMLResponse")))).getSteps();
        samlClient.execute(secondAuthn);
    }

    @Test
    public void testIsPassiveAttributeEmittedWhenTrue() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, (URI)this.getAuthServerSamlEndpoint("demo"));
        loginRep.setIsPassive(Boolean.valueOf(true));
        Document document = SAML2Request.convert((RequestAbstractType)loginRep);
        Element authnRequestElement = document.getDocumentElement();
        Attr isPassiveAttribute = authnRequestElement.getAttributeNode("IsPassive");
        MatcherAssert.assertThat((String)"AuthnRequest element should contain the IsPassive attribute when isPassive is true, but it doesn't", (Object)isPassiveAttribute, (Matcher)org.hamcrest.Matchers.notNullValue());
        MatcherAssert.assertThat((String)"AuthnRequest/IsPassive attribute should be true when isPassive is true, but it isn't", (Object)isPassiveAttribute.getNodeValue(), (Matcher)org.hamcrest.Matchers.is((Object)"true"));
    }

    @Test
    public void testIsPassiveAttributeOmittedWhenFalse() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, (URI)this.getAuthServerSamlEndpoint("demo"));
        loginRep.setIsPassive(Boolean.valueOf(false));
        Document document = SAML2Request.convert((RequestAbstractType)loginRep);
        Element authnRequestElement = document.getDocumentElement();
        Attr isPassiveAttribute = authnRequestElement.getAttributeNode("IsPassive");
        MatcherAssert.assertThat((String)"AuthnRequest element shouldn't contain the IsPassive attribute when isPassive is false, but it does", (Object)isPassiveAttribute, (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testAllowCreateAttributeOmittedWhenTransient() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, (URI)this.getAuthServerSamlEndpoint("demo"));
        loginRep.getNameIDPolicy().setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.getUri());
        loginRep.getNameIDPolicy().setAllowCreate(Boolean.valueOf(true));
        Document document = SAML2Request.convert((RequestAbstractType)loginRep);
        Element authnRequestElement = document.getDocumentElement();
        Element nameIdPolicyElement = DocumentUtil.getDirectChildElement((Element)authnRequestElement, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get(), (String)"NameIDPolicy");
        Attr formatAttribute = nameIdPolicyElement.getAttributeNode("Format");
        Attr allowCreateAttribute = nameIdPolicyElement.getAttributeNode("AllowCreate");
        MatcherAssert.assertThat((String)"AuthnRequest/NameIdPolicy Format should be present, but it is not", (Object)formatAttribute, (Matcher)org.hamcrest.Matchers.notNullValue());
        MatcherAssert.assertThat((String)"AuthnRequest/NameIdPolicy Format should be Transient, but it is not", (Object)formatAttribute.getNodeValue(), (Matcher)org.hamcrest.Matchers.is((Object)JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()));
        MatcherAssert.assertThat((String)"AuthnRequest/NameIdPolicy element shouldn't contain the AllowCreate attribute when Format is set to Transient, but it does", (Object)allowCreateAttribute, (Matcher)org.hamcrest.Matchers.nullValue());
    }
}

