/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateAuthnRequestStepBuilder;

public class AuthnRequestTest
extends AbstractSamlTest {
    @Test
    public void testIsPassiveNotSet() throws Exception {
        String res = (String)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformObject(so -> {
            so.setIsPassive(null);
            return so;
        })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        Assert.assertThat((Object)res, (Matcher)Matchers.containsString((String)"login"));
    }

    @Test
    public void testIsForceAuthNotSet() throws Exception {
        String res = (String)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformObject(so -> {
            so.setForceAuthn(null);
            return so;
        })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        Assert.assertThat((Object)res, (Matcher)Matchers.containsString((String)"login"));
    }

    @Test
    public void testIsPassiveFalse() throws Exception {
        String res = (String)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformObject(so -> {
            so.setIsPassive(Boolean.valueOf(false));
            return so;
        })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        Assert.assertThat((Object)res, (Matcher)Matchers.containsString((String)"login"));
    }

    @Test
    public void testIssuerNotSet() throws Exception {
        String res = (String)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).transformObject(so -> {
            so.setIssuer(null);
            return so;
        })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        Assert.assertThat((Object)res, (Matcher)Matchers.containsString((String)"login"));
    }
}

