/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.util.ArtifactResolutionService;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateArtifactMessageStepBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.Document;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ArtifactBindingWithResolutionServiceTest
extends AbstractSamlTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveArtifactLoginFullWithPost() throws ParsingException, ConfigurationException, ProcessingException, InterruptedException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_artifact_resolution_service_url", "http://127.0.0.1:8082/").update());
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)AbstractSamlTest.SAML_ASSERTION_CONSUMER_URL_SALES_POST, null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        SamlClientBuilder builder = new SamlClientBuilder();
        CreateArtifactMessageStepBuilder camb = new CreateArtifactMessageStepBuilder(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST, builder);
        ArtifactResolutionService ars = new ArtifactResolutionService("http://127.0.0.1:8082/").setResponseDocument(doc);
        Thread arsThread = new Thread((Runnable)ars);
        try {
            arsThread.start();
            ArtifactResolutionService artifactResolutionService = ars;
            synchronized (artifactResolutionService) {
                ars.wait();
                SAMLDocumentHolder response = builder.artifactMessage(camb).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
                Assert.assertThat((Object)response.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
                ResponseType rt = (ResponseType)response.getSamlObject();
                Assert.assertThat((Object)rt.getAssertions(), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.empty()));
                Assert.assertThat((Object)ars.getLastArtifactResolve(), (Matcher)org.hamcrest.Matchers.notNullValue());
                Assert.assertThat((Object)camb.getLastArtifact(), (Matcher)org.hamcrest.Matchers.is((Object)ars.getLastArtifactResolve().getArtifact()));
            }
        }
        finally {
            ars.stop();
            arsThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveArtifactLoginFullWithRedirect() throws ParsingException, ConfigurationException, ProcessingException, InterruptedException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_artifact_resolution_service_url", "http://127.0.0.1:8082/").update());
        AuthnRequestType loginReq = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)AbstractSamlTest.SAML_ASSERTION_CONSUMER_URL_SALES_POST, null);
        loginReq.setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri());
        Document doc = SAML2Request.convert((RequestAbstractType)loginReq);
        SamlClientBuilder builder = new SamlClientBuilder();
        CreateArtifactMessageStepBuilder camb = new CreateArtifactMessageStepBuilder(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT, builder);
        ArtifactResolutionService ars = new ArtifactResolutionService("http://127.0.0.1:8082/").setResponseDocument(doc);
        Thread arsThread = new Thread((Runnable)ars);
        try {
            arsThread.start();
            ArtifactResolutionService artifactResolutionService = ars;
            synchronized (artifactResolutionService) {
                ars.wait();
                SAMLDocumentHolder response = builder.artifactMessage(camb).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.REDIRECT);
                Assert.assertThat((Object)response.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
                ResponseType rt = (ResponseType)response.getSamlObject();
                Assert.assertThat((Object)rt.getAssertions(), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.empty()));
                Assert.assertThat((Object)ars.getLastArtifactResolve(), (Matcher)org.hamcrest.Matchers.notNullValue());
                Assert.assertThat((Object)camb.getLastArtifact(), (Matcher)org.hamcrest.Matchers.is((Object)ars.getLastArtifactResolve().getArtifact()));
            }
        }
        finally {
            ars.stop();
            arsThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveArtifactNonExistingClient() throws ParsingException, ConfigurationException, ProcessingException, InterruptedException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_artifact_resolution_service_url", "http://127.0.0.1:8082/").update());
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"blabla", (String)AbstractSamlTest.SAML_ASSERTION_CONSUMER_URL_SALES_POST, null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        SamlClientBuilder builder = new SamlClientBuilder();
        CreateArtifactMessageStepBuilder camb = new CreateArtifactMessageStepBuilder(this.getAuthServerSamlEndpoint("demo"), "blabla", SamlClient.Binding.POST, builder);
        ArtifactResolutionService ars = new ArtifactResolutionService("http://127.0.0.1:8082/").setResponseDocument(doc);
        Thread arsThread = new Thread((Runnable)ars);
        try {
            arsThread.start();
            ArtifactResolutionService artifactResolutionService = ars;
            synchronized (artifactResolutionService) {
                ars.wait();
                String response = (String)builder.artifactMessage(camb).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
                Assert.assertThat((Object)response, (Matcher)org.hamcrest.Matchers.containsString((String)"Invalid Request"));
            }
        }
        finally {
            ars.stop();
            arsThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveEmptyArtifactResponse() throws InterruptedException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_artifact_resolution_service_url", "http://127.0.0.1:8082/").update());
        SamlClientBuilder builder = new SamlClientBuilder();
        CreateArtifactMessageStepBuilder camb = new CreateArtifactMessageStepBuilder(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST, builder);
        ArtifactResolutionService ars = new ArtifactResolutionService("http://127.0.0.1:8082/").setEmptyArtifactResponse("http://localhost:8280/sales-post/");
        Thread arsThread = new Thread((Runnable)ars);
        try {
            arsThread.start();
            ArtifactResolutionService artifactResolutionService = ars;
            synchronized (artifactResolutionService) {
                ars.wait();
                builder.artifactMessage(camb).build().execute(r -> {
                    Assert.assertThat((Object)r, (Matcher)Matchers.statusCodeIsHC((int)400));
                    Assert.assertThat((Object)r, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"Unable to resolve artifact.")));
                });
            }
        }
        finally {
            ars.stop();
            arsThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveArtifactLogoutFullWithPost() throws InterruptedException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_artifact_resolution_service_url", "http://127.0.0.1:8082/").update());
        SamlClientBuilder builder = new SamlClientBuilder();
        CreateArtifactMessageStepBuilder camb = new CreateArtifactMessageStepBuilder(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST, builder);
        ArtifactResolutionService ars = new ArtifactResolutionService("http://127.0.0.1:8082/");
        Thread arsThread = new Thread((Runnable)ars);
        try {
            arsThread.start();
            ArtifactResolutionService artifactResolutionService = ars;
            synchronized (artifactResolutionService) {
                ars.wait();
                SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)builder.authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(x -> {
                    SAML2Object samlObj = this.extractNameIdAndSessionIndexAndTerminate(x);
                    this.setArtifactResolutionServiceLogoutRequest(ars);
                    return samlObj;
                })).build().artifactMessage(camb).build().getSamlResponse(SamlClient.Binding.POST);
                Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
                StatusResponseType srt = (StatusResponseType)samlResponse.getSamlObject();
                Assert.assertThat((Object)srt, (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
                Assert.assertThat((Object)camb.getLastArtifact(), (Matcher)org.hamcrest.Matchers.is((Object)ars.getLastArtifactResolve().getArtifact()));
            }
        }
        finally {
            ars.stop();
            arsThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveArtifactLogoutFullWithRedirect() throws InterruptedException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_artifact_resolution_service_url", "http://127.0.0.1:8082/").setAttribute("saml_single_logout_service_url_redirect", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SamlClientBuilder builder = new SamlClientBuilder();
        CreateArtifactMessageStepBuilder camb = new CreateArtifactMessageStepBuilder(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT, builder);
        ArtifactResolutionService ars = new ArtifactResolutionService("http://127.0.0.1:8082/");
        Thread arsThread = new Thread((Runnable)ars);
        try {
            arsThread.start();
            ArtifactResolutionService artifactResolutionService = ars;
            synchronized (artifactResolutionService) {
                ars.wait();
                SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)builder.authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(x -> {
                    SAML2Object samlObj = this.extractNameIdAndSessionIndexAndTerminate(x);
                    this.setArtifactResolutionServiceLogoutRequest(ars);
                    return samlObj;
                })).build().artifactMessage(camb).build().getSamlResponse(SamlClient.Binding.REDIRECT);
                Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
                StatusResponseType srt = (StatusResponseType)samlResponse.getSamlObject();
                Assert.assertThat((Object)srt, (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
                Assert.assertThat((Object)camb.getLastArtifact(), (Matcher)org.hamcrest.Matchers.is((Object)ars.getLastArtifactResolve().getArtifact()));
            }
        }
        finally {
            ars.stop();
            arsThread.join();
        }
    }

    private void setArtifactResolutionServiceLogoutRequest(ArtifactResolutionService ars) throws ParsingException, ConfigurationException, ProcessingException {
        SAML2LogoutRequestBuilder builder = new SAML2LogoutRequestBuilder().destination(this.getAuthServerSamlEndpoint("demo").toString()).issuer("http://localhost:8280/sales-post/").sessionIndex((String)this.sessionIndexRef.get());
        NameIDType nameIdValue = (NameIDType)this.nameIdRef.get();
        if (nameIdValue != null) {
            builder = builder.userPrincipal(nameIdValue.getValue(), nameIdValue.getFormat() == null ? null : nameIdValue.getFormat().toString());
        }
        ars.setResponseDocument(builder.buildDocument());
    }
}

