/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.ByteArrayInputStream;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.SetDefaultProvider;
import org.keycloak.testsuite.authentication.CustomTestingSamlArtifactResolver;
import org.keycloak.testsuite.saml.ArtifactBindingTest;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE}, details="currently remote doesn't support the SetDefaultProvider annotation")
@SetDefaultProvider(spi="saml-artifact-resolver", providerId="0005")
public class ArtifactBindingCustomResolverTest
extends ArtifactBindingTest {
    @Override
    @Test
    @Ignore
    public void testArtifactBindingLogoutSingleClientCheckArtifact() {
    }

    @Override
    @Test
    @Ignore
    public void testArtifactBindingLoginCheckArtifactWithPost() {
    }

    @Test
    public void testCustomArtifact() {
        AtomicReference artifactReference = new AtomicReference();
        new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").storeArtifact(artifactReference).build().execute();
        String artifact = (String)artifactReference.get();
        byte[] byteArray = Base64.getDecoder().decode(artifact);
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        bis.skip(2L);
        int index = bis.read();
        MatcherAssert.assertThat((Object)byteArray[0], (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)byteArray[1], (Matcher)Matchers.is((Object)5));
        if (!this.suiteContext.getAuthServerInfo().isUndertow()) {
            return;
        }
        String storedResponse = (String)CustomTestingSamlArtifactResolver.list.get(index);
        MatcherAssert.assertThat((Object)storedResponse, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)storedResponse, (Matcher)Matchers.containsString((String)"samlp:Response"));
    }

    @Test
    public void testArtifactDoesntContainSignature() {
        ContainerAssume.assumeAuthServerUndertow();
        AtomicReference artifactReference = new AtomicReference();
        new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-assertion-and-response-sig/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_ASSERTION_AND_RESPONSE_SIG, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-assertion-and-response-sig/").storeArtifact(artifactReference).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().execute();
        String artifact = (String)artifactReference.get();
        byte[] byteArray = Base64.getDecoder().decode(artifact);
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        bis.skip(2L);
        int index = bis.read();
        MatcherAssert.assertThat((Object)byteArray[0], (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)byteArray[1], (Matcher)Matchers.is((Object)5));
        String storedResponse = (String)CustomTestingSamlArtifactResolver.list.get(index);
        MatcherAssert.assertThat((Object)storedResponse, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)storedResponse, (Matcher)Matchers.containsString((String)"samlp:Response"));
        MatcherAssert.assertThat((Object)storedResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Signature")));
    }
}

