/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.runonserver;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunHelpers;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RunOnServerTest
extends AbstractKeycloakTest {
    @Test
    public void runOnServerString() {
        String string = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> "Hello world!", String.class);
        Assert.assertEquals((Object)"Hello world!", (Object)string);
    }

    @Test
    public void runOnServerRep() {
        String realmName = "master";
        RealmRepresentation realmRep = (RealmRepresentation)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            RealmModel master = session.realms().getRealm("master");
            return ModelToRepresentation.toRepresentation((KeycloakSession)session, (RealmModel)master, (boolean)true);
        }, RealmRepresentation.class);
        Assert.assertEquals((Object)"master", (Object)realmRep.getRealm());
    }

    @Test
    public void runOnServerHelpers() {
        RealmRepresentation realmRep = (RealmRepresentation)this.testingClient.server().fetch(RunHelpers.internalRealm());
        Assert.assertEquals((Object)"master", (Object)realmRep.getRealm());
    }

    @Test
    public void runOnServerNoResponse() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> System.out.println("Hello world!"));
    }

    @Test
    public void runOnServerAssertOnServer() {
        try {
            this.testingClient.server().run((RunOnServer & Serializable)session -> Assert.assertEquals((Object)"foo", (Object)"bar"));
            Assert.fail((String)"Expected exception");
        }
        catch (ComparisonFailure e) {
            Assert.assertEquals((Object)"expected:<[foo]> but was:<[bar]>", (Object)e.getMessage());
        }
    }

    @Test
    public void runOnServerExceptionOnServer() {
        try {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                throw new ModelException("Something went wrong");
            });
            Assert.fail((String)"Expected exception");
        }
        catch (RunOnServerException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ModelException));
            Assert.assertEquals((Object)"Something went wrong", (Object)e.getCause().getMessage());
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }
}

