/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.policy;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.RealmBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class PasswordPolicyTest
extends AbstractKeycloakTest {
    @Test
    public void testLength() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"length"));
            Assert.assertEquals((Object)"invalidPasswordMinLengthMessage", (Object)policyManager.validate("jdoe", "1234567").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{8}, (Object[])policyManager.validate("jdoe", "1234567").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "12345678"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"length(4)"));
            Assert.assertEquals((Object)"invalidPasswordMinLengthMessage", (Object)policyManager.validate("jdoe", "123").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{4}, (Object[])policyManager.validate("jdoe", "123").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "1234"));
        });
    }

    @Test
    public void testMaximumLength() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"maxLength"));
            Assert.assertEquals((Object)"invalidPasswordMaxLengthMessage", (Object)policyManager.validate("jdoe", "12345678901234567890123456789012345678901234567890123456789012345").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{64}, (Object[])policyManager.validate("jdoe", "12345678901234567890123456789012345678901234567890123456789012345").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "1234567890123456789012345678901234567890123456789012345678901234"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"maxLength(24)"));
            Assert.assertEquals((Object)"invalidPasswordMaxLengthMessage", (Object)policyManager.validate("jdoe", "1234567890123456789012345").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{24}, (Object[])policyManager.validate("jdoe", "1234567890123456789012345").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "123456789012345678901234"));
        });
    }

    @Test
    public void testDigits() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"digits"));
            Assert.assertEquals((Object)"invalidPasswordMinDigitsMessage", (Object)policyManager.validate("jdoe", "abcd").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{1}, (Object[])policyManager.validate("jdoe", "abcd").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "abcd1"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"digits(2)"));
            Assert.assertEquals((Object)"invalidPasswordMinDigitsMessage", (Object)policyManager.validate("jdoe", "abcd1").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{2}, (Object[])policyManager.validate("jdoe", "abcd1").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "abcd12"));
        });
    }

    @Test
    public void testLowerCase() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"lowerCase"));
            Assert.assertEquals((Object)"invalidPasswordMinLowerCaseCharsMessage", (Object)policyManager.validate("jdoe", "ABCD1234").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{1}, (Object[])policyManager.validate("jdoe", "ABCD1234").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "ABcD1234"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"lowerCase(2)"));
            Assert.assertEquals((Object)"invalidPasswordMinLowerCaseCharsMessage", (Object)policyManager.validate("jdoe", "ABcD1234").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{2}, (Object[])policyManager.validate("jdoe", "ABcD1234").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "aBcD1234"));
        });
    }

    @Test
    public void testUpperCase() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"upperCase"));
            Assert.assertEquals((Object)"invalidPasswordMinUpperCaseCharsMessage", (Object)policyManager.validate("jdoe", "abcd1234").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{1}, (Object[])policyManager.validate("jdoe", "abcd1234").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "abCd1234"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"upperCase(2)"));
            Assert.assertEquals((Object)"invalidPasswordMinUpperCaseCharsMessage", (Object)policyManager.validate("jdoe", "abCd1234").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{2}, (Object[])policyManager.validate("jdoe", "abCd1234").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "AbCd1234"));
        });
    }

    @Test
    public void testSpecialChars() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"specialChars"));
            Assert.assertEquals((Object)"invalidPasswordMinSpecialCharsMessage", (Object)policyManager.validate("jdoe", "abcd1234").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{1}, (Object[])policyManager.validate("jdoe", "abcd1234").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "ab&d1234"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"specialChars(2)"));
            Assert.assertEquals((Object)"invalidPasswordMinSpecialCharsMessage", (Object)policyManager.validate("jdoe", "ab&d1234").getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{2}, (Object[])policyManager.validate("jdoe", "ab&d1234").getParameters());
            Assert.assertNull((Object)policyManager.validate("jdoe", "ab&d-234"));
        });
    }

    @Test
    public void testBlacklistPasswordPolicyWithTestBlacklist() throws Exception {
        ContainerAssume.assumeNotAuthServerRemote();
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"passwordBlacklist(test-password-blacklist.txt)"));
            Assert.assertEquals((Object)"invalidPasswordBlacklistedMessage", (Object)policyManager.validate("jdoe", "blacklisted1").getMessage());
            Assert.assertEquals((Object)"invalidPasswordBlacklistedMessage", (Object)policyManager.validate("jdoe", "blacklisted2").getMessage());
            Assert.assertEquals((Object)"invalidPasswordBlacklistedMessage", (Object)policyManager.validate("jdoe", "bLaCkLiSteD2").getMessage());
            Assert.assertNull((Object)policyManager.validate("jdoe", "notblacklisted"));
        });
    }

    @Test
    public void testNotUsername() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"notUsername"));
            Assert.assertEquals((Object)"invalidPasswordNotUsernameMessage", (Object)policyManager.validate("jdoe", "jdoe").getMessage());
            Assert.assertNull((Object)policyManager.validate("jdoe", "ab&d1234"));
        });
    }

    @Test
    public void testInvalidPolicyName() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            try {
                realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"noSuchPolicy"));
                Assert.fail((String)"Expected exception");
            }
            catch (ModelException e) {
                Assert.assertEquals((Object)"Password policy not found", (Object)e.getMessage());
            }
        });
    }

    @Test
    public void testRegexPatterns() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            Object policy = null;
            try {
                realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern"));
                Assert.fail((String)"Expected NullPointerException: Regex Pattern cannot be null.");
            }
            catch (ModelException e) {
                Assert.assertEquals((Object)"Invalid config for regexPattern: Config required", (Object)e.getMessage());
            }
            try {
                realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern(*)"));
                Assert.fail((String)"Expected PatternSyntaxException: Regex Pattern cannot be null.");
            }
            catch (ModelException e) {
                Assert.assertEquals((Object)"Invalid config for regexPattern: Not a valid regular expression", (Object)e.getMessage());
            }
            try {
                realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern(*,**)"));
                Assert.fail((String)"Expected PatternSyntaxException: Regex Pattern cannot be null.");
            }
            catch (ModelException e) {
                Assert.assertEquals((Object)"Invalid config for regexPattern: Not a valid regular expression", (Object)e.getMessage());
            }
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern(jdoe) and regexPattern(j*d)"));
            Assert.assertEquals((Object)"invalidPasswordRegexPatternMessage", (Object)policyManager.validate("jdoe", "jdoe").getMessage());
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern(j*p) and regexPattern(j*d) and regexPattern(adoe)"));
            Assert.assertEquals((Object)"invalidPasswordRegexPatternMessage", (Object)policyManager.validate("jdoe", "jdoe").getMessage());
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern([a-z][a-z][a-z][a-z][0-9])"));
            Assert.assertEquals((Object)"invalidPasswordRegexPatternMessage", (Object)policyManager.validate("jdoe", "jdoe").getMessage());
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern(jdoe)"));
            Assert.assertNull((Object)policyManager.validate("jdoe", "jdoe"));
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"regexPattern([a-z][a-z][a-z][a-z][0-9])"));
            Assert.assertNull((Object)policyManager.validate("jdoe", "jdoe0"));
        });
    }

    @Test
    public void testComplex() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            PasswordPolicyManagerProvider policyManager = (PasswordPolicyManagerProvider)session.getProvider(PasswordPolicyManagerProvider.class);
            realmModel.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)"length(8) and maxLength(32) and digits(2) and lowerCase(2) and upperCase(2) and specialChars(2) and notUsername()"));
            Assert.assertNotNull((Object)policyManager.validate("jdoe", "12aaBB&"));
            Assert.assertNotNull((Object)policyManager.validate("jdoe", "aaaaBB&-"));
            Assert.assertNotNull((Object)policyManager.validate("jdoe", "12AABB&-"));
            Assert.assertNotNull((Object)policyManager.validate("jdoe", "12aabb&-"));
            Assert.assertNotNull((Object)policyManager.validate("jdoe", "12aaBBcc"));
            Assert.assertNotNull((Object)policyManager.validate("12aaBB&-", "12aaBB&-"));
            Assert.assertNotNull((Object)policyManager.validate("jdoe", "12aaBB&-12aaBB&-12aaBB&-12aaBB&-1"));
            Assert.assertNull((Object)policyManager.validate("jdoe", "12aaBB&-"));
        });
    }

    @Test
    public void testBuilder() {
        this.testingClient.server("passwordPolicy").run((RunOnServer & Serializable)session -> {
            PasswordPolicy.Builder builder = PasswordPolicy.parse((KeycloakSession)session, (String)"hashIterations(20000)").toBuilder();
            Assert.assertFalse((boolean)builder.contains("hashAlgorithm"));
            Assert.assertTrue((boolean)"20000".equals(builder.get("hashIterations")));
            builder.remove("hashIterations");
            Assert.assertNull((Object)builder.asString());
            builder = PasswordPolicy.parse((KeycloakSession)session, (String)"hashIterations(20000) and hashAlgorithm(pbkdf2)").toBuilder();
            Assert.assertTrue((boolean)builder.contains("hashAlgorithm"));
            builder = PasswordPolicy.parse((KeycloakSession)session, (String)"hashIterations(20000) and length(100)").toBuilder();
            builder.remove("hashIterations");
            Assert.assertEquals((Object)"length(100)", (Object)builder.asString());
            builder = PasswordPolicy.parse((KeycloakSession)session, (String)"digits(10) and hashIterations(20000) and length(100)").toBuilder();
            builder.remove("hashIterations");
            Assert.assertEquals((Object)"digits(10) and length(100)", (Object)builder.asString());
        });
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("passwordPolicy").build());
    }
}

